/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.profile.container.ProfileContainer;
import com.onarandombox.multiverseinventories.share.Sharable;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.share.Shares;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.event.EventPriority;

public final class WorldGroup {
    private final MultiverseInventories plugin;
    private final String name;
    private final HashSet<String> worlds = new HashSet();
    private final Shares shares = Sharables.noneOf();
    private String spawnWorld = null;
    private EventPriority spawnPriority = EventPriority.NORMAL;

    WorldGroup(MultiverseInventories inventories, String name) {
        this.plugin = inventories;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addWorld(String worldName) {
        this.addWorld(worldName, true);
    }

    public void addWorld(String worldName, boolean updateConfig) {
        this.getWorlds().add(worldName.toLowerCase());
        if (updateConfig) {
            this.plugin.getGroupManager().updateGroup(this);
        }
    }

    public void addWorld(World world) {
        this.addWorld(world.getName());
    }

    public void removeWorld(String worldName) {
        this.removeWorld(worldName, true);
    }

    public void removeWorld(String worldName, boolean updateConfig) {
        this.getWorlds().remove(worldName.toLowerCase());
        if (updateConfig) {
            this.plugin.getGroupManager().updateGroup(this);
        }
    }

    public void removeWorld(World world) {
        this.removeWorld(world.getName());
    }

    public Set<String> getWorlds() {
        return this.worlds;
    }

    public boolean isSharing(Sharable sharable) {
        return this.getShares().isSharing(sharable);
    }

    public Shares getShares() {
        return this.shares;
    }

    public boolean containsWorld(String worldName) {
        return this.getWorlds().contains(worldName.toLowerCase());
    }

    public String getSpawnWorld() {
        return this.spawnWorld;
    }

    public void setSpawnWorld(String worldName) {
        this.spawnWorld = worldName.toLowerCase();
    }

    public EventPriority getSpawnPriority() {
        return this.spawnPriority;
    }

    public void setSpawnPriority(EventPriority priority) {
        this.spawnPriority = priority;
    }

    public boolean isDefault() {
        return "default".equals(this.getName());
    }

    public ProfileContainer getGroupProfileContainer() {
        return this.plugin.getGroupProfileContainerStore().getContainer(this.getName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append(": {Worlds: [");
        String[] worldsString = this.getWorlds().toArray(new String[this.getWorlds().size()]);
        for (int i = 0; i < worldsString.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(worldsString[i]);
        }
        builder.append("], Shares: [").append(this.getShares().toString()).append("]");
        if (this.getSpawnWorld() != null) {
            builder.append(", Spawn World: ").append(this.getSpawnWorld());
            builder.append(", Spawn Priority: ").append(this.getSpawnPriority().toString());
        }
        builder.append("}");
        return builder.toString();
    }
}

