/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.ShareHandler;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.event.ShareHandlingEvent;
import com.onarandombox.multiverseinventories.event.WorldChangeShareHandlingEvent;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.profile.container.ProfileContainer;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.share.Shares;
import com.onarandombox.multiverseinventories.util.Perm;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.List;
import org.bukkit.entity.Player;

final class WorldChangeShareHandler
extends ShareHandler {
    private final String fromWorld;
    private final String toWorld;
    private final List<WorldGroup> fromWorldGroups;
    private final List<WorldGroup> toWorldGroups;

    WorldChangeShareHandler(MultiverseInventories inventories, Player player, String fromWorld, String toWorld) {
        super(inventories, player);
        this.fromWorld = fromWorld;
        this.toWorld = toWorld;
        this.fromWorldGroups = this.getAffectedWorldGroups(fromWorld);
        this.toWorldGroups = this.getAffectedWorldGroups(toWorld);
        this.prepareProfiles();
    }

    private List<WorldGroup> getAffectedWorldGroups(String world) {
        return this.inventories.getGroupManager().getGroupsForWorld(world);
    }

    @Override
    protected ShareHandlingEvent createEvent() {
        return new WorldChangeShareHandlingEvent(this.player, this.affectedProfiles, this.fromWorld, this.toWorld);
    }

    private void prepareProfiles() {
        InvLogging.finer("=== %s traveling from world: %s to world: %s ===", this.player.getName(), this.fromWorld, this.toWorld);
        this.setAlwaysWriteWorldProfile();
        if (this.isPlayerAffectedByChange()) {
            this.addProfiles();
        }
    }

    private void setAlwaysWriteWorldProfile() {
        PlayerProfile fromWorldProfile = this.getWorldPlayerProfile(this.fromWorld, this.player);
        this.setAlwaysWriteProfile(fromWorldProfile);
    }

    private PlayerProfile getWorldPlayerProfile(String world, Player player) {
        return this.getWorldProfile(world).getPlayerData(player);
    }

    private ProfileContainer getWorldProfile(String world) {
        return this.inventories.getWorldProfileContainerStore().getContainer(world);
    }

    private boolean isPlayerAffectedByChange() {
        if (this.isPlayerBypassingChange()) {
            this.logBypass();
            return false;
        }
        return true;
    }

    private boolean isPlayerBypassingChange() {
        return Perm.BYPASS_WORLD.hasBypass(this.player, this.fromWorld);
    }

    private void addProfiles() {
        this.addWriteProfiles();
        new ReadProfilesAggregator().addReadProfiles();
    }

    private void addWriteProfiles() {
        if (this.hasFromWorldGroups()) {
            this.fromWorldGroups.forEach(wg -> new WorldGroupWrapper((WorldGroup)wg).conditionallyAddWriteProfiles());
        } else {
            InvLogging.finer("No groups for fromWorld.", new Object[0]);
        }
    }

    private boolean hasFromWorldGroups() {
        return !this.fromWorldGroups.isEmpty();
    }

    private class WorldGroupWrapper {
        private final WorldGroup worldGroup;

        public WorldGroupWrapper(WorldGroup worldGroup) {
            this.worldGroup = worldGroup;
        }

        private void conditionallyAddWriteProfiles() {
            if (this.isEligibleForWrite()) {
                this.addWriteProfiles();
            }
        }

        boolean isEligibleForWrite() {
            return this.groupDoesNotContainWorld(WorldChangeShareHandler.this.toWorld) || this.isNotSharingAll();
        }

        private boolean groupDoesNotContainWorld(String world) {
            return !this.worldGroup.containsWorld(world);
        }

        private boolean isNotSharingAll() {
            return !this.worldGroup.getShares().isSharing(Sharables.all());
        }

        void addWriteProfiles() {
            ProfileContainer container = this.worldGroup.getGroupProfileContainer();
            WorldChangeShareHandler.this.affectedProfiles.addWriteProfile(container.getPlayerData(WorldChangeShareHandler.this.player), this.getWorldGroupShares());
        }

        private Shares getWorldGroupShares() {
            return Sharables.fromShares(this.worldGroup.getShares());
        }
    }

    private class ReadProfilesAggregator {
        private Shares sharesToRead;

        private ReadProfilesAggregator() {
        }

        private void addReadProfiles() {
            this.sharesToRead = Sharables.noneOf();
            this.addReadProfilesFromToWorldGroups();
            this.useToWorldForMissingShares();
        }

        private void addReadProfilesFromToWorldGroups() {
            if (this.hasToWorldGroups()) {
                WorldChangeShareHandler.this.toWorldGroups.forEach(this::conditionallyAddReadProfileForWorldGroup);
            } else {
                InvLogging.finer("No groups for toWorld.", new Object[0]);
            }
        }

        private boolean hasToWorldGroups() {
            return !WorldChangeShareHandler.this.toWorldGroups.isEmpty();
        }

        private void conditionallyAddReadProfileForWorldGroup(WorldGroup worldGroup) {
            if (this.isPlayerAffectedByChange(worldGroup)) {
                if (this.isFromWorldNotInToWorldGroup(worldGroup)) {
                    this.addReadProfileForWorldGroup(worldGroup);
                } else {
                    this.sharesToRead.addAll(worldGroup.getShares());
                }
            }
        }

        private boolean isPlayerAffectedByChange(WorldGroup worldGroup) {
            if (this.isPlayerBypassingChange(worldGroup)) {
                WorldChangeShareHandler.this.logBypass();
                return false;
            }
            return true;
        }

        private boolean isPlayerBypassingChange(WorldGroup worldGroup) {
            return Perm.BYPASS_GROUP.hasBypass(WorldChangeShareHandler.this.player, worldGroup.getName());
        }

        private boolean isFromWorldNotInToWorldGroup(WorldGroup worldGroup) {
            return !worldGroup.containsWorld(WorldChangeShareHandler.this.fromWorld);
        }

        private void addReadProfileForWorldGroup(WorldGroup worldGroup) {
            PlayerProfile playerProfile = this.getWorldGroupPlayerData(worldGroup);
            Shares sharesToAdd = this.getWorldGroupShares(worldGroup);
            WorldChangeShareHandler.this.addReadProfile(playerProfile, sharesToAdd);
            this.sharesToRead.addAll(sharesToAdd);
        }

        private PlayerProfile getWorldGroupPlayerData(WorldGroup worldGroup) {
            return this.getWorldGroupProfileContainer(worldGroup).getPlayerData(WorldChangeShareHandler.this.player);
        }

        private ProfileContainer getWorldGroupProfileContainer(WorldGroup worldGroup) {
            return worldGroup.getGroupProfileContainer();
        }

        private Shares getWorldGroupShares(WorldGroup worldGroup) {
            return Sharables.fromShares(worldGroup.getShares());
        }

        private void useToWorldForMissingShares() {
            if (this.hasUnhandledShares()) {
                this.addUnhandledSharesFromToWorld();
            }
        }

        private boolean hasUnhandledShares() {
            return !this.sharesToRead.isSharing(Sharables.all());
        }

        private void addUnhandledSharesFromToWorld() {
            Shares unhandledShares = Sharables.complimentOf(this.sharesToRead);
            InvLogging.finer("%s are left unhandled, defaulting to toWorld", unhandledShares);
            WorldChangeShareHandler.this.addReadProfile(this.getToWorldPlayerData(), unhandledShares);
        }

        private PlayerProfile getToWorldPlayerData() {
            return this.getToWorldProfileContainer().getPlayerData(WorldChangeShareHandler.this.player);
        }

        private ProfileContainer getToWorldProfileContainer() {
            return WorldChangeShareHandler.this.inventories.getWorldProfileContainerStore().getContainer(WorldChangeShareHandler.this.toWorld);
        }
    }
}

