/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.profile.ProfileDataSource;
import com.onarandombox.multiverseinventories.profile.ProfileType;
import com.onarandombox.multiverseinventories.profile.ProfileTypes;
import com.onarandombox.multiverseinventories.profile.WorldGroupManager;
import com.onarandombox.multiverseinventories.profile.container.ContainerType;
import com.onarandombox.multiverseinventories.profile.container.ProfileContainer;
import com.onarandombox.multiverseinventories.profile.container.ProfileContainerStore;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

final class WeakProfileContainer
implements ProfileContainer {
    private Map<String, Map<ProfileType, PlayerProfile>> playerData = new WeakHashMap<String, Map<ProfileType, PlayerProfile>>();
    private final MultiverseInventories inventories;
    private final String name;
    private final ContainerType type;

    WeakProfileContainer(MultiverseInventories inventories, String name, ContainerType type) {
        this.inventories = inventories;
        this.name = name;
        this.type = type;
    }

    protected Map<ProfileType, PlayerProfile> getPlayerData(String name) {
        return this.playerData.computeIfAbsent(name, k -> new HashMap());
    }

    protected ProfileDataSource getDataSource() {
        return this.getInventories().getData();
    }

    protected WorldGroupManager getGroupManager() {
        return this.getInventories().getGroupManager();
    }

    protected ProfileContainerStore getProfileManager() {
        return this.getInventories().getWorldProfileContainerStore();
    }

    protected MultiverseInventories getInventories() {
        return this.inventories;
    }

    @Override
    public PlayerProfile getPlayerData(Player player) {
        ProfileType type = this.inventories.getMVIConfig().isUsingGameModeProfiles() ? ProfileTypes.forGameMode(player.getGameMode()) : ProfileTypes.SURVIVAL;
        return this.getPlayerData(type, (OfflinePlayer)player);
    }

    @Override
    public PlayerProfile getPlayerData(ProfileType profileType, OfflinePlayer player) {
        Map<ProfileType, PlayerProfile> profileMap = this.getPlayerData(player.getName());
        PlayerProfile playerProfile = profileMap.get(profileType);
        if (playerProfile == null) {
            playerProfile = this.getDataSource().getPlayerData(this.getContainerType(), this.getContainerName(), profileType, player.getUniqueId());
            InvLogging.finer("[%s - %s - %s - %s] not cached, loading from disk...", new Object[]{profileType, this.getContainerType(), playerProfile.getContainerName(), player.getName()});
            profileMap.put(profileType, playerProfile);
        }
        return playerProfile;
    }

    @Override
    public void addPlayerData(PlayerProfile playerProfile) {
        this.getPlayerData(playerProfile.getPlayer().getName()).put(playerProfile.getProfileType(), playerProfile);
    }

    @Override
    public void removeAllPlayerData(OfflinePlayer player) {
        this.getPlayerData(player.getName()).clear();
        this.getDataSource().removePlayerData(this.getContainerType(), this.getContainerName(), null, player.getName());
    }

    @Override
    public void removePlayerData(ProfileType profileType, OfflinePlayer player) {
        this.getPlayerData(player.getName()).remove(profileType);
        this.getDataSource().removePlayerData(this.getContainerType(), this.getContainerName(), profileType, player.getName());
    }

    @Override
    public String getContainerName() {
        return this.name;
    }

    @Override
    public ContainerType getContainerType() {
        return this.type;
    }
}

