/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.profile.container.ContainerType;
import com.onarandombox.multiverseinventories.share.PersistingProfile;
import com.onarandombox.multiverseinventories.share.Sharable;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;

class ShareHandlingUpdater {
    private final MultiverseInventories inventories;
    private final Player player;
    private final PersistingProfile profile;
    private final List<Sharable<?>> saved = new ArrayList(Sharables.all().size());
    private final List<Sharable<?>> loaded = new ArrayList(Sharables.all().size());
    private final List<Sharable<?>> defaulted = new ArrayList(Sharables.all().size());

    static void updateProfile(MultiverseInventories inventories, Player player, PersistingProfile profile) {
        new ShareHandlingUpdater(inventories, player, profile).updateProfile();
    }

    static void updatePlayer(MultiverseInventories inventories, Player player, PersistingProfile profile) {
        new ShareHandlingUpdater(inventories, player, profile).updatePlayer();
    }

    private ShareHandlingUpdater(MultiverseInventories inventories, Player player, PersistingProfile profile) {
        this.inventories = inventories;
        this.player = player;
        this.profile = profile;
    }

    private void updateProfile() {
        for (Sharable sharable : this.profile.getShares()) {
            if (!this.isSharableUsed(sharable)) continue;
            this.saved.add(sharable);
            sharable.getHandler().updateProfile(this.profile.getProfile(), this.player);
        }
        if (this.saved.size() > 0) {
            InvLogging.finer("Persisted: " + StringUtils.join(this.saved, (String)", ") + " to " + (Object)((Object)this.profile.getProfile().getContainerType()) + ":" + this.profile.getProfile().getContainerName() + " (" + this.profile.getProfile().getProfileType() + ") for player " + this.profile.getProfile().getPlayer().getName(), new Object[0]);
        }
        this.inventories.getData().updatePlayerData(this.profile.getProfile());
    }

    private void updatePlayer() {
        this.player.closeInventory();
        for (Sharable sharable : this.profile.getShares()) {
            if (!this.isSharableUsed(sharable)) continue;
            if (sharable.getHandler().updatePlayer(this.player, this.profile.getProfile())) {
                this.loaded.add(sharable);
                continue;
            }
            this.defaulted.add(sharable);
        }
        if (!this.loaded.isEmpty()) {
            InvLogging.finer("Updated: " + this.loaded.toString() + " for " + this.profile.getProfile().getPlayer().getName() + " for " + (Object)((Object)this.profile.getProfile().getContainerType()) + ":" + this.profile.getProfile().getContainerName() + " (" + this.profile.getProfile().getProfileType() + ")", new Object[0]);
        }
        if (!this.defaulted.isEmpty()) {
            InvLogging.finer("Defaulted: " + this.defaulted.toString() + " for " + this.profile.getProfile().getPlayer().getName() + " for " + (Object)((Object)this.profile.getProfile().getContainerType()) + ":" + this.profile.getProfile().getContainerName() + " (" + this.profile.getProfile().getProfileType() + ")", new Object[0]);
        }
    }

    private boolean isSharableUsed(Sharable<?> sharable) {
        if (sharable.isOptional()) {
            if (!this.inventories.getMVIConfig().getOptionalShares().contains(sharable)) {
                InvLogging.finest("Ignoring optional share: " + sharable.getNames()[0], new Object[0]);
                return false;
            }
            if (this.profile.getProfile().getContainerType() == ContainerType.WORLD && !this.inventories.getMVIConfig().usingOptionalsForUngrouped()) {
                InvLogging.finest("Ignoring optional share '" + sharable.getNames()[0] + "' for ungrouped world!", new Object[0]);
                return false;
            }
        }
        return true;
    }
}

