/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.DefaultPersistingProfile;
import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.ShareHandlingUpdater;
import com.onarandombox.multiverseinventories.event.ShareHandlingEvent;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.share.PersistingProfile;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.share.Shares;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class ShareHandler {
    protected final MultiverseInventories inventories;
    protected final Player player;
    final AffectedProfiles affectedProfiles;

    ShareHandler(MultiverseInventories inventories, Player player) {
        this.inventories = inventories;
        this.player = player;
        this.affectedProfiles = new AffectedProfiles();
    }

    final void handleSharing() {
        ShareHandlingEvent event = this.createEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.completeSharing(event);
        }
    }

    protected final void setAlwaysWriteProfile(PlayerProfile profile) {
        this.affectedProfiles.setAlwaysWriteProfile(profile);
    }

    protected final void addWriteProfile(PlayerProfile profile, Shares shares) {
        this.affectedProfiles.addWriteProfile(profile, shares);
    }

    protected final void addReadProfile(PlayerProfile profile, Shares shares) {
        this.affectedProfiles.addReadProfile(profile, shares);
    }

    protected abstract ShareHandlingEvent createEvent();

    protected void logBypass() {
        InvLogging.fine(this.player.getName() + " has bypass permission for 1 or more world/groups!", new Object[0]);
    }

    private void completeSharing(ShareHandlingEvent event) {
        this.logAffectedProfilesCount(event);
        this.saveAlwaysWriteProfile(event);
        this.handleProfileChanges(event);
        this.logHandlingComplete(event);
    }

    private void logAffectedProfilesCount(ShareHandlingEvent event) {
        PersistingProfile alwaysWriteProfile = event.getAlwaysWriteProfile();
        int writeProfiles = event.getWriteProfiles().size() + (alwaysWriteProfile != null ? 1 : 0);
        InvLogging.finer("Change affected by %d fromProfiles and %d toProfiles", writeProfiles, event.getReadProfiles().size());
    }

    private void saveAlwaysWriteProfile(ShareHandlingEvent event) {
        if (event.getAlwaysWriteProfile() != null) {
            ShareHandlingUpdater.updateProfile(this.inventories, event.getPlayer(), event.getAlwaysWriteProfile());
        } else {
            InvLogging.warning("No fromWorld to save to", new Object[0]);
        }
    }

    private void handleProfileChanges(ShareHandlingEvent event) {
        if (event.getReadProfiles().isEmpty()) {
            InvLogging.finest("No profiles to read from - nothing more to do.", new Object[0]);
        } else {
            this.updateProfiles(event.getPlayer(), event.getWriteProfiles());
            this.updatePlayer(event.getPlayer(), event.getReadProfiles());
        }
    }

    private void updateProfiles(Player player, List<PersistingProfile> writeProfiles) {
        for (PersistingProfile writeProfile : writeProfiles) {
            ShareHandlingUpdater.updateProfile(this.inventories, player, writeProfile);
        }
    }

    private void updatePlayer(Player player, List<PersistingProfile> readProfiles) {
        for (PersistingProfile readProfile : readProfiles) {
            ShareHandlingUpdater.updatePlayer(this.inventories, player, readProfile);
        }
    }

    private void logHandlingComplete(ShareHandlingEvent event) {
        InvLogging.finer("=== %s complete for %s ===", event.getPlayer().getName(), event.getEventName());
    }

    public static class AffectedProfiles {
        private PersistingProfile alwaysWriteProfile;
        private final List<PersistingProfile> writeProfiles = new LinkedList<PersistingProfile>();
        private final List<PersistingProfile> readProfiles = new LinkedList<PersistingProfile>();

        AffectedProfiles() {
        }

        protected final void setAlwaysWriteProfile(PlayerProfile profile) {
            this.alwaysWriteProfile = new DefaultPersistingProfile(Sharables.allOf(), profile);
        }

        protected final void addWriteProfile(PlayerProfile profile, Shares shares) {
            this.writeProfiles.add(new DefaultPersistingProfile(shares, profile));
        }

        protected final void addReadProfile(PlayerProfile profile, Shares shares) {
            this.readProfiles.add(new DefaultPersistingProfile(shares, profile));
        }

        public PersistingProfile getAlwaysWriteProfile() {
            return this.alwaysWriteProfile;
        }

        public List<PersistingProfile> getWriteProfiles() {
            return this.writeProfiles;
        }

        public List<PersistingProfile> getReadProfiles() {
            return this.readProfiles;
        }
    }
}

