/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVPlugin;
import com.onarandombox.MultiverseCore.commands.HelpCommand;
import com.onarandombox.commandhandler.CommandHandler;
import com.onarandombox.multiverseinventories.AdventureListener;
import com.onarandombox.multiverseinventories.CoreDebugListener;
import com.onarandombox.multiverseinventories.DefaultMessager;
import com.onarandombox.multiverseinventories.DefaultPersistingProfile;
import com.onarandombox.multiverseinventories.FlatFileProfileDataSource;
import com.onarandombox.multiverseinventories.InventoriesConfig;
import com.onarandombox.multiverseinventories.InventoriesDupingPatch;
import com.onarandombox.multiverseinventories.InventoriesListener;
import com.onarandombox.multiverseinventories.ShareHandlingUpdater;
import com.onarandombox.multiverseinventories.WeakProfileContainerStore;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.YamlWorldGroupManager;
import com.onarandombox.multiverseinventories.command.AddSharesCommand;
import com.onarandombox.multiverseinventories.command.AddWorldCommand;
import com.onarandombox.multiverseinventories.command.CreateGroupCommand;
import com.onarandombox.multiverseinventories.command.DeleteGroupCommand;
import com.onarandombox.multiverseinventories.command.GroupCommand;
import com.onarandombox.multiverseinventories.command.ImportCommand;
import com.onarandombox.multiverseinventories.command.InfoCommand;
import com.onarandombox.multiverseinventories.command.ListCommand;
import com.onarandombox.multiverseinventories.command.MigrateCommand;
import com.onarandombox.multiverseinventories.command.ReloadCommand;
import com.onarandombox.multiverseinventories.command.RemoveSharesCommand;
import com.onarandombox.multiverseinventories.command.RemoveWorldCommand;
import com.onarandombox.multiverseinventories.command.SpawnCommand;
import com.onarandombox.multiverseinventories.command.ToggleCommand;
import com.onarandombox.multiverseinventories.locale.Message;
import com.onarandombox.multiverseinventories.locale.Messager;
import com.onarandombox.multiverseinventories.locale.Messaging;
import com.onarandombox.multiverseinventories.migration.ImportManager;
import com.onarandombox.multiverseinventories.profile.ProfileDataSource;
import com.onarandombox.multiverseinventories.profile.WorldGroupManager;
import com.onarandombox.multiverseinventories.profile.container.ContainerType;
import com.onarandombox.multiverseinventories.profile.container.ProfileContainerStore;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.util.Perm;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import me.drayshak.WorldInventories.WorldInventories;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import uk.co.tggl.pluckerpluck.multiinv.MultiInv;

public class MultiverseInventories
extends JavaPlugin
implements MVPlugin,
Messaging {
    private static MultiverseInventories inventoriesPlugin;
    private final int requiresProtocol = 22;
    private final InventoriesListener inventoriesListener = new InventoriesListener(this);
    private final AdventureListener adventureListener = new AdventureListener(this);
    private Messager messager = new DefaultMessager(this);
    private WorldGroupManager worldGroupManager = null;
    private ProfileContainerStore worldProfileContainerStore = null;
    private ProfileContainerStore groupProfileContainerStore = null;
    private ImportManager importManager = new ImportManager(this);
    private CommandHandler commandHandler = null;
    private MultiverseCore core = null;
    private InventoriesConfig config = null;
    private FlatFileProfileDataSource data = null;
    private InventoriesDupingPatch dupingPatch;
    private File serverFolder = new File(System.getProperty("user.dir"));

    public static MultiverseInventories getPlugin() {
        return inventoriesPlugin;
    }

    public MultiverseInventories() {
        inventoriesPlugin = this;
    }

    public MultiverseInventories(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        super(loader, description, dataFolder, file);
        inventoriesPlugin = this;
    }

    public void onDisable() {
        for (Player player : this.getServer().getOnlinePlayers()) {
            String world = player.getWorld().getName();
            if (!this.getMVIConfig().usingLoggingSaveLoad()) continue;
            ShareHandlingUpdater.updateProfile(this, player, new DefaultPersistingProfile(Sharables.allOf(), this.getWorldProfileContainerStore().getContainer(world).getPlayerData(player)));
            this.getData().setLoadOnLogin(player.getName(), true);
        }
        this.dupingPatch.disable();
        InvLogging.shutdown();
    }

    public void onEnable() {
        InvLogging.init((Plugin)this);
        Perm.register(this);
        MultiverseCore mvCore = (MultiverseCore)this.getServer().getPluginManager().getPlugin("Multiverse-Core");
        if (mvCore == null) {
            InvLogging.severe("Multiverse-Core not found, disabling...", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setCore(mvCore);
        if (this.getCore().getProtocolVersion() < this.getRequiredProtocol()) {
            InvLogging.severe("Your Multiverse-Core is OUT OF DATE", new Object[0]);
            InvLogging.severe("This version of Multiverse-Inventories requires Protocol Level: " + this.getRequiredProtocol(), new Object[0]);
            InvLogging.severe("Your of Core Protocol Level is: " + this.getCore().getProtocolVersion(), new Object[0]);
            InvLogging.severe("Grab an updated copy at: ", new Object[0]);
            InvLogging.severe("http://bukkit.onarandombox.com/?dir=multiverse-core", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.reloadConfig();
        try {
            this.getMessager().setLocale(new Locale(this.getMVIConfig().getLocale()));
        }
        catch (IllegalArgumentException e) {
            InvLogging.severe(e.getMessage(), new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        InvLogging.setDebugLevel(this.getCore().getMVConfig().getGlobalDebug());
        this.getCore().incrementPluginCount();
        Bukkit.getPluginManager().registerEvents((Listener)this.inventoriesListener, (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("Multiverse-Adventure") != null) {
            Bukkit.getPluginManager().registerEvents((Listener)this.adventureListener, (Plugin)this);
        }
        if (this.getCore().getProtocolVersion() >= 24) {
            new CoreDebugListener(this);
        }
        this.registerCommands();
        this.hookImportables();
        Sharables.init(this);
        this.dupingPatch = InventoriesDupingPatch.enableDupingPatch((Plugin)this);
        InvLogging.log(true, Level.INFO, "enabled.", new Object[0]);
    }

    private void registerCommands() {
        this.commandHandler = this.getCore().getCommandHandler();
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new InfoCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new ImportCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new ListCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new ReloadCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new AddWorldCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new RemoveWorldCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new AddSharesCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new RemoveSharesCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new CreateGroupCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new DeleteGroupCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new SpawnCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new GroupCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new ToggleCommand(this));
        this.getCommandHandler().registerCommand((com.onarandombox.commandhandler.Command)new MigrateCommand(this));
        for (com.onarandombox.commandhandler.Command c : this.commandHandler.getAllCommands()) {
            if (!(c instanceof HelpCommand)) continue;
            c.addKey("mvinv");
        }
    }

    private void hookImportables() {
        PluginManager pm = Bukkit.getPluginManager();
        Plugin plugin = pm.getPlugin("MultiInv");
        if (plugin != null) {
            this.getImportManager().hookMultiInv((MultiInv)plugin);
        }
        if ((plugin = pm.getPlugin("WorldInventories")) != null) {
            this.getImportManager().hookWorldInventories((WorldInventories)plugin);
        }
    }

    public ImportManager getImportManager() {
        return this.importManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (!this.isEnabled()) {
            sender.sendMessage("This plugin is Disabled!");
            return true;
        }
        ArrayList<String> allArgs = new ArrayList<String>(Arrays.asList(args));
        allArgs.add(0, command.getName());
        return this.getCommandHandler().locateAndRunCommand(sender, allArgs);
    }

    private CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public void log(Level level, String msg) {
        InvLogging.log(level, msg, new Object[0]);
    }

    public MultiverseCore getCore() {
        return this.core;
    }

    public void setCore(MultiverseCore core) {
        this.core = core;
    }

    public int getProtocolVersion() {
        return 1;
    }

    public String dumpVersionInfo(String buffer) {
        buffer = buffer + this.logAndAddToPasteBinBuffer("=== Settings ===");
        buffer = buffer + this.logAndAddToPasteBinBuffer("First Run: " + this.getMVIConfig().isFirstRun());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Using Bypass: " + this.getMVIConfig().isUsingBypass());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Default Ungrouped Worlds: " + this.getMVIConfig().isDefaultingUngroupedWorlds());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Save and Load on Log In and Out: " + this.getMVIConfig().usingLoggingSaveLoad());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Using GameMode Profiles: " + this.getMVIConfig().isUsingGameModeProfiles());
        buffer = buffer + this.logAndAddToPasteBinBuffer("=== Shares ===");
        buffer = buffer + this.logAndAddToPasteBinBuffer("Optionals for Ungrouped Worlds: " + this.getMVIConfig().usingOptionalsForUngrouped());
        buffer = buffer + this.logAndAddToPasteBinBuffer("Enabled Optionals: " + this.getMVIConfig().getOptionalShares());
        buffer = buffer + this.logAndAddToPasteBinBuffer("=== Groups ===");
        for (WorldGroup group : this.getGroupManager().getGroups()) {
            buffer = buffer + this.logAndAddToPasteBinBuffer(group.toString());
        }
        return buffer;
    }

    public String getVersionInfo() {
        StringBuilder versionInfo = new StringBuilder("[Multiverse-Inventories] Multiverse-Inventories Version: " + this.getDescription().getVersion() + '\n' + "[Multiverse-Inventories] === Settings ===" + '\n' + "[Multiverse-Inventories] First Run: " + this.getMVIConfig().isFirstRun() + '\n' + "[Multiverse-Inventories] Using Bypass: " + this.getMVIConfig().isUsingBypass() + '\n' + "[Multiverse-Inventories] Default Ungrouped Worlds: " + this.getMVIConfig().isDefaultingUngroupedWorlds() + '\n' + "[Multiverse-Inventories] Save and Load on Log In and Out: " + this.getMVIConfig().usingLoggingSaveLoad() + '\n' + "[Multiverse-Inventories] Using GameMode Profiles: " + this.getMVIConfig().isUsingGameModeProfiles() + '\n' + "[Multiverse-Inventories] === Shares ===" + '\n' + "[Multiverse-Inventories] Optionals for Ungrouped Worlds: " + this.getMVIConfig().usingOptionalsForUngrouped() + '\n' + "[Multiverse-Inventories] Enabled Optionals: " + this.getMVIConfig().getOptionalShares() + '\n' + "[Multiverse-Inventories] === Groups ===" + '\n');
        for (WorldGroup group : this.getGroupManager().getGroups()) {
            versionInfo.append("[Multiverse-Inventories] ").append(group.toString()).append('\n');
        }
        return versionInfo.toString();
    }

    private String logAndAddToPasteBinBuffer(String string) {
        InvLogging.info(string, new Object[0]);
        return InvLogging.getPrefixedMessage(string + '\n', false);
    }

    public InventoriesConfig getMVIConfig() {
        return this.config;
    }

    public void reloadConfig() {
        try {
            this.config = new InventoriesConfig(this);
            this.worldGroupManager = new YamlWorldGroupManager(this, new File(this.getDataFolder(), "groups.yml"), (Configuration)this.config.getConfig());
            this.worldProfileContainerStore = new WeakProfileContainerStore(this, ContainerType.WORLD);
            this.groupProfileContainerStore = new WeakProfileContainerStore(this, ContainerType.GROUP);
            if (this.data != null) {
                this.data.clearCache();
            }
            InvLogging.fine("Loaded config file!", new Object[0]);
        }
        catch (IOException e) {
            InvLogging.severe(this.getMessager().getMessage(Message.ERROR_CONFIG_LOAD, new Object[0]), new Object[0]);
            InvLogging.severe(e.getMessage(), new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                if (MultiverseInventories.this.getMVIConfig().isFirstRun()) {
                    InvLogging.info("First run!", new Object[0]);
                    if (MultiverseInventories.this.getGroupManager().getGroups().isEmpty()) {
                        MultiverseInventories.this.getGroupManager().createDefaultGroup();
                    }
                }
                MultiverseInventories.this.getGroupManager().checkForConflicts(null);
            }
        }, 1L);
    }

    public ProfileDataSource getData() {
        if (this.data == null) {
            try {
                this.data = new FlatFileProfileDataSource(this);
            }
            catch (IOException e) {
                InvLogging.severe(this.getMessager().getMessage(Message.ERROR_DATA_LOAD, new Object[0]), new Object[0]);
                InvLogging.severe(e.getMessage(), new Object[0]);
                Bukkit.getPluginManager().disablePlugin((Plugin)this);
                return null;
            }
        }
        return this.data;
    }

    @Override
    public Messager getMessager() {
        return this.messager;
    }

    @Override
    public void setMessager(Messager messager) {
        if (messager == null) {
            throw new IllegalArgumentException("The new messager can't be null!");
        }
        this.messager = messager;
    }

    public int getRequiredProtocol() {
        return this.requiresProtocol;
    }

    public WorldGroupManager getGroupManager() {
        return this.worldGroupManager;
    }

    public ProfileContainerStore getWorldProfileContainerStore() {
        return this.worldProfileContainerStore;
    }

    public ProfileContainerStore getGroupProfileContainerStore() {
        return this.groupProfileContainerStore;
    }

    public File getServerFolder() {
        return this.serverFolder;
    }

    public void setServerFolder(File newServerFolder) {
        if (!newServerFolder.isDirectory()) {
            throw new IllegalArgumentException("That's not a folder!");
        }
        this.serverFolder = newServerFolder;
    }
}

