/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.event.MVConfigReloadEvent;
import com.onarandombox.MultiverseCore.event.MVVersionEvent;
import com.onarandombox.multiverseinventories.DefaultPersistingProfile;
import com.onarandombox.multiverseinventories.GameModeShareHandler;
import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.ShareHandlingUpdater;
import com.onarandombox.multiverseinventories.WorldChangeShareHandler;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.profile.GlobalProfile;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.profile.container.ProfileContainer;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import me.drayshak.WorldInventories.WorldInventories;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import uk.co.tggl.pluckerpluck.multiinv.MultiInv;

public class InventoriesListener
implements Listener {
    private MultiverseInventories inventories;
    private List<WorldGroup> currentGroups;
    private Location spawnLoc = null;

    public InventoriesListener(MultiverseInventories inventories) {
        this.inventories = inventories;
    }

    @EventHandler
    public void versionRequest(MVVersionEvent event) {
        event.appendVersionInfo(this.inventories.getVersionInfo());
        File configFile = new File(this.inventories.getDataFolder(), "config.yml");
        File groupsFile = new File(this.inventories.getDataFolder(), "groups.yml");
        event.putDetailedVersionInfo("multiverse-inventories/config.yml", configFile);
        event.putDetailedVersionInfo("multiverse-inventories/groups.yml", groupsFile);
    }

    @EventHandler
    public void configReload(MVConfigReloadEvent event) {
        this.inventories.reloadConfig();
        event.addConfig("Multiverse-Inventories - config.yml");
    }

    @EventHandler
    public void pluginEnable(PluginEnableEvent event) {
        try {
            if (event.getPlugin() instanceof MultiInv) {
                this.inventories.getImportManager().hookMultiInv((MultiInv)event.getPlugin());
            } else if (event.getPlugin() instanceof WorldInventories) {
                this.inventories.getImportManager().hookWorldInventories((WorldInventories)event.getPlugin());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @EventHandler
    public void pluginDisable(PluginDisableEvent event) {
        try {
            if (event.getPlugin() instanceof MultiInv) {
                this.inventories.getImportManager().unHookMultiInv();
            } else if (event.getPlugin() instanceof WorldInventories) {
                this.inventories.getImportManager().unHookWorldInventories();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerPreLogin(AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        GlobalProfile globalProfile = this.inventories.getData().getGlobalProfile(event.getName(), event.getUniqueId());
        if (!globalProfile.getLastKnownName().equalsIgnoreCase(event.getName())) {
            try {
                this.inventories.getData().migratePlayerData(globalProfile.getLastKnownName(), event.getName(), event.getUniqueId(), true);
            }
            catch (IOException e) {
                InvLogging.severe("Could not migrate data from name " + globalProfile.getLastKnownName() + " to " + event.getName(), new Object[0]);
                e.printStackTrace();
            }
            globalProfile.setLastKnownName(event.getName());
            this.inventories.getData().updateGlobalProfile(globalProfile);
        }
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        GlobalProfile globalProfile = this.inventories.getData().getGlobalProfile(player.getName(), player.getUniqueId());
        String world = globalProfile.getLastWorld();
        if (this.inventories.getMVIConfig().usingLoggingSaveLoad() && globalProfile.shouldLoadOnLogin()) {
            ShareHandlingUpdater.updatePlayer(this.inventories, player, new DefaultPersistingProfile(Sharables.allOf(), this.inventories.getWorldProfileContainerStore().getContainer(world).getPlayerData(player)));
        }
        this.inventories.getData().setLoadOnLogin(player.getName(), false);
        this.verifyCorrectWorld(player, player.getWorld().getName(), globalProfile);
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String world = event.getPlayer().getWorld().getName();
        this.inventories.getData().updateLastWorld(player.getName(), world);
        if (this.inventories.getMVIConfig().usingLoggingSaveLoad()) {
            ShareHandlingUpdater.updateProfile(this.inventories, player, new DefaultPersistingProfile(Sharables.allOf(), this.inventories.getWorldProfileContainerStore().getContainer(world).getPlayerData(player)));
            this.inventories.getData().setLoadOnLogin(player.getName(), true);
        }
    }

    private void verifyCorrectWorld(Player player, String world, GlobalProfile globalProfile) {
        if (globalProfile.getLastWorld() == null) {
            this.inventories.getData().updateLastWorld(player.getName(), world);
        } else if (!world.equals(globalProfile.getLastWorld())) {
            InvLogging.fine("Player did not spawn in the world they were last reported to be in!", new Object[0]);
            new WorldChangeShareHandler(this.inventories, player, globalProfile.getLastWorld(), world).handleSharing();
            this.inventories.getData().updateLastWorld(player.getName(), world);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerGameModeChange(PlayerGameModeChangeEvent event) {
        if (event.isCancelled() || !this.inventories.getMVIConfig().isUsingGameModeProfiles()) {
            return;
        }
        Player player = event.getPlayer();
        new GameModeShareHandler(this.inventories, player, player.getGameMode(), event.getNewGameMode()).handleSharing();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerChangedWorld(PlayerChangedWorldEvent event) {
        World toWorld;
        Player player = event.getPlayer();
        World fromWorld = event.getFrom();
        if (fromWorld.equals(toWorld = player.getWorld())) {
            InvLogging.fine("PlayerChangedWorldEvent fired when player travelling in same world.", new Object[0]);
            return;
        }
        if (this.inventories.getCore().getMVWorldManager().getMVWorld(toWorld) == null || this.inventories.getCore().getMVWorldManager().getMVWorld(fromWorld) == null) {
            InvLogging.fine("The from or to world is not managed by Multiverse-Core!", new Object[0]);
        }
        new WorldChangeShareHandler(this.inventories, player, fromWorld.getName(), toWorld.getName()).handleSharing();
        this.inventories.getData().updateLastWorld(player.getName(), toWorld.getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled() || event.getFrom().getWorld().equals(event.getTo().getWorld()) || !this.inventories.getMVIConfig().getOptionalShares().contains(Sharables.LAST_LOCATION)) {
            return;
        }
        Player player = event.getPlayer();
        String fromWorldName = event.getFrom().getWorld().getName();
        String toWorldName = event.getTo().getWorld().getName();
        ProfileContainer fromWorldProfileContainer = this.inventories.getWorldProfileContainerStore().getContainer(fromWorldName);
        PlayerProfile playerProfile = fromWorldProfileContainer.getPlayerData(player);
        playerProfile.set(Sharables.LAST_LOCATION, event.getFrom());
        List<WorldGroup> fromGroups = this.inventories.getGroupManager().getGroupsForWorld(fromWorldName);
        for (WorldGroup fromGroup : fromGroups) {
            playerProfile = fromGroup.getGroupProfileContainer().getPlayerData(event.getPlayer());
            if (fromGroup.containsWorld(toWorldName)) {
                if (fromGroup.isSharing(Sharables.LAST_LOCATION)) continue;
                playerProfile.set(Sharables.LAST_LOCATION, event.getFrom());
                continue;
            }
            playerProfile.set(Sharables.LAST_LOCATION, event.getFrom());
        }
        player.closeInventory();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerDeath(PlayerDeathEvent event) {
        InvLogging.finer("=== Handling PlayerDeathEvent for: " + event.getEntity().getName() + " ===", new Object[0]);
        String deathWorld = event.getEntity().getWorld().getName();
        ProfileContainer worldProfileContainer = this.inventories.getWorldProfileContainerStore().getContainer(deathWorld);
        PlayerProfile profile = worldProfileContainer.getPlayerData(event.getEntity());
        profile.set(Sharables.LEVEL, event.getNewLevel());
        profile.set(Sharables.EXPERIENCE, Float.valueOf(event.getNewExp()));
        profile.set(Sharables.TOTAL_EXPERIENCE, event.getNewTotalExp());
        this.inventories.getData().updatePlayerData(profile);
        for (WorldGroup worldGroup : this.inventories.getGroupManager().getGroupsForWorld(deathWorld)) {
            profile = worldGroup.getGroupProfileContainer().getPlayerData(event.getEntity());
            profile.set(Sharables.LEVEL, event.getNewLevel());
            profile.set(Sharables.EXPERIENCE, Float.valueOf(event.getNewExp()));
            profile.set(Sharables.TOTAL_EXPERIENCE, event.getNewTotalExp());
            this.inventories.getData().updatePlayerData(profile);
        }
        InvLogging.finer("=== Finished handling PlayerDeathEvent for: " + event.getEntity().getName() + "! ===", new Object[0]);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerRespawn(PlayerRespawnEvent event) {
        Location respawnLoc = event.getRespawnLocation();
        if (respawnLoc == null) {
            return;
        }
        final Player player = event.getPlayer();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.inventories, new Runnable(){

            @Override
            public void run() {
                InventoriesListener.this.verifyCorrectWorld(player, player.getWorld().getName(), InventoriesListener.this.inventories.getData().getGlobalProfile(player.getName(), player.getUniqueId()));
            }
        }, 2L);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void lowestPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            World world = event.getPlayer().getWorld();
            this.currentGroups = this.inventories.getGroupManager().getGroupsForWorld(world.getName());
            this.handleRespawn(event, EventPriority.LOWEST);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void lowPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.LOW);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void normalPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.NORMAL);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void highPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.HIGH);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void highestPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.HIGHEST);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void monitorPriorityRespawn(PlayerRespawnEvent event) {
        if (!event.isBedSpawn()) {
            this.handleRespawn(event, EventPriority.MONITOR);
            this.updateCompass(event);
        }
    }

    private void handleRespawn(PlayerRespawnEvent event, EventPriority priority) {
        for (WorldGroup group : this.currentGroups) {
            MultiverseWorld mvWorld;
            String spawnWorldName;
            if (!group.getSpawnPriority().equals((Object)priority) || (spawnWorldName = group.getSpawnWorld()) == null || (mvWorld = this.inventories.getCore().getMVWorldManager().getMVWorld(spawnWorldName)) == null) continue;
            this.spawnLoc = mvWorld.getSpawnLocation();
            event.setRespawnLocation(this.spawnLoc);
            break;
        }
    }

    private void updateCompass(PlayerRespawnEvent event) {
        if (event.getRespawnLocation().equals((Object)this.spawnLoc)) {
            event.getPlayer().setCompassTarget(this.spawnLoc);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void entityPortal(EntityPortalEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Item) && !(entity instanceof InventoryHolder)) {
            return;
        }
        World fromWorld = event.getFrom().getWorld();
        Location toLocation = event.getTo();
        if (toLocation == null) {
            InvLogging.fine("Entity %s attempted to go to null location", entity);
            return;
        }
        World toWorld = toLocation.getWorld();
        if (toWorld == null) {
            InvLogging.fine("Entity %s attempted to go to null world", entity);
            return;
        }
        if (fromWorld.equals(toWorld)) {
            return;
        }
        List<WorldGroup> fromGroups = this.inventories.getGroupManager().getGroupsForWorld(fromWorld.getName());
        List<WorldGroup> toGroups = this.inventories.getGroupManager().getGroupsForWorld(toWorld.getName());
        fromGroups = fromGroups.stream().filter(it -> it.isSharing(Sharables.INVENTORY)).collect(Collectors.toList());
        toGroups = toGroups.stream().filter(it -> it.isSharing(Sharables.INVENTORY)).collect(Collectors.toList());
        for (WorldGroup fromGroup : fromGroups) {
            if (!toGroups.contains(fromGroup)) continue;
            InvLogging.finest("Allowing item or inventory holding %s to go from world %s to world %s", entity, fromWorld.getName(), toWorld.getName());
            return;
        }
        InvLogging.finest("Disallowing item or inventory holding %s to go from world %s to world %s since theseworlds do not share inventories", entity, fromWorld.getName(), toWorld.getName());
        event.setCancelled(true);
    }
}

