/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.share.Shares;
import com.onarandombox.multiverseinventories.util.CommentedYamlConfiguration;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public final class InventoriesConfig {
    private CommentedYamlConfiguration config;
    private MultiverseInventories plugin;
    private Shares optionalSharables = null;

    InventoriesConfig(MultiverseInventories plugin) throws IOException {
        File configFile;
        this.plugin = plugin;
        if (plugin.getDataFolder().mkdirs()) {
            InvLogging.fine("Created data folder.", new Object[0]);
        }
        if (!(configFile = new File(plugin.getDataFolder(), "config.yml")).exists()) {
            InvLogging.fine("Created config file.", new Object[0]);
            configFile.createNewFile();
        }
        this.config = new CommentedYamlConfiguration(configFile, true);
        this.config.load();
        this.setDefaults();
        this.config.getConfig().options().header("# Multiverse-Inventories Settings");
        this.config.save();
        InvLogging.setDebugLevel(this.getGlobalDebug());
    }

    private void setDefaults() {
        for (Path path : Path.values()) {
            this.config.addComment(path.getPath(), path.getComments());
            if (this.getConfig().get(path.getPath()) != null) continue;
            if (path.getDefault() != null) {
                InvLogging.fine("Config: Defaulting '" + path.getPath() + "' to " + path.getDefault(), new Object[0]);
                this.getConfig().set(path.getPath(), path.getDefault());
                continue;
            }
            this.getConfig().createSection(path.getPath());
        }
    }

    private Boolean getBoolean(Path path) {
        return this.getConfig().getBoolean(path.getPath(), ((Boolean)path.getDefault()).booleanValue());
    }

    private Integer getInt(Path path) {
        return this.getConfig().getInt(path.getPath(), ((Integer)path.getDefault()).intValue());
    }

    private String getString(Path path) {
        return this.getConfig().getString(path.getPath(), (String)path.getDefault());
    }

    FileConfiguration getConfig() {
        return this.config.getConfig();
    }

    public void setGlobalDebug(int globalDebug) {
        this.plugin.getCore().getMVConfig().setGlobalDebug(globalDebug);
    }

    public int getGlobalDebug() {
        return this.plugin.getCore().getMVConfig().getGlobalDebug();
    }

    public String getLocale() {
        return this.getString(Path.LANGUAGE_FILE_NAME);
    }

    public boolean isFirstRun() {
        return this.getBoolean(Path.FIRST_RUN);
    }

    void setFirstRun(boolean firstRun) {
        this.getConfig().set(Path.FIRST_RUN.getPath(), (Object)firstRun);
    }

    public boolean isUsingBypass() {
        return this.getBoolean(Path.USE_BYPASS);
    }

    public void setUsingBypass(boolean useBypass) {
        this.getConfig().set(Path.USE_BYPASS.getPath(), (Object)useBypass);
    }

    public boolean usingLoggingSaveLoad() {
        return this.getBoolean(Path.LOGGING_SAVE_LOAD);
    }

    public void setUsingLoggingSaveLoad(boolean useLoggingSaveLoad) {
        this.getConfig().set(Path.LOGGING_SAVE_LOAD.getPath(), (Object)useLoggingSaveLoad);
    }

    public Shares getOptionalShares() {
        if (this.optionalSharables == null) {
            List list = this.getConfig().getList(Path.OPTIONAL_SHARES.getPath());
            if (list != null) {
                this.optionalSharables = Sharables.fromList(list);
            } else {
                InvLogging.warning("'" + Path.OPTIONAL_SHARES.getPath() + "' is setup incorrectly!", new Object[0]);
                this.optionalSharables = Sharables.noneOf();
            }
        }
        return this.optionalSharables;
    }

    public boolean isDefaultingUngroupedWorlds() {
        return this.getBoolean(Path.DEFAULT_UNGROUPED_WORLDS);
    }

    public void setDefaultingUngroupedWorlds(boolean useDefaultGroup) {
        this.getConfig().set(Path.FIRST_RUN.getPath(), (Object)useDefaultGroup);
    }

    public boolean isUsingGameModeProfiles() {
        return this.getBoolean(Path.USE_GAME_MODE_PROFILES);
    }

    public void setUsingGameModeProfiles(boolean useGameModeProfile) {
        this.getConfig().set(Path.USE_GAME_MODE_PROFILES.getPath(), (Object)useGameModeProfile);
    }

    public boolean usingOptionalsForUngrouped() {
        return this.getBoolean(Path.USE_OPTIONALS_UNGROUPED);
    }

    public void setUsingOptionalsForUngrouped(boolean usingOptionalsForUngrouped) {
        this.getConfig().set(Path.USE_OPTIONALS_UNGROUPED.getPath(), (Object)usingOptionalsForUngrouped);
    }

    public void save() {
        if (this.optionalSharables != null) {
            this.getConfig().set(Path.OPTIONAL_SHARES.getPath(), this.optionalSharables.toStringList());
        }
        this.config.save();
    }

    public static enum Path {
        SETTINGS("settings", null, "# ===[ Multiverse Inventories Config ]==="),
        LANGUAGE_FILE_NAME("settings.locale", "en", "# This is the locale you wish to use."),
        FIRST_RUN("settings.first_run", true, "# If this is true it will generate world groups for you based on MV worlds."),
        USE_BYPASS("settings.use_bypass", false, "# If this is set to true, it will enable bypass permissions (Check the wiki for more info.)"),
        DEFAULT_UNGROUPED_WORLDS("settings.default_ungrouped_worlds", false, "# If set to true, any world not listed in a group will automatically use the settings for the default group!"),
        LOGGING_SAVE_LOAD("settings.save_load_on_log_in_out", false, "# The default and suggested setting for this is FALSE.", "# False means Multiverse-Inventories will not attempt to load or save any player data when they log in and out.", "# That means that MINECRAFT will handle that exact thing JUST LIKE IT DOES NORMALLY.", "# Changing this to TRUE will have Multiverse-Inventories save player data when they log out and load it when they log in.", "# The biggest potential drawback here is that if your server crashes, player stats/inventories may be lost/rolled back!"),
        USE_OPTIONALS_UNGROUPED("shares.optionals_for_ungrouped_worlds", true, "# When set to true, optional shares WILL be utilized in cases where a group does not cover their uses for a world.", "# An example of this in action would be an ungrouped world using last_location.  When this is true, players will return to their last location in that world.", "# When set to false, optional shares WILL NOt be utilized in these cases, effectively disabling it for ungrouped worlds."),
        OPTIONAL_SHARES("shares.use_optionals", new ArrayList<E>(), "# You must specify optional shares you wish to use here or they will be ignored.", "# The only built in optional share is \"economy\""),
        USE_GAME_MODE_PROFILES("settings.use_game_mode_profiles", false, "# If this is set to true, players will have different inventories/stats for each game mode.", "# Please note that old data migrated to the version that has this feature will have their data copied for both game modes.");

        private String path;
        private Object def;
        private List<String> comments;

        private Path(String path, Object def, String ... comments) {
            this.path = path;
            this.def = def;
            this.comments = Arrays.asList(comments);
        }

        private String getPath() {
            return this.path;
        }

        private Object getDefault() {
            return this.def;
        }

        private List<String> getComments() {
            return this.comments;
        }
    }
}

