/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.ShareHandler;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.event.GameModeChangeShareHandlingEvent;
import com.onarandombox.multiverseinventories.event.ShareHandlingEvent;
import com.onarandombox.multiverseinventories.profile.ProfileType;
import com.onarandombox.multiverseinventories.profile.ProfileTypes;
import com.onarandombox.multiverseinventories.profile.container.ProfileContainer;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.util.Perm;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

final class GameModeShareHandler
extends ShareHandler {
    private final GameMode fromGameMode;
    private final GameMode toGameMode;
    private final ProfileType fromType;
    private final ProfileType toType;
    private final String world;
    private final ProfileContainer worldProfileContainer;
    private final List<WorldGroup> worldGroups;

    GameModeShareHandler(MultiverseInventories inventories, Player player, GameMode fromGameMode, GameMode toGameMode) {
        super(inventories, player);
        this.fromGameMode = fromGameMode;
        this.toGameMode = toGameMode;
        this.fromType = ProfileTypes.forGameMode(fromGameMode);
        this.toType = ProfileTypes.forGameMode(toGameMode);
        this.world = player.getWorld().getName();
        this.worldProfileContainer = inventories.getWorldProfileContainerStore().getContainer(this.world);
        this.worldGroups = this.getAffectedWorldGroups();
        this.prepareProfiles();
    }

    private List<WorldGroup> getAffectedWorldGroups() {
        return this.inventories.getGroupManager().getGroupsForWorld(this.world);
    }

    @Override
    protected ShareHandlingEvent createEvent() {
        return new GameModeChangeShareHandlingEvent(this.player, this.affectedProfiles, this.fromGameMode, this.toGameMode);
    }

    private void prepareProfiles() {
        InvLogging.finer("=== " + this.player.getName() + " changing game mode from: " + this.fromType + " to: " + this.toType + " for world: " + this.world + " ===", new Object[0]);
        this.setAlwaysWriteProfile(this.worldProfileContainer.getPlayerData(this.fromType, (OfflinePlayer)this.player));
        if (this.isPlayerAffectedByChange()) {
            this.addProfiles();
        }
    }

    private boolean isPlayerAffectedByChange() {
        if (this.isPlayerBypassingChange()) {
            this.logBypass();
            return false;
        }
        return true;
    }

    private boolean isPlayerBypassingChange() {
        return Perm.BYPASS_WORLD.hasBypass(this.player, this.world) || Perm.BYPASS_GAME_MODE.hasBypass(this.player, this.toGameMode.name().toLowerCase());
    }

    private void addProfiles() {
        if (this.hasWorldGroups()) {
            this.worldGroups.forEach(this::addProfilesForWorldGroup);
        } else {
            InvLogging.finer("No groups for world.", new Object[0]);
            this.addReadProfile(this.worldProfileContainer.getPlayerData(this.toType, (OfflinePlayer)this.player), Sharables.allOf());
        }
    }

    private boolean hasWorldGroups() {
        return !this.worldGroups.isEmpty();
    }

    private void addProfilesForWorldGroup(WorldGroup worldGroup) {
        ProfileContainer container = worldGroup.getGroupProfileContainer();
        this.addWriteProfile(container.getPlayerData(this.fromType, (OfflinePlayer)this.player), Sharables.allOf());
        this.addReadProfile(container.getPlayerData(this.toType, (OfflinePlayer)this.player), Sharables.allOf());
    }
}

