/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.profile.GlobalProfile;
import com.onarandombox.multiverseinventories.profile.PlayerProfile;
import com.onarandombox.multiverseinventories.profile.ProfileDataSource;
import com.onarandombox.multiverseinventories.profile.ProfileKey;
import com.onarandombox.multiverseinventories.profile.ProfileType;
import com.onarandombox.multiverseinventories.profile.ProfileTypes;
import com.onarandombox.multiverseinventories.profile.container.ContainerType;
import com.onarandombox.multiverseinventories.share.ProfileEntry;
import com.onarandombox.multiverseinventories.share.Sharable;
import com.onarandombox.multiverseinventories.share.SharableEntry;
import com.onarandombox.multiverseinventories.util.json.JSONObject;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import com.onarandombox.multiverseinventories.utils.configuration.json.JsonConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

class FlatFileProfileDataSource
implements ProfileDataSource {
    private static final String JSON = ".json";
    private final JSONParser JSON_PARSER = new JSONParser();
    private final ExecutorService fileIOExecutorService = Executors.newSingleThreadExecutor();
    private final Cache<ProfileKey, PlayerProfile> profileCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private final Cache<UUID, GlobalProfile> globalProfileCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(500L).build();
    private final File worldFolder;
    private final File groupFolder;
    private final File playerFolder;

    FlatFileProfileDataSource(MultiverseInventories plugin) throws IOException {
        plugin.getDataFolder().mkdirs();
        this.worldFolder = new File(plugin.getDataFolder(), "worlds");
        if (!this.worldFolder.exists() && !this.worldFolder.mkdirs()) {
            throw new IOException("Could not create world folder!");
        }
        this.groupFolder = new File(plugin.getDataFolder(), "groups");
        if (!this.groupFolder.exists() && !this.groupFolder.mkdirs()) {
            throw new IOException("Could not create group folder!");
        }
        this.playerFolder = new File(plugin.getDataFolder(), "players");
        if (!this.playerFolder.exists() && !this.playerFolder.mkdirs()) {
            throw new IOException("Could not create player folder!");
        }
    }

    private FileConfiguration waitForConfigHandle(File file) {
        Future<FileConfiguration> future = this.fileIOExecutorService.submit(new ConfigLoader(file));
        while (true) {
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static FileConfiguration getConfigHandleNow(File file) {
        return JsonConfiguration.loadConfiguration(file);
    }

    private File getFolder(ContainerType type, String folderName) {
        File folder;
        switch (type) {
            case GROUP: {
                folder = new File(this.groupFolder, folderName);
                break;
            }
            case WORLD: {
                folder = new File(this.worldFolder, folderName);
                break;
            }
            default: {
                folder = new File(this.worldFolder, folderName);
            }
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        InvLogging.finer("got data folder: " + folder.getPath() + " from type: " + (Object)((Object)type), new Object[0]);
        return folder;
    }

    File getPlayerFile(ContainerType type, String dataName, String playerName) throws IOException {
        File jsonPlayerFile = new File(this.getFolder(type, dataName), playerName + JSON);
        if (!jsonPlayerFile.exists()) {
            try {
                jsonPlayerFile.createNewFile();
            }
            catch (IOException e) {
                throw new IOException("Could not create necessary player data file: " + jsonPlayerFile.getPath() + ". Data for " + playerName + " in " + type.name().toLowerCase() + " " + dataName + " may not be saved.", e);
            }
        }
        return jsonPlayerFile;
    }

    File getGlobalFile(String fileName, boolean createIfMissing) throws IOException {
        File jsonPlayerFile = new File(this.playerFolder, fileName + JSON);
        if (createIfMissing && !jsonPlayerFile.exists()) {
            try {
                jsonPlayerFile.createNewFile();
            }
            catch (IOException e) {
                throw new IOException("Could not create necessary player file: " + jsonPlayerFile.getPath() + ". There may be issues with " + fileName + "'s metadata", e);
            }
        }
        return jsonPlayerFile;
    }

    private void queueWrite(PlayerProfile profile) {
        this.fileIOExecutorService.submit(new FileWriter(profile.clone()));
    }

    private void processProfileWrite(PlayerProfile playerProfile) {
        try {
            File playerFile = this.getPlayerFile(playerProfile.getContainerType(), playerProfile.getContainerName(), playerProfile.getPlayer().getName());
            FileConfiguration playerData = FlatFileProfileDataSource.getConfigHandleNow(playerFile);
            playerData.createSection(playerProfile.getProfileType().getName(), this.serializePlayerProfile(playerProfile));
            try {
                playerData.save(playerFile);
            }
            catch (IOException e) {
                InvLogging.severe("Could not save data for player: " + playerProfile.getPlayer().getName() + " for " + playerProfile.getContainerType().toString() + ": " + playerProfile.getContainerName(), new Object[0]);
                InvLogging.severe(e.getMessage(), new Object[0]);
            }
        }
        catch (Exception e) {
            InvLogging.getLogger().log(Level.WARNING, "Error while attempting to write profile data.", e);
        }
    }

    private Map<String, Object> serializePlayerProfile(PlayerProfile playerProfile) {
        LinkedHashMap<String, Object> playerData = new LinkedHashMap<String, Object>();
        JSONObject jsonStats = new JSONObject();
        for (SharableEntry entry : playerProfile) {
            if (entry.getValue() == null || entry.getSharable().getSerializer() == null) continue;
            Sharable sharable = entry.getSharable();
            if (sharable.getProfileEntry().isStat()) {
                jsonStats.put(sharable.getProfileEntry().getFileTag(), sharable.getSerializer().serialize(entry.getValue()));
                continue;
            }
            playerData.put(sharable.getProfileEntry().getFileTag(), sharable.getSerializer().serialize(entry.getValue()));
        }
        if (!jsonStats.isEmpty()) {
            playerData.put("stats", jsonStats);
        }
        return playerData;
    }

    @Override
    public void updatePlayerData(PlayerProfile playerProfile) {
        this.queueWrite(playerProfile);
    }

    private PlayerProfile getPlayerData(ProfileKey key) {
        ConfigurationSection section;
        PlayerProfile cached = (PlayerProfile)this.profileCache.getIfPresent((Object)key);
        if (cached != null) {
            return cached;
        }
        File playerFile = null;
        try {
            playerFile = this.getPlayerFile(key.getContainerType(), key.getDataName(), key.getPlayerName());
        }
        catch (IOException e) {
            e.printStackTrace();
            return PlayerProfile.createPlayerProfile(key.getContainerType(), key.getDataName(), key.getProfileType(), Bukkit.getOfflinePlayer((UUID)key.getPlayerUUID()));
        }
        FileConfiguration playerData = this.waitForConfigHandle(playerFile);
        if (this.convertConfig(playerData)) {
            try {
                playerData.save(playerFile);
            }
            catch (IOException e) {
                InvLogging.severe("Could not save data for player: " + key.getPlayerName() + " for " + key.getContainerType().toString() + ": " + key.getDataName() + " after conversion.", new Object[0]);
                InvLogging.severe(e.getMessage(), new Object[0]);
            }
        }
        if ((section = playerData.getConfigurationSection(key.getProfileType().getName())) == null) {
            section = playerData.createSection(key.getProfileType().getName());
        }
        PlayerProfile result = this.deserializePlayerProfile(key, this.convertSection(section));
        this.profileCache.put((Object)key, (Object)result);
        return result;
    }

    @Override
    public PlayerProfile getPlayerData(ContainerType containerType, String dataName, ProfileType profileType, UUID playerUUID) {
        return this.getPlayerData(ProfileKey.createProfileKey(containerType, dataName, profileType, playerUUID));
    }

    private PlayerProfile deserializePlayerProfile(ProfileKey pKey, Map playerData) {
        PlayerProfile profile = PlayerProfile.createPlayerProfile(pKey.getContainerType(), pKey.getDataName(), pKey.getProfileType(), Bukkit.getOfflinePlayer((UUID)pKey.getPlayerUUID()));
        for (Object keyObj : playerData.keySet()) {
            String key = keyObj.toString();
            if (key.equalsIgnoreCase("stats")) {
                Object statsObject = playerData.get(key);
                if (statsObject instanceof String) {
                    this.parseJsonPlayerStatsIntoProfile(statsObject.toString(), profile);
                    continue;
                }
                if (statsObject instanceof Map) {
                    this.parsePlayerStatsIntoProfile((Map)statsObject, profile);
                    continue;
                }
                InvLogging.warning("Could not parse stats for " + pKey.getPlayerName(), new Object[0]);
                continue;
            }
            if (playerData.get(key) == null) {
                InvLogging.fine("Player data '" + key + "' is null for: " + pKey.getPlayerName(), new Object[0]);
                continue;
            }
            try {
                Sharable sharable = ProfileEntry.lookup(false, key);
                if (sharable == null) {
                    InvLogging.fine("Player fileTag '" + key + "' is unrecognized!", new Object[0]);
                    continue;
                }
                profile.set(sharable, sharable.getSerializer().deserialize(playerData.get(key)));
            }
            catch (Exception e) {
                InvLogging.fine("Could not parse fileTag: '" + key + "' with value '" + playerData.get(key) + "'", new Object[0]);
                InvLogging.getLogger().log(Level.FINE, "Exception: ", e);
                e.printStackTrace();
            }
        }
        InvLogging.finer("Created player profile from map for '" + pKey.getPlayerName() + "'.", new Object[0]);
        return profile;
    }

    private void parsePlayerStatsIntoProfile(Map stats, PlayerProfile profile) {
        for (Object key : stats.keySet()) {
            Sharable sharable = ProfileEntry.lookup(true, key.toString());
            if (sharable != null) {
                profile.set(sharable, sharable.getSerializer().deserialize(stats.get(key).toString()));
                continue;
            }
            InvLogging.warning("Could not parse stat: '" + key + "' for player '" + profile.getPlayer().getName() + "' for " + (Object)((Object)profile.getContainerType()) + " '" + profile.getContainerName() + "'", new Object[0]);
        }
    }

    private void parseJsonPlayerStatsIntoProfile(String stats, PlayerProfile profile) {
        if (stats.isEmpty()) {
            return;
        }
        org.json.simple.JSONObject jsonStats = null;
        try {
            jsonStats = (org.json.simple.JSONObject)this.JSON_PARSER.parse(stats);
        }
        catch (ParseException e) {
            InvLogging.warning("Could not parse stats for player'" + profile.getPlayer().getName() + "' for " + (Object)((Object)profile.getContainerType()) + " '" + profile.getContainerName() + "': " + e.getMessage(), new Object[0]);
        }
        catch (ClassCastException e) {
            InvLogging.warning("Could not parse stats for player'" + profile.getPlayer().getName() + "' for " + (Object)((Object)profile.getContainerType()) + " '" + profile.getContainerName() + "': " + e.getMessage(), new Object[0]);
        }
        if (jsonStats == null) {
            InvLogging.warning("Could not parse stats for player'" + profile.getPlayer().getName() + "' for " + (Object)((Object)profile.getContainerType()) + " '" + profile.getContainerName() + "'", new Object[0]);
            return;
        }
        this.parsePlayerStatsIntoProfile(jsonStats, profile);
    }

    private boolean convertConfig(FileConfiguration config) {
        ConfigurationSection section = config.getConfigurationSection("playerData");
        if (section != null) {
            config.set(ProfileTypes.SURVIVAL.getName(), (Object)section);
            config.set(ProfileTypes.CREATIVE.getName(), (Object)section);
            config.set(ProfileTypes.ADVENTURE.getName(), (Object)section);
            config.set("playerData", null);
            InvLogging.finer("Migrated old player data to new multi-profile format", new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public boolean removePlayerData(ContainerType containerType, String dataName, ProfileType profileType, String playerName) {
        File playerFile;
        if (profileType == null) {
            try {
                File playerFile2 = this.getPlayerFile(containerType, dataName, playerName);
                return playerFile2.delete();
            }
            catch (IOException ignore) {
                InvLogging.warning("Attempted to delete file that did not exist for player " + playerName + " in " + containerType.name().toLowerCase() + " " + dataName, new Object[0]);
                return false;
            }
        }
        try {
            playerFile = this.getPlayerFile(containerType, dataName, playerName);
        }
        catch (IOException e) {
            InvLogging.warning("Attempted to delete " + playerName + "'s data for " + profileType.getName().toLowerCase() + " mode in " + containerType.name().toLowerCase() + " " + dataName + " but the file did not exist.", new Object[0]);
            return false;
        }
        FileConfiguration playerData = this.waitForConfigHandle(playerFile);
        playerData.set(profileType.getName(), null);
        try {
            playerData.save(playerFile);
        }
        catch (IOException e) {
            InvLogging.severe("Could not delete data for player: " + playerName + " for " + containerType.toString() + ": " + dataName, new Object[0]);
            InvLogging.severe(e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    private Map<String, Object> convertSection(ConfigurationSection section) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String key : section.getKeys(false)) {
            Object obj = section.get(key);
            if (obj instanceof ConfigurationSection) {
                resultMap.put(key, this.convertSection((ConfigurationSection)obj));
                continue;
            }
            resultMap.put(key, obj);
        }
        return resultMap;
    }

    @Override
    @Deprecated
    public GlobalProfile getGlobalProfile(String playerName) {
        return this.getGlobalProfile(playerName, Bukkit.getOfflinePlayer((String)playerName).getUniqueId());
    }

    @Override
    public GlobalProfile getGlobalProfile(String playerName, UUID playerUUID) {
        File playerFile;
        GlobalProfile cached = (GlobalProfile)this.globalProfileCache.getIfPresent((Object)playerUUID);
        if (cached != null) {
            return cached;
        }
        try {
            playerFile = this.getGlobalFile(playerName, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            return GlobalProfile.createGlobalProfile(playerName);
        }
        if (playerFile.exists()) {
            GlobalProfile profile = this.loadGlobalProfile(playerFile, playerName, playerUUID);
            if (!this.migrateGlobalProfileToUUID(profile, playerFile)) {
                InvLogging.warning("Could not properly migrate player global data file for " + playerName, new Object[0]);
            }
            this.globalProfileCache.put((Object)playerUUID, (Object)profile);
            return profile;
        }
        try {
            playerFile = this.getGlobalFile(playerUUID.toString(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return GlobalProfile.createGlobalProfile(playerName, playerUUID);
        }
        GlobalProfile profile = this.loadGlobalProfile(playerFile, playerName, playerUUID);
        this.globalProfileCache.put((Object)playerUUID, (Object)profile);
        return profile;
    }

    private boolean migrateGlobalProfileToUUID(GlobalProfile profile, File playerFile) {
        this.updateGlobalProfile(profile);
        return playerFile.delete();
    }

    private GlobalProfile loadGlobalProfile(File playerFile, String playerName, UUID playerUUID) {
        FileConfiguration playerData = this.waitForConfigHandle(playerFile);
        ConfigurationSection section = playerData.getConfigurationSection("playerData");
        if (section == null) {
            section = playerData.createSection("playerData");
        }
        return this.deserializeGlobalProfile(playerName, playerUUID, this.convertSection(section));
    }

    private GlobalProfile deserializeGlobalProfile(String playerName, UUID playerUUID, Map<String, Object> playerData) {
        GlobalProfile globalProfile = GlobalProfile.createGlobalProfile(playerName, playerUUID);
        for (String key : playerData.keySet()) {
            if (key.equalsIgnoreCase("lastWorld")) {
                globalProfile.setLastWorld(playerData.get(key).toString());
                continue;
            }
            if (key.equalsIgnoreCase("shouldLoad")) {
                globalProfile.setLoadOnLogin(Boolean.valueOf(playerData.get(key).toString()));
                continue;
            }
            if (!key.equalsIgnoreCase("lastKnownName")) continue;
            globalProfile.setLastKnownName(playerData.get(key).toString());
        }
        return globalProfile;
    }

    @Override
    public boolean updateGlobalProfile(GlobalProfile globalProfile) {
        File playerFile = null;
        try {
            playerFile = this.getGlobalFile(globalProfile.getPlayerUUID().toString(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        FileConfiguration playerData = this.waitForConfigHandle(playerFile);
        playerData.createSection("playerData", this.serializeGlobalProfile(globalProfile));
        try {
            playerData.save(playerFile);
        }
        catch (IOException e) {
            InvLogging.severe("Could not save global data for player: " + globalProfile.getPlayerName(), new Object[0]);
            InvLogging.severe(e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    private Map<String, Object> serializeGlobalProfile(GlobalProfile profile) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (profile.getLastWorld() != null) {
            result.put("lastWorld", profile.getLastWorld());
        }
        result.put("shouldLoad", profile.shouldLoadOnLogin());
        result.put("lastKnownName", profile.getLastKnownName());
        return result;
    }

    @Override
    @Deprecated
    public void updateLastWorld(String playerName, String worldName) {
        GlobalProfile globalProfile = this.getGlobalProfile(playerName);
        globalProfile.setLastWorld(worldName);
        this.updateGlobalProfile(globalProfile);
    }

    @Override
    @Deprecated
    public void setLoadOnLogin(String playerName, boolean loadOnLogin) {
        GlobalProfile globalProfile = this.getGlobalProfile(playerName);
        globalProfile.setLoadOnLogin(loadOnLogin);
        this.updateGlobalProfile(globalProfile);
    }

    @Override
    public void migratePlayerData(String oldName, String newName, UUID uuid, boolean removeOldData) throws IOException {
        ProfileKey key;
        File[] worldFolders = this.worldFolder.listFiles(File::isDirectory);
        if (worldFolders == null) {
            throw new IOException("Could not enumerate world folders");
        }
        File[] groupFolders = this.groupFolder.listFiles(File::isDirectory);
        if (groupFolders == null) {
            throw new IOException("Could not enumerate group folders");
        }
        for (File worldFolder : worldFolders) {
            key = ProfileKey.createProfileKey(ContainerType.WORLD, worldFolder.getName(), ProfileTypes.ADVENTURE, uuid, oldName);
            this.updatePlayerData(this.getPlayerData(key));
            this.updatePlayerData(this.getPlayerData(ProfileKey.createProfileKey(key, ProfileTypes.CREATIVE)));
            this.updatePlayerData(this.getPlayerData(ProfileKey.createProfileKey(key, ProfileTypes.SURVIVAL)));
        }
        for (File groupFolder : groupFolders) {
            key = ProfileKey.createProfileKey(ContainerType.WORLD, groupFolder.getName(), ProfileTypes.ADVENTURE, uuid, oldName);
            this.updatePlayerData(this.getPlayerData(key));
            this.updatePlayerData(this.getPlayerData(ProfileKey.createProfileKey(key, ProfileTypes.CREATIVE)));
            this.updatePlayerData(this.getPlayerData(ProfileKey.createProfileKey(key, ProfileTypes.SURVIVAL)));
        }
        if (removeOldData) {
            for (File worldFolder : worldFolders) {
                this.removePlayerData(ContainerType.WORLD, worldFolder.getName(), ProfileTypes.ADVENTURE, oldName);
                this.removePlayerData(ContainerType.WORLD, worldFolder.getName(), ProfileTypes.CREATIVE, oldName);
                this.removePlayerData(ContainerType.WORLD, worldFolder.getName(), ProfileTypes.SURVIVAL, oldName);
            }
            for (File groupFolder : groupFolders) {
                this.removePlayerData(ContainerType.GROUP, groupFolder.getName(), ProfileTypes.ADVENTURE, oldName);
                this.removePlayerData(ContainerType.GROUP, groupFolder.getName(), ProfileTypes.CREATIVE, oldName);
                this.removePlayerData(ContainerType.GROUP, groupFolder.getName(), ProfileTypes.SURVIVAL, oldName);
            }
        }
    }

    void clearCache() {
        this.globalProfileCache.invalidateAll();
        this.profileCache.invalidateAll();
    }

    private class FileWriter
    implements Callable<Void> {
        private final PlayerProfile profile;

        private FileWriter(PlayerProfile profile) {
            this.profile = profile;
        }

        @Override
        public Void call() throws Exception {
            FlatFileProfileDataSource.this.processProfileWrite(this.profile);
            return null;
        }
    }

    private static class ConfigLoader
    implements Callable<FileConfiguration> {
        private final File file;

        private ConfigLoader(File file) {
            this.file = file;
        }

        @Override
        public FileConfiguration call() throws Exception {
            return FlatFileProfileDataSource.getConfigHandleNow(this.file);
        }
    }
}

