/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.DefaultMessageProvider;
import com.onarandombox.multiverseinventories.locale.Message;
import com.onarandombox.multiverseinventories.locale.MessageProvider;
import com.onarandombox.multiverseinventories.locale.Messager;
import com.onarandombox.multiverseinventories.util.Font;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;

final class DefaultMessager
extends DefaultMessageProvider
implements Messager,
MessageProvider {
    public DefaultMessager(JavaPlugin plugin) {
        super(plugin);
    }

    private void send(Message message, String prefix, CommandSender sender, Object ... args) {
        List<String> messages = this.getMessages(message, args);
        if (!messages.isEmpty()) {
            messages.set(0, prefix + " " + messages.get(0));
            this.sendMessages(sender, messages);
        }
    }

    @Override
    public void bad(Message message, CommandSender sender, Object ... args) {
        this.send(message, ChatColor.RED.toString() + this.getMessage(Message.GENERIC_ERROR, new Object[0]), sender, args);
    }

    @Override
    public void normal(Message message, CommandSender sender, Object ... args) {
        this.send(message, "", sender, args);
    }

    @Override
    public void good(Message message, CommandSender sender, Object ... args) {
        this.send(message, ChatColor.GREEN.toString() + this.getMessage(Message.GENERIC_SUCCESS, new Object[0]), sender, args);
    }

    @Override
    public void info(Message message, CommandSender sender, Object ... args) {
        this.send(message, ChatColor.YELLOW.toString() + this.getMessage(Message.GENERIC_INFO, new Object[0]), sender, args);
    }

    @Override
    public void help(Message message, CommandSender sender, Object ... args) {
        this.send(message, ChatColor.GRAY.toString() + this.getMessage(Message.GENERIC_HELP, new Object[0]), sender, args);
    }

    @Override
    public void sendMessage(CommandSender player, String message) {
        List<String> messages = Font.splitString(message);
        this.sendMessages(player, messages);
    }

    @Override
    public void sendMessages(CommandSender player, List<String> messages) {
        for (String s : messages) {
            player.sendMessage(s);
        }
    }
}

