/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.locale.LazyLocaleMessageProvider;
import com.onarandombox.multiverseinventories.locale.LocalizationLoadingException;
import com.onarandombox.multiverseinventories.locale.Message;
import com.onarandombox.multiverseinventories.locale.NoSuchLocalizationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

class DefaultMessageProvider
implements LazyLocaleMessageProvider {
    public static final String LOCALIZATION_FOLDER_NAME = "localization";
    private final HashMap<Locale, HashMap<Message, List<String>>> messages;
    private final JavaPlugin plugin;
    private Locale locale = DEFAULT_LOCALE;

    public DefaultMessageProvider(JavaPlugin plugin) {
        this.plugin = plugin;
        this.messages = new HashMap();
        try {
            this.loadLocale(this.locale);
        }
        catch (NoSuchLocalizationException noSuchLocalizationException) {
            // empty catch block
        }
    }

    public void maybeLoadLocale(Locale locale) throws LocalizationLoadingException {
        if (!this.isLocaleLoaded(locale)) {
            this.loadLocale(locale);
        }
        if (!this.isLocaleLoaded(locale)) {
            throw new LocalizationLoadingException("Couldn't load the localization: " + locale.toString(), locale);
        }
    }

    public List<String> format(List<String> strings, Object ... args) {
        ArrayList<String> formattedStrings = new ArrayList<String>();
        for (String string : strings) {
            formattedStrings.add(this.format(string, args));
        }
        return formattedStrings;
    }

    public String format(String string, Object ... args) {
        string = string.replaceAll("(&([a-fA-FkK0-9]))", "\u00a7$2");
        if (args != null) {
            for (int j = 0; j < args.length; ++j) {
                string = string.replace("%" + (j + 1), args[j].toString());
            }
        }
        return string;
    }

    @Override
    public void loadLocale(Locale l) throws NoSuchLocalizationException {
        this.messages.remove(l);
        InputStream resstream = null;
        FileInputStream filestream = null;
        try {
            filestream = new FileInputStream(new File(this.plugin.getDataFolder(), l.getLanguage() + ".yml"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        try {
            resstream = this.plugin.getResource(LOCALIZATION_FOLDER_NAME + "/" + l.getLanguage() + ".yml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resstream == null && filestream == null) {
            throw new NoSuchLocalizationException(l);
        }
        this.messages.put(l, new HashMap(Message.values().length));
        YamlConfiguration resconfig = resstream == null ? null : YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(resstream));
        YamlConfiguration fileconfig = filestream == null ? null : YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(filestream));
        for (Message m : Message.values()) {
            List values = m.getDefault();
            if (resconfig != null) {
                if (resconfig.isList(m.toString())) {
                    values = resconfig.getStringList(m.toString());
                } else {
                    values.add(resconfig.getString(m.toString(), (String)values.get(0)));
                }
            }
            if (fileconfig != null) {
                if (fileconfig.isList(m.toString())) {
                    values = fileconfig.getStringList(m.toString());
                } else {
                    values.add(fileconfig.getString(m.toString(), (String)values.get(0)));
                }
            }
            this.messages.get(l).put(m, values);
        }
    }

    @Override
    public Set<Locale> getLoadedLocales() {
        return this.messages.keySet();
    }

    @Override
    public boolean isLocaleLoaded(Locale l) {
        return this.messages.containsKey(l);
    }

    @Override
    public String getMessage(Message key, Object ... args) {
        if (!this.isLocaleLoaded(this.locale)) {
            return this.format(key.getDefault().get(0), args);
        }
        return this.format(this.messages.get(this.locale).get((Object)key).get(0), args);
    }

    @Override
    public String getMessage(Message key, Locale locale, Object ... args) {
        try {
            this.maybeLoadLocale(locale);
        }
        catch (LocalizationLoadingException e) {
            e.printStackTrace();
            return this.getMessage(key, args);
        }
        return this.format(this.messages.get(locale).get((Object)key).get(0), args);
    }

    @Override
    public List<String> getMessages(Message key, Object ... args) {
        List<String> result = !this.isLocaleLoaded(this.locale) ? this.format(key.getDefault(), args) : this.format(this.messages.get(this.locale).get((Object)key), args);
        return result;
    }

    @Override
    public List<String> getMessages(Message key, Locale locale, Object ... args) {
        try {
            this.maybeLoadLocale(locale);
        }
        catch (LocalizationLoadingException e) {
            e.printStackTrace();
            return this.format(this.getMessages(key, new Object[0]), args);
        }
        return this.format(this.messages.get(locale).get((Object)key), args);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        block3: {
            if (locale == null) {
                throw new IllegalArgumentException("Can't set locale to null!");
            }
            try {
                this.maybeLoadLocale(locale);
            }
            catch (LocalizationLoadingException e) {
                if (locale.equals(DEFAULT_LOCALE)) break block3;
                throw new IllegalArgumentException("Error while trying to load localization for the given Locale!", e);
            }
        }
        this.locale = locale;
    }
}

