/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.util.json.JSONArray;
import com.onarandombox.multiverseinventories.util.json.JSONObject;
import com.onarandombox.multiverseinventories.util.json.parser.JSONParser;
import com.onarandombox.multiverseinventories.util.json.parser.ParseException;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.LinkedList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class DataStrings {
    public static final String VALUE_DELIMITER = ":";
    public static final String PLAYER_STATS = "stats";
    public static final String PLAYER_INVENTORY_CONTENTS = "inventoryContents";
    public static final String PLAYER_ARMOR_CONTENTS = "armorContents";
    public static final String PLAYER_OFF_HAND_ITEM = "offHandItem";
    public static final String ENDER_CHEST_CONTENTS = "enderChestContents";
    public static final String PLAYER_BED_SPAWN_LOCATION = "bedSpawnLocation";
    public static final String PLAYER_LAST_LOCATION = "lastLocation";
    public static final String PLAYER_LAST_WORLD = "lastWorld";
    public static final String PLAYER_SHOULD_LOAD = "shouldLoad";
    public static final String PLAYER_LAST_KNOWN_NAME = "lastKnownName";
    public static final String PLAYER_PROFILE_TYPE = "profileType";
    public static final String PLAYER_HEALTH = "hp";
    public static final String PLAYER_EXPERIENCE = "xp";
    public static final String PLAYER_TOTAL_EXPERIENCE = "txp";
    public static final String PLAYER_LEVEL = "el";
    public static final String PLAYER_FOOD_LEVEL = "fl";
    public static final String PLAYER_EXHAUSTION = "ex";
    public static final String PLAYER_SATURATION = "sa";
    public static final String PLAYER_FALL_DISTANCE = "fd";
    public static final String PLAYER_FIRE_TICKS = "ft";
    public static final String PLAYER_REMAINING_AIR = "ra";
    public static final String PLAYER_MAX_AIR = "ma";
    public static final String LOCATION_X = "x";
    public static final String LOCATION_Y = "y";
    public static final String LOCATION_Z = "z";
    public static final String LOCATION_WORLD = "wo";
    public static final String LOCATION_PITCH = "pi";
    public static final String LOCATION_YAW = "ya";
    public static final String POTION_TYPE = "pt";
    public static final String POTION_DURATION = "pd";
    public static final String POTION_AMPLIFIER = "pa";
    private static final JSONParser JSON_PARSER = new JSONParser(16);

    private DataStrings() {
        throw new AssertionError();
    }

    @Deprecated
    public static Location parseLocation(String locString) {
        JSONObject jsonLoc;
        if (locString.isEmpty()) {
            return null;
        }
        try {
            jsonLoc = (JSONObject)JSON_PARSER.parse(locString);
        }
        catch (ParseException e) {
            InvLogging.warning("Could not parse location! " + e.getMessage(), new Object[0]);
            return null;
        }
        catch (ClassCastException e) {
            InvLogging.warning("Could not parse location! " + e.getMessage(), new Object[0]);
            return null;
        }
        return DataStrings.parseLocMap(jsonLoc);
    }

    @Deprecated
    public static Location parseLocation(Map locMap) {
        return DataStrings.parseLocMap(locMap);
    }

    @Deprecated
    private static Location parseLocMap(Map locMap) {
        Object value;
        World world = null;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (locMap.containsKey(LOCATION_WORLD)) {
            world = Bukkit.getWorld((String)locMap.get(LOCATION_WORLD).toString());
        }
        if (locMap.containsKey(LOCATION_X) && (value = locMap.get(LOCATION_X)) instanceof Number) {
            x = ((Number)value).doubleValue();
        }
        if (locMap.containsKey(LOCATION_Y) && (value = locMap.get(LOCATION_Y)) instanceof Number) {
            y = ((Number)value).doubleValue();
        }
        if (locMap.containsKey(LOCATION_Z) && (value = locMap.get(LOCATION_Z)) instanceof Number) {
            z = ((Number)value).doubleValue();
        }
        if (locMap.containsKey(LOCATION_PITCH) && (value = locMap.get(LOCATION_PITCH)) instanceof Number) {
            pitch = ((Number)value).floatValue();
        }
        if (locMap.containsKey(LOCATION_YAW) && (value = locMap.get(LOCATION_YAW)) instanceof Number) {
            yaw = ((Number)value).floatValue();
        }
        if (world == null) {
            return null;
        }
        return new Location(world, x, y, z, yaw, pitch);
    }

    @Deprecated
    public static PotionEffect[] parsePotionEffects(String potionsString) {
        JSONArray jsonPotions;
        LinkedList<PotionEffect> potionEffectList = new LinkedList<PotionEffect>();
        if (potionsString.isEmpty()) {
            return potionEffectList.toArray(new PotionEffect[potionEffectList.size()]);
        }
        try {
            jsonPotions = (JSONArray)JSON_PARSER.parse(potionsString);
        }
        catch (ParseException e) {
            InvLogging.warning("Could not parse potions! " + e.getMessage(), new Object[0]);
            return potionEffectList.toArray(new PotionEffect[potionEffectList.size()]);
        }
        catch (ClassCastException e) {
            InvLogging.warning("Could not parse potions! " + e.getMessage(), new Object[0]);
            return potionEffectList.toArray(new PotionEffect[potionEffectList.size()]);
        }
        for (Object obj : jsonPotions) {
            if (obj instanceof JSONObject) {
                Object value;
                JSONObject jsonPotion = (JSONObject)obj;
                int type = -1;
                int duration = -1;
                int amplifier = -1;
                if (jsonPotion.containsKey(POTION_TYPE) && (value = jsonPotion.get(POTION_TYPE)) instanceof Number) {
                    type = ((Number)value).intValue();
                }
                if (jsonPotion.containsKey(POTION_AMPLIFIER) && (value = jsonPotion.get(POTION_AMPLIFIER)) instanceof Number) {
                    amplifier = ((Number)value).intValue();
                }
                if (jsonPotion.containsKey(POTION_DURATION) && (value = jsonPotion.get(POTION_DURATION)) instanceof Number) {
                    duration = ((Number)value).intValue();
                }
                if (type == -1 || duration == -1 || amplifier == -1) {
                    InvLogging.fine("Could not parse potion effect string: " + obj, new Object[0]);
                    continue;
                }
                PotionEffectType pType = PotionEffectType.getById((int)type);
                if (pType == null) {
                    InvLogging.warning("Could not parse potion effect type: " + type, new Object[0]);
                    continue;
                }
                potionEffectList.add(new PotionEffect(pType, duration, amplifier));
                continue;
            }
            InvLogging.warning("Could not parse potion effect: " + obj, new Object[0]);
        }
        return potionEffectList.toArray(new PotionEffect[potionEffectList.size()]);
    }
}

