/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.multiverseinventories;

import com.onarandombox.multiverseinventories.MultiverseInventories;
import com.onarandombox.multiverseinventories.WorldGroup;
import com.onarandombox.multiverseinventories.locale.Message;
import com.onarandombox.multiverseinventories.profile.GroupingConflict;
import com.onarandombox.multiverseinventories.profile.WorldGroupManager;
import com.onarandombox.multiverseinventories.share.Sharables;
import com.onarandombox.multiverseinventories.share.Shares;
import com.onarandombox.multiverseinventories.utils.InvLogging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

abstract class AbstractWorldGroupManager
implements WorldGroupManager {
    static final String DEFAULT_GROUP_NAME = "default";
    protected final Map<String, WorldGroup> groupNamesMap = new LinkedHashMap<String, WorldGroup>();
    protected final MultiverseInventories plugin;

    public AbstractWorldGroupManager(MultiverseInventories plugin) {
        this.plugin = plugin;
    }

    @Override
    public WorldGroup getGroup(String groupName) {
        return this.groupNamesMap.get(groupName.toLowerCase());
    }

    @Override
    public List<WorldGroup> getGroups() {
        return Collections.unmodifiableList(new ArrayList<WorldGroup>(this.getGroupNames().values()));
    }

    @Override
    public List<WorldGroup> getGroupsForWorld(String worldName) {
        worldName = worldName.toLowerCase();
        ArrayList<WorldGroup> worldGroups = new ArrayList<WorldGroup>();
        for (WorldGroup worldGroup : this.getGroupNames().values()) {
            if (!worldGroup.containsWorld(worldName)) continue;
            worldGroups.add(worldGroup);
        }
        if (worldGroups.isEmpty() && this.plugin.getMVIConfig().isDefaultingUngroupedWorlds() && this.plugin.getCore().getMVWorldManager().isMVWorld(worldName)) {
            InvLogging.finer("Returning default group for world: " + worldName, new Object[0]);
            worldGroups.add(this.getDefaultGroup());
        }
        return worldGroups;
    }

    @Override
    public boolean hasGroup(String worldName) {
        return !this.getGroupsForWorld(worldName).isEmpty();
    }

    protected Map<String, WorldGroup> getGroupNames() {
        return this.groupNamesMap;
    }

    @Override
    @Deprecated
    public void addGroup(WorldGroup worldGroup, boolean persist) {
        this.updateGroup(worldGroup);
    }

    @Override
    public void updateGroup(WorldGroup worldGroup) {
        this.getGroupNames().put(worldGroup.getName().toLowerCase(), worldGroup);
    }

    protected void persistGroup(WorldGroup worldGroup) {
    }

    @Override
    public boolean removeGroup(WorldGroup worldGroup) {
        return this.getGroupNames().remove(worldGroup.getName().toLowerCase()) != null;
    }

    @Override
    public WorldGroup newEmptyGroup(String name) {
        if (this.getGroup(name) != null) {
            return null;
        }
        return new WorldGroup(this.plugin, name);
    }

    @Override
    @Deprecated
    public void setGroups(List<WorldGroup> worldGroups) {
    }

    @Override
    public void createDefaultGroup() {
        if (this.getGroup(DEFAULT_GROUP_NAME) != null) {
            return;
        }
        World defaultWorld = (World)Bukkit.getWorlds().get(0);
        World defaultNether = Bukkit.getWorld((String)(defaultWorld.getName() + "_nether"));
        World defaultEnd = Bukkit.getWorld((String)(defaultWorld.getName() + "_the_end"));
        WorldGroup worldGroup = new WorldGroup(this.plugin, DEFAULT_GROUP_NAME);
        worldGroup.getShares().mergeShares(Sharables.allOf());
        worldGroup.addWorld(defaultWorld);
        StringBuilder worlds = new StringBuilder().append(defaultWorld.getName());
        if (defaultNether != null) {
            worldGroup.addWorld(defaultNether);
            worlds.append(", ").append(defaultNether.getName());
        }
        if (defaultEnd != null) {
            worldGroup.addWorld(defaultEnd);
            worlds.append(", ").append(defaultEnd.getName());
        }
        this.updateGroup(worldGroup);
        this.plugin.getMVIConfig().setFirstRun(false);
        this.plugin.getMVIConfig().save();
        InvLogging.info("Created a default group for you containing all of your default worlds: " + worlds.toString(), new Object[0]);
    }

    @Override
    public WorldGroup getDefaultGroup() {
        WorldGroup group = this.getGroupNames().get(DEFAULT_GROUP_NAME);
        if (group == null) {
            group = this.newEmptyGroup(DEFAULT_GROUP_NAME);
            group.getShares().setSharing(Sharables.allOf(), true);
            this.updateGroup(group);
        }
        return group;
    }

    @Override
    public List<GroupingConflict> checkGroups() {
        ArrayList<GroupingConflict> conflicts = new ArrayList<GroupingConflict>();
        HashMap<WorldGroup, WorldGroup> previousConflicts = new HashMap<WorldGroup, WorldGroup>();
        for (WorldGroup checkingGroup : this.getGroupNames().values()) {
            for (String worldName : checkingGroup.getWorlds()) {
                for (WorldGroup worldGroup : this.getGroupsForWorld(worldName)) {
                    if (checkingGroup.equals(worldGroup) || previousConflicts.containsKey(checkingGroup) && ((WorldGroup)previousConflicts.get(checkingGroup)).equals(worldGroup) || previousConflicts.containsKey(worldGroup) && ((WorldGroup)previousConflicts.get(worldGroup)).equals(checkingGroup)) continue;
                    previousConflicts.put(checkingGroup, worldGroup);
                    Shares conflictingShares = worldGroup.getShares().compare(checkingGroup.getShares());
                    if (conflictingShares.isEmpty() || checkingGroup.getWorlds().containsAll(worldGroup.getWorlds()) || worldGroup.getWorlds().containsAll(checkingGroup.getWorlds())) continue;
                    conflicts.add(new GroupingConflict(checkingGroup, worldGroup, Sharables.fromShares(conflictingShares)));
                }
            }
        }
        return conflicts;
    }

    @Override
    public void checkForConflicts(CommandSender sender) {
        String message = this.plugin.getMessager().getMessage(Message.CONFLICT_CHECKING, new Object[0]);
        if (sender != null) {
            this.plugin.getMessager().sendMessage(sender, message);
        }
        InvLogging.fine(message, new Object[0]);
        List<GroupingConflict> conflicts = this.plugin.getGroupManager().checkGroups();
        for (GroupingConflict conflict : conflicts) {
            message = this.plugin.getMessager().getMessage(Message.CONFLICT_RESULTS, conflict.getFirstGroup().getName(), conflict.getSecondGroup().getName(), conflict.getConflictingShares().toString(), conflict.getWorldsString());
            if (sender != null) {
                this.plugin.getMessager().sendMessage(sender, message);
            }
            InvLogging.info(message, new Object[0]);
        }
        if (!conflicts.isEmpty()) {
            message = this.plugin.getMessager().getMessage(Message.CONFLICT_FOUND, new Object[0]);
            if (sender != null) {
                this.plugin.getMessager().sendMessage(sender, message);
            }
            InvLogging.info(message, new Object[0]);
        } else {
            message = this.plugin.getMessager().getMessage(Message.CONFLICT_NOT_FOUND, new Object[0]);
            if (sender != null) {
                this.plugin.getMessager().sendMessage(sender, message);
            }
            InvLogging.fine(message, new Object[0]);
        }
    }
}

