/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.listeners;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.enums.TeleportResult;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalPlayerSession;
import com.onarandombox.MultiversePortals.event.MVPortalEvent;
import com.onarandombox.MultiversePortals.listeners.MVPTravelAgent;
import com.onarandombox.buscript.Buscript;
import java.io.File;
import java.util.Date;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PlayerListenerHelper {
    private MultiversePortals plugin;

    public PlayerListenerHelper(MultiversePortals plugin) {
        this.plugin = plugin;
    }

    void stateSuccess(String playerName, String worldName) {
        this.plugin.log(Level.FINE, String.format("MV-Portals is allowing Player '%s' to use the portal '%s'.", playerName, worldName));
    }

    void stateFailure(String playerName, String portalName) {
        this.plugin.log(Level.FINE, String.format("MV-Portals is DENYING Player '%s' access to use the portal '%s'.", playerName, portalName));
    }

    void performTeleport(Player player, Location to, PortalPlayerSession ps, MVDestination d) {
        SafeTTeleporter playerTeleporter;
        TeleportResult result;
        if ((!this.plugin.getCore().getMVConfig().getEnforceAccess() || d.getRequiredPermission() == null || d.getRequiredPermission().length() == 0 || player.hasPermission(d.getRequiredPermission())) && (result = (playerTeleporter = this.plugin.getCore().getSafeTTeleporter()).safelyTeleport((CommandSender)player, (Entity)player, d)) == TeleportResult.SUCCESS) {
            ps.playerDidTeleport(to);
            ps.setTeleportTime(new Date());
            this.stateSuccess(player.getDisplayName(), d.getName());
            return;
        }
        this.stateFailure(player.getDisplayName(), d.getName());
    }

    boolean scriptPortal(Player player, MVDestination d, MVPortal portal, PortalPlayerSession ps) {
        Buscript buscript = this.plugin.getCore().getScriptAPI();
        File handlerScript = new File(buscript.getScriptFolder(), portal.getHandlerScript());
        if (handlerScript.exists()) {
            MVPTravelAgent agent = new MVPTravelAgent(this.plugin.getCore(), d, player);
            buscript.setScriptVariable("portal", (Object)portal);
            buscript.setScriptVariable("player", (Object)player);
            buscript.setScriptVariable("travelAgent", (Object)agent);
            buscript.setScriptVariable("allowPortal", (Object)true);
            buscript.setScriptVariable("portalSession", (Object)ps);
            buscript.executeScript(handlerScript, player.getName());
            buscript.setScriptVariable("portal", null);
            buscript.setScriptVariable("player", null);
            buscript.setScriptVariable("travelAgent", null);
            buscript.setScriptVariable("portalSession", null);
            Object allowObject = buscript.getScriptVariable("allowPortal");
            buscript.setScriptVariable("allowPortal", null);
            if (allowObject instanceof Boolean) {
                if (((Boolean)allowObject).booleanValue()) {
                    MVPortalEvent portalEvent = new MVPortalEvent(d, player, agent, portal);
                    this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
                    if (!portalEvent.isCancelled()) {
                        return true;
                    }
                    this.plugin.log(Level.FINE, "A plugin cancelled the portal after script handling.");
                    return false;
                }
                this.plugin.log(Level.FINE, "Portal denied by script!");
                return false;
            }
            this.plugin.log(Level.FINE, "Portal denied by script because allowPortal not a boolean!");
            return false;
        }
        throw new IllegalStateException();
    }
}

