/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.listeners;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.destination.InvalidDestination;
import com.onarandombox.MultiverseCore.utils.MVEconomist;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalPlayerSession;
import com.onarandombox.MultiversePortals.enums.MoveType;
import com.onarandombox.MultiversePortals.event.MVPortalEvent;
import com.onarandombox.MultiversePortals.listeners.MVPTravelAgent;
import com.onarandombox.MultiversePortals.listeners.PlayerListenerHelper;
import java.util.Date;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.player.PlayerMoveEvent;

public class MVPPlayerMoveListener
implements Listener {
    private MultiversePortals plugin;
    private PlayerListenerHelper helper;

    public MVPPlayerMoveListener(MultiversePortals plugin, PlayerListenerHelper helper) {
        this.plugin = plugin;
        this.helper = helper;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void blockFromTo(BlockFromToEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock() == null || event.getToBlock() == null) {
            return;
        }
        if (this.plugin.getPortalManager().isPortal(event.getToBlock().getLocation())) {
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getPortalManager().isPortal(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerMove(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player p = event.getPlayer();
        Location loc = p.getLocation();
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        ps.setStaleLocation(loc, MoveType.PLAYER_MOVE);
        if (ps.isStaleLocation()) {
            return;
        }
        MVPortal portal = ps.getStandingInPortal();
        if (portal != null && ps.doTeleportPlayer(MoveType.PLAYER_MOVE) && !ps.showDebugInfo()) {
            MVDestination d = portal.getDestination();
            if (d == null) {
                return;
            }
            p.setFallDistance(0.0f);
            if (d instanceof InvalidDestination) {
                this.plugin.log(Level.FINE, "Invalid Destination!");
                return;
            }
            MultiverseWorld world = this.plugin.getCore().getMVWorldManager().getMVWorld(d.getLocation((Entity)p).getWorld().getName());
            if (world == null) {
                return;
            }
            if (!portal.isFrameValid(loc)) {
                return;
            }
            if (portal.getHandlerScript() != null && !portal.getHandlerScript().isEmpty()) {
                if (this.plugin.getCore().getScriptAPI() != null) {
                    try {
                        if (this.helper.scriptPortal(event.getPlayer(), d, portal, ps)) {
                            this.helper.performTeleport(event.getPlayer(), event.getTo(), ps, d);
                        }
                        return;
                    }
                    catch (IllegalStateException illegalStateException) {}
                } else {
                    this.plugin.log(Level.WARNING, "Buscript wasn't initialized, so we can't use scripts!");
                }
            }
            if (!ps.allowTeleportViaCooldown(new Date())) {
                p.sendMessage(ps.getFriendlyRemainingTimeMessage());
                return;
            }
            if (MultiversePortals.EnforcePortalAccess && !this.plugin.getCore().getMVPerms().hasPermission((CommandSender)event.getPlayer(), portal.getPermission().getName(), true)) {
                this.helper.stateFailure(p.getDisplayName(), portal.getName());
                return;
            }
            MVEconomist economist = this.plugin.getCore().getEconomist();
            double price = portal.getPrice();
            Material currency = portal.getCurrency();
            if (price != 0.0 && !p.hasPermission(portal.getExempt())) {
                if (price < 0.0 || economist.isPlayerWealthyEnough(p, price, currency)) {
                    MVPTravelAgent agent = new MVPTravelAgent(this.plugin.getCore(), d, event.getPlayer());
                    MVPortalEvent portalEvent = new MVPortalEvent(d, event.getPlayer(), agent, portal);
                    this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
                    if (!portalEvent.isCancelled()) {
                        if (price < 0.0) {
                            economist.deposit(p, -price, currency);
                        } else {
                            economist.withdraw(p, price, currency);
                        }
                        p.sendMessage(String.format("You have %s %s for using %s.", price > 0.0 ? "been charged" : "earned", economist.formatPrice(price, currency), portal.getName()));
                        this.helper.performTeleport(event.getPlayer(), event.getTo(), ps, d);
                    }
                } else {
                    p.sendMessage(economist.getNSFMessage(currency, "You need " + economist.formatPrice(price, currency) + " to enter the " + portal.getName() + " portal."));
                }
            } else {
                MVPTravelAgent agent = new MVPTravelAgent(this.plugin.getCore(), d, event.getPlayer());
                MVPortalEvent portalEvent = new MVPortalEvent(d, event.getPlayer(), agent, portal);
                this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
                if (!portalEvent.isCancelled()) {
                    this.helper.performTeleport(event.getPlayer(), event.getTo(), ps, d);
                }
            }
        }
    }
}

