/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.listeners;

import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.destination.InvalidDestination;
import com.onarandombox.MultiverseCore.utils.MVEconomist;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.PortalPlayerSession;
import com.onarandombox.MultiversePortals.WorldEditConnection;
import com.onarandombox.MultiversePortals.event.MVPortalEvent;
import com.onarandombox.MultiversePortals.listeners.MVPTravelAgent;
import com.onarandombox.MultiversePortals.listeners.PlayerListenerHelper;
import com.onarandombox.MultiversePortals.utils.PortalFiller;
import com.onarandombox.MultiversePortals.utils.PortalManager;
import java.util.Date;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;

public class MVPPlayerListener
implements Listener {
    private MultiversePortals plugin;
    private PortalFiller filler;
    private PortalManager portalManager;
    private PlayerListenerHelper helper;

    public MVPPlayerListener(MultiversePortals plugin, PlayerListenerHelper helper) {
        this.plugin = plugin;
        this.helper = helper;
        this.portalManager = plugin.getPortalManager();
        this.filler = new PortalFiller(plugin.getCore());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerTeleport(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            this.plugin.log(Level.FINE, "The PlayerTeleportEvent was already cancelled. Doing nothing.");
            return;
        }
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        ps.playerDidTeleport(event.getTo());
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerBucketFill(PlayerBucketFillEvent event) {
        if (event.isCancelled()) {
            this.plugin.log(Level.FINE, "The PlayerBucketFillEvent was already cancelled. Doing nothing.");
            return;
        }
        this.plugin.log(Level.FINER, "Fill: ");
        this.plugin.log(Level.FINER, "Block Clicked: " + event.getBlockClicked() + ":" + event.getBlockClicked().getType());
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), event.getBlockClicked().getLocation());
        if (portal != null) {
            if (ps.isDebugModeOn()) {
                ps.showDebugInfo(portal);
                event.setCancelled(true);
            } else {
                Material fillMaterial = Material.AIR;
                this.plugin.log(Level.FINER, "Fill Material: " + fillMaterial);
                this.filler.fillRegion(portal.getLocation().getRegion(), event.getBlockClicked().getLocation(), fillMaterial, event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (event.isCancelled()) {
            this.plugin.log(Level.FINE, "The PlayerBucketEmptyEvent was already cancelled. Doing nothing.");
            return;
        }
        Location translatedLocation = this.getTranslatedLocation(event.getBlockClicked(), event.getBlockFace());
        this.plugin.log(Level.FINER, "Fill: ");
        this.plugin.log(Level.FINER, "Block Clicked: " + event.getBlockClicked() + ":" + event.getBlockClicked().getType());
        this.plugin.log(Level.FINER, "Translated Block: " + event.getPlayer().getWorld().getBlockAt(translatedLocation) + ":" + event.getPlayer().getWorld().getBlockAt(translatedLocation).getType());
        PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
        MVPortal portal = this.portalManager.getPortal(event.getPlayer(), translatedLocation);
        if (portal != null) {
            if (ps.isDebugModeOn()) {
                ps.showDebugInfo(portal);
                event.setCancelled(true);
            } else {
                if (!portal.playerCanFillPortal(event.getPlayer())) {
                    event.setCancelled(true);
                    return;
                }
                Material fillMaterial = Material.WATER;
                if (event.getBucket().equals((Object)Material.LAVA_BUCKET)) {
                    fillMaterial = Material.LAVA;
                }
                this.plugin.log(Level.FINER, "Fill Material: " + fillMaterial);
                this.filler.fillRegion(portal.getLocation().getRegion(), translatedLocation, fillMaterial, event.getPlayer());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            this.plugin.log(Level.FINE, "The PlayerInteractEvent was already cancelled. Doing nothing.");
            return;
        }
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK && event.getMaterial() == Material.FLINT_AND_STEEL) {
            this.plugin.log(Level.FINER, "Player is lighting block: " + this.plugin.getCore().getLocationManipulation().strCoordsRaw(event.getClickedBlock().getLocation()));
            PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
            Location translatedLocation = this.getTranslatedLocation(event.getClickedBlock(), event.getBlockFace());
            if (!this.portalManager.isPortal(translatedLocation)) {
                return;
            }
            MVPortal portal = this.portalManager.getPortal(event.getPlayer(), translatedLocation);
            if (event.getItem() == null) {
                return;
            }
            if (!this.plugin.getCore().getMVPerms().hasPermission((CommandSender)event.getPlayer(), "multiverse.portal.create", true)) {
                return;
            }
            Material inHand = event.getItem().getType();
            if (portal != null) {
                if (!portal.isFrameValid(translatedLocation)) {
                    return;
                }
                this.plugin.log(Level.FINER, "Right Clicked: ");
                this.plugin.log(Level.FINER, "Block Clicked: " + event.getClickedBlock() + ":" + event.getClickedBlock().getType());
                this.plugin.log(Level.FINER, "Translated Block: " + event.getPlayer().getWorld().getBlockAt(translatedLocation) + ":" + event.getPlayer().getWorld().getBlockAt(translatedLocation).getType());
                this.plugin.log(Level.FINER, "In Hand: " + inHand);
                if (ps.isDebugModeOn()) {
                    ps.showDebugInfo(portal);
                    event.setCancelled(true);
                } else {
                    Material fillMaterial = Material.NETHER_PORTAL;
                    if (translatedLocation.getWorld().getBlockAt(translatedLocation).getType() == Material.NETHER_PORTAL) {
                        fillMaterial = Material.AIR;
                    }
                    this.plugin.log(Level.FINER, "Fill Material: " + fillMaterial);
                    event.setCancelled(this.filler.fillRegion(portal.getLocation().getRegion(), translatedLocation, fillMaterial, event.getPlayer()));
                }
            }
            return;
        }
        Material itemType = this.plugin.getWandMaterial();
        WorldEditConnection worldEdit = this.plugin.getWorldEditConnection();
        if (worldEdit != null && worldEdit.isConnected() || event.getPlayer().getItemInHand().getType() != itemType || !this.plugin.getCore().getMVPerms().hasPermission((CommandSender)event.getPlayer(), "multiverse.portal.create", true) || event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
            MultiverseWorld world = this.plugin.getCore().getMVWorldManager().getMVWorld(event.getPlayer().getWorld().getName());
            event.setCancelled(this.plugin.getPortalSession(event.getPlayer()).setLeftClickSelection(event.getClickedBlock().getLocation().toVector(), world));
        } else if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            MultiverseWorld world = this.plugin.getCore().getMVWorldManager().getMVWorld(event.getPlayer().getWorld().getName());
            event.setCancelled(this.plugin.getPortalSession(event.getPlayer()).setRightClickSelection(event.getClickedBlock().getLocation().toVector(), world));
        }
    }

    private Location getTranslatedLocation(Block clickedBlock, BlockFace face) {
        Location clickedLoc = clickedBlock.getLocation();
        Location newLoc = new Location(clickedBlock.getWorld(), (double)(face.getModX() + clickedLoc.getBlockX()), (double)(face.getModY() + clickedLoc.getBlockY()), (double)(face.getModZ() + clickedLoc.getBlockZ()));
        this.plugin.log(Level.FINEST, "Clicked Block: " + clickedBlock.getLocation());
        this.plugin.log(Level.FINEST, "Translated Block: " + newLoc);
        return newLoc;
    }

    @EventHandler
    public void playerPortal(PlayerPortalEvent event) {
        if (event.isCancelled()) {
            this.plugin.log(Level.FINE, "The PlayerPortalEvent was already cancelled. Doing nothing.");
            return;
        }
        this.plugin.log(Level.FINER, "onPlayerPortal called!");
        PortalManager pm = this.plugin.getPortalManager();
        Location playerPortalLoc = event.getPlayer().getLocation();
        MVPortal portal = pm.getPortal(event.getPlayer(), playerPortalLoc);
        Player p = event.getPlayer();
        if (portal == null && (playerPortalLoc = this.plugin.getCore().getSafeTTeleporter().findPortalBlockNextTo(event.getFrom())) != null) {
            this.plugin.log(Level.FINER, "Player was outside of portal, The location has been successfully translated.");
            portal = pm.getPortal(event.getPlayer(), playerPortalLoc);
        }
        if (portal != null) {
            this.plugin.log(Level.FINER, "There was a portal found!");
            MVDestination portalDest = portal.getDestination();
            if (portalDest != null && !(portalDest instanceof InvalidDestination)) {
                if (!portal.isFrameValid(playerPortalLoc)) {
                    event.getPlayer().sendMessage("This portal's frame is made of an " + ChatColor.RED + "incorrect material." + ChatColor.RED + " You should exit it now.");
                    event.setCancelled(true);
                    return;
                }
                PortalPlayerSession ps = this.plugin.getPortalSession(event.getPlayer());
                if (portal.getHandlerScript() != null && !portal.getHandlerScript().isEmpty()) {
                    try {
                        if (!this.helper.scriptPortal(event.getPlayer(), portalDest, portal, ps)) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                if (!ps.allowTeleportViaCooldown(new Date())) {
                    event.getPlayer().sendMessage(ps.getFriendlyRemainingTimeMessage());
                    event.setCancelled(true);
                    return;
                }
                if (MultiversePortals.EnforcePortalAccess && !this.plugin.getCore().getMVPerms().hasPermission((CommandSender)event.getPlayer(), portal.getPermission().getName(), true)) {
                    this.helper.stateFailure(p.getDisplayName(), portal.getName());
                    event.setCancelled(true);
                    return;
                }
                MVPTravelAgent agent = new MVPTravelAgent(this.plugin.getCore(), portalDest, event.getPlayer());
                event.setTo(portalDest.getLocation((Entity)event.getPlayer()));
                if (portalDest.useSafeTeleporter()) {
                    SafeTTeleporter teleporter = this.plugin.getCore().getSafeTTeleporter();
                    event.setTo(teleporter.getSafeLocation((Entity)event.getPlayer(), portalDest));
                }
                boolean shouldPay = false;
                double price = portal.getPrice();
                Material currency = portal.getCurrency();
                MVEconomist economist = this.plugin.getCore().getEconomist();
                if (price != 0.0 && !p.hasPermission(portal.getExempt())) {
                    shouldPay = true;
                    if (price > 0.0 && !economist.isPlayerWealthyEnough(p, price, currency)) {
                        p.sendMessage(economist.getNSFMessage(currency, "You need " + economist.formatPrice(price, currency) + " to enter the " + portal.getName() + " portal."));
                        event.setCancelled(true);
                        return;
                    }
                }
                agent.setPortalEventTravelAgent(event);
                MVPortalEvent portalEvent = new MVPortalEvent(portalDest, event.getPlayer(), agent, portal);
                this.plugin.getServer().getPluginManager().callEvent((Event)portalEvent);
                if (portalEvent.isCancelled()) {
                    event.setCancelled(true);
                    this.plugin.log(Level.FINE, "Someone cancelled the MVPlayerPortal Event!");
                    return;
                }
                if (shouldPay) {
                    if (price < 0.0) {
                        economist.deposit(p, -price, currency);
                    } else {
                        economist.withdraw(p, price, currency);
                    }
                    p.sendMessage(String.format("You have %s %s for using %s.", price > 0.0 ? "been charged" : "earned", economist.formatPrice(price, currency), portal.getName()));
                }
                this.plugin.log(Level.FINE, "Sending player to a location via our Sexy Travel Agent!");
            } else if (!this.plugin.getMainConfig().getBoolean("portalsdefaulttonether", false)) {
                event.getPlayer().sendMessage(String.format("This portal %sdoesn't go anywhere. You should exit it now.", ChatColor.RED));
                this.plugin.log(Level.FINE, "Event canceled because this was a MVPortal with an invalid destination. But you had 'portalsdefaulttonether' set to false!");
                event.setCancelled(true);
            }
        }
    }
}

