/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiversePortals.listeners;

import com.onarandombox.MultiverseCore.event.MVConfigReloadEvent;
import com.onarandombox.MultiverseCore.event.MVDebugModeEvent;
import com.onarandombox.MultiverseCore.event.MVPlayerTouchedPortalEvent;
import com.onarandombox.MultiverseCore.event.MVVersionEvent;
import com.onarandombox.MultiversePortals.MVPortal;
import com.onarandombox.MultiversePortals.MultiversePortals;
import com.onarandombox.MultiversePortals.utils.MVPLogging;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class MVPCoreListener
implements Listener {
    private MultiversePortals plugin;

    public MVPCoreListener(MultiversePortals plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void versionRequest(MVVersionEvent event) {
        event.appendVersionInfo(this.plugin.getVersionInfo());
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        File portalsFile = new File(this.plugin.getDataFolder(), "portals.yml");
        event.putDetailedVersionInfo("multiverse-portals/config.yml", configFile);
        event.putDetailedVersionInfo("multiverse-portals/portals.yml", portalsFile);
    }

    @EventHandler
    public void configReload(MVConfigReloadEvent event) {
        this.plugin.reloadConfigs();
        event.addConfig("Multiverse-Portals - portals.yml");
        event.addConfig("Multiverse-Portals - config.yml");
    }

    @EventHandler
    public void debugModeChange(MVDebugModeEvent event) {
        MVPLogging.setDebugLevel(event.getLevel());
    }

    @EventHandler
    public void portalTouchEvent(MVPlayerTouchedPortalEvent event) {
        this.plugin.log(Level.FINER, "Found The TouchedPortal event.");
        Location l = event.getBlockTouched();
        if (event.canUseThisPortal() && this.plugin.getPortalManager().isPortal(l)) {
            if (this.plugin.getPortalSession(event.getPlayer()).isDebugModeOn()) {
                event.setCancelled(true);
                return;
            }
            MVPortal p = this.plugin.getPortalManager().getPortal(event.getPlayer(), l);
            if (p == null) {
                this.plugin.log(Level.FINER, String.format("'%s' was DENIED access to this portal event.", event.getPlayer().getName()));
                event.setCanUseThisPortal(false);
            } else if (p.getDestination() == null || !p.getDestination().isValid()) {
                if (this.plugin.getMainConfig().getBoolean("portalsdefaulttonether", false)) {
                    this.plugin.log(Level.FINE, "Allowing MVPortal to act as nether portal.");
                    return;
                }
                this.plugin.getCore().getMessaging().sendMessage((CommandSender)event.getPlayer(), "This Multiverse Portal does not have a valid destination!", false);
                event.setCanUseThisPortal(false);
            }
        }
    }
}

