/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils.webpaste;

import com.onarandombox.MultiverseCore.utils.webpaste.HttpAPIClient;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteFailedException;
import com.onarandombox.MultiverseCore.utils.webpaste.PasteService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

class PasteGGPasteService
extends PasteService {
    private final boolean isPrivate;
    private static final String PASTEGG_POST_REQUEST = "https://api.paste.gg/v1/pastes";

    PasteGGPasteService(boolean isPrivate) {
        super(PASTEGG_POST_REQUEST);
        this.isPrivate = isPrivate;
    }

    @Override
    String encodeData(String data) {
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("multiverse.txt", data);
        return this.encodeData(mapData);
    }

    @Override
    String encodeData(Map<String, String> files) {
        JSONObject root = new JSONObject();
        root.put((Object)"name", (Object)"Multiverse-Core Debug Info");
        root.put((Object)"visibility", (Object)(this.isPrivate ? "unlisted" : "public"));
        JSONArray fileList = new JSONArray();
        for (Map.Entry<String, String> entry : files.entrySet()) {
            JSONObject fileObject = new JSONObject();
            JSONObject contentObject = new JSONObject();
            fileObject.put((Object)"name", (Object)entry.getKey());
            fileObject.put((Object)"content", (Object)contentObject);
            contentObject.put((Object)"format", (Object)"text");
            contentObject.put((Object)"value", (Object)entry.getValue());
            fileList.add((Object)fileObject);
        }
        root.put((Object)"files", (Object)fileList);
        return root.toJSONString();
    }

    @Override
    public String postData(String data) throws PasteFailedException {
        try {
            String stringJSON = this.exec(this.encodeData(data), HttpAPIClient.ContentType.JSON);
            return (String)((JSONObject)((JSONObject)new JSONParser().parse(stringJSON)).get((Object)"result")).get((Object)"id");
        }
        catch (IOException | ParseException e) {
            throw new PasteFailedException(e);
        }
    }

    @Override
    public String postData(Map<String, String> data) throws PasteFailedException {
        try {
            String stringJSON = this.exec(this.encodeData(data), HttpAPIClient.ContentType.JSON);
            return "https://paste.gg/" + ((JSONObject)((JSONObject)new JSONParser().parse(stringJSON)).get((Object)"result")).get((Object)"id");
        }
        catch (IOException | ParseException e) {
            throw new PasteFailedException(e);
        }
    }

    @Override
    public boolean supportsMultiFile() {
        return true;
    }
}

