/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldNameChecker {
    private static final Pattern WORLD_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9/._-]+");
    private static final Set<String> BLACKLIST_NAMES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("plugins");
            this.add("logs");
            this.add("cache");
            this.add("crash-reports");
        }
    });

    public static boolean isValidWorldName(@Nullable String worldName) {
        return WorldNameChecker.checkName(worldName) == NameStatus.VALID;
    }

    @NotNull
    public static NameStatus checkName(@Nullable String worldName) {
        if (BLACKLIST_NAMES.contains(worldName)) {
            NameStatus nameStatus = NameStatus.BLACKLISTED;
            if (nameStatus == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkName must not return null");
            }
            return nameStatus;
        }
        if (worldName == null || !WORLD_NAME_PATTERN.matcher(worldName).matches()) {
            NameStatus nameStatus = NameStatus.INVALID_CHARS;
            if (nameStatus == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkName must not return null");
            }
            return nameStatus;
        }
        NameStatus nameStatus = NameStatus.VALID;
        if (nameStatus == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkName must not return null");
        }
        return nameStatus;
    }

    public static boolean isValidWorldFolder(@Nullable String worldName) {
        return WorldNameChecker.checkFolder(worldName) == FolderStatus.VALID;
    }

    public static boolean isValidWorldFolder(@Nullable File worldFolder) {
        return WorldNameChecker.checkFolder(worldFolder) == FolderStatus.VALID;
    }

    @NotNull
    public static FolderStatus checkFolder(@Nullable String worldName) {
        if (worldName == null) {
            FolderStatus folderStatus = FolderStatus.DOES_NOT_EXIST;
            if (folderStatus == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkFolder must not return null");
            }
            return folderStatus;
        }
        File worldFolder = new File(Bukkit.getWorldContainer(), worldName);
        FolderStatus folderStatus = WorldNameChecker.checkFolder(worldFolder);
        if (folderStatus == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkFolder must not return null");
        }
        return folderStatus;
    }

    @NotNull
    public static FolderStatus checkFolder(@Nullable File worldFolder) {
        if (worldFolder == null || !worldFolder.exists() || !worldFolder.isDirectory()) {
            FolderStatus folderStatus = FolderStatus.DOES_NOT_EXIST;
            if (folderStatus == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkFolder must not return null");
            }
            return folderStatus;
        }
        if (!WorldNameChecker.folderHasDat(worldFolder)) {
            FolderStatus folderStatus = FolderStatus.NOT_A_WORLD;
            if (folderStatus == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkFolder must not return null");
            }
            return folderStatus;
        }
        FolderStatus folderStatus = FolderStatus.VALID;
        if (folderStatus == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/utils/WorldNameChecker.checkFolder must not return null");
        }
        return folderStatus;
    }

    private static boolean folderHasDat(@NotNull File worldFolder) {
        if (worldFolder == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/WorldNameChecker.folderHasDat must not be null");
        }
        File[] files = worldFolder.listFiles((file, name) -> name.toLowerCase().endsWith(".dat"));
        return files != null && files.length > 0;
    }

    public static enum FolderStatus {
        VALID,
        NOT_A_WORLD,
        DOES_NOT_EXIST;

    }

    public static enum NameStatus {
        VALID,
        INVALID_CHARS,
        BLACKLISTED;

    }
}

