/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.api.SafeTTeleporter;
import com.onarandombox.MultiverseCore.destination.InvalidDestination;
import com.onarandombox.MultiverseCore.enums.TeleportResult;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.util.Vector;

public class SimpleSafeTTeleporter
implements SafeTTeleporter {
    private MultiverseCore plugin;
    private static final int DEFAULT_TOLERANCE = 6;
    private static final int DEFAULT_RADIUS = 9;

    public SimpleSafeTTeleporter(MultiverseCore plugin) {
        this.plugin = plugin;
    }

    @Override
    public Location getSafeLocation(Location l) {
        return this.getSafeLocation(l, 6, 9);
    }

    @Override
    public Location getSafeLocation(Location l, int tolerance, int radius) {
        Location safe = this.checkAboveAndBelowLocation(l, tolerance, radius);
        if (safe != null) {
            safe.setX((double)safe.getBlockX() + 0.5);
            safe.setZ((double)safe.getBlockZ() + 0.5);
            CoreLogging.fine("Hey! I found one: " + this.plugin.getLocationManipulation().strCoordsRaw(safe), new Object[0]);
        } else {
            CoreLogging.fine("Uh oh! No safe place found!", new Object[0]);
        }
        return safe;
    }

    private Location checkAboveAndBelowLocation(Location l, int tolerance, int radius) {
        if (tolerance % 2 != 0) {
            ++tolerance;
        }
        CoreLogging.finer("Given Location of: " + this.plugin.getLocationManipulation().strCoordsRaw(l), new Object[0]);
        CoreLogging.finer("Checking +-" + (tolerance /= 2) + " with a radius of " + radius, new Object[0]);
        Location locToCheck = l.clone();
        Location safe = this.checkAroundLocation(locToCheck, radius);
        if (safe != null) {
            return safe;
        }
        for (int currentLevel = 1; currentLevel <= tolerance; ++currentLevel) {
            locToCheck = l.clone();
            locToCheck.add(0.0, (double)currentLevel, 0.0);
            safe = this.checkAroundLocation(locToCheck, radius);
            if (safe != null) {
                return safe;
            }
            locToCheck = l.clone();
            locToCheck.subtract(0.0, (double)currentLevel, 0.0);
            safe = this.checkAroundLocation(locToCheck, radius);
            if (safe == null) continue;
            return safe;
        }
        return null;
    }

    private Location checkAroundLocation(Location l, int diameter) {
        if (diameter % 2 == 0) {
            ++diameter;
        }
        Location checkLoc = l.clone();
        for (int loopcounter = 3; loopcounter <= diameter; loopcounter += 2) {
            boolean foundSafeArea = this.checkAroundSpecificDiameter(checkLoc, loopcounter);
            if (foundSafeArea) {
                return checkLoc;
            }
            checkLoc = l.clone();
        }
        return null;
    }

    private boolean checkAroundSpecificDiameter(Location checkLoc, int circle) {
        int i;
        int adjustedCircle = (circle - 1) / 2;
        checkLoc.add((double)adjustedCircle, 0.0, 0.0);
        if (this.plugin.getBlockSafety().playerCanSpawnHereSafely(checkLoc)) {
            return true;
        }
        for (i = 0; i < adjustedCircle; ++i) {
            checkLoc.add(0.0, 0.0, 1.0);
            if (!this.plugin.getBlockSafety().playerCanSpawnHereSafely(checkLoc)) continue;
            return true;
        }
        for (i = 0; i < adjustedCircle * 2; ++i) {
            checkLoc.add(-1.0, 0.0, 0.0);
            if (!this.plugin.getBlockSafety().playerCanSpawnHereSafely(checkLoc)) continue;
            return true;
        }
        for (i = 0; i < adjustedCircle * 2; ++i) {
            checkLoc.add(0.0, 0.0, -1.0);
            if (!this.plugin.getBlockSafety().playerCanSpawnHereSafely(checkLoc)) continue;
            return true;
        }
        for (i = 0; i < adjustedCircle * 2; ++i) {
            checkLoc.add(1.0, 0.0, 0.0);
            if (!this.plugin.getBlockSafety().playerCanSpawnHereSafely(checkLoc)) continue;
            return true;
        }
        for (i = 0; i < adjustedCircle - 1; ++i) {
            checkLoc.add(0.0, 0.0, 1.0);
            if (!this.plugin.getBlockSafety().playerCanSpawnHereSafely(checkLoc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TeleportResult safelyTeleport(CommandSender teleporter, Entity teleportee, MVDestination d) {
        if (d instanceof InvalidDestination) {
            CoreLogging.finer("Entity tried to teleport to an invalid destination", new Object[0]);
            return TeleportResult.FAIL_INVALID;
        }
        Player teleporteePlayer = null;
        if (teleportee instanceof Player) {
            teleporteePlayer = (Player)teleportee;
        } else if (teleportee.getPassenger() instanceof Player) {
            teleporteePlayer = (Player)teleportee.getPassenger();
        }
        if (teleporteePlayer == null) {
            return TeleportResult.FAIL_INVALID;
        }
        MultiverseCore.addPlayerToTeleportQueue(teleporter.getName(), teleporteePlayer.getName());
        Location safeLoc = d.getLocation(teleportee);
        if (d.useSafeTeleporter()) {
            safeLoc = this.getSafeLocation(teleportee, d);
        }
        if (safeLoc != null) {
            if (teleportee.teleport(safeLoc)) {
                if (!d.getVelocity().equals((Object)new Vector(0, 0, 0))) {
                    teleportee.setVelocity(d.getVelocity());
                }
                return TeleportResult.SUCCESS;
            }
            return TeleportResult.FAIL_OTHER;
        }
        return TeleportResult.FAIL_UNSAFE;
    }

    @Override
    public TeleportResult safelyTeleport(CommandSender teleporter, Entity teleportee, Location location, boolean safely) {
        if (safely) {
            location = this.getSafeLocation(location);
        }
        if (location != null) {
            if (teleportee.teleport(location)) {
                return TeleportResult.SUCCESS;
            }
            return TeleportResult.FAIL_OTHER;
        }
        return TeleportResult.FAIL_UNSAFE;
    }

    @Override
    public Location getSafeLocation(Entity e, MVDestination d) {
        Location safeLocation;
        Location l = d.getLocation(e);
        if (this.plugin.getBlockSafety().playerCanSpawnHereSafely(l)) {
            CoreLogging.fine("The first location you gave me was safe.", new Object[0]);
            return l;
        }
        if (e instanceof Minecart) {
            Minecart m = (Minecart)e;
            if (!this.plugin.getBlockSafety().canSpawnCartSafely(m)) {
                return null;
            }
        } else if (e instanceof Vehicle) {
            Vehicle v = (Vehicle)e;
            if (!this.plugin.getBlockSafety().canSpawnVehicleSafely(v)) {
                return null;
            }
        }
        if ((safeLocation = this.getSafeLocation(l)) != null) {
            if (e instanceof Minecart && !this.plugin.getBlockSafety().isEntitiyOnTrack(safeLocation)) {
                safeLocation.setY((double)safeLocation.getBlockY() + 0.5);
                CoreLogging.finer("Player was inside a minecart. Offsetting Y location.", new Object[0]);
            }
            CoreLogging.finer("Had to look for a bit, but I found a safe place for ya!", new Object[0]);
            return safeLocation;
        }
        if (e instanceof Player) {
            Player p = (Player)e;
            this.plugin.getMessaging().sendMessage((CommandSender)p, "No safe locations found!", false);
            CoreLogging.finer("No safe location found for " + p.getName(), new Object[0]);
        } else if (e.getPassenger() instanceof Player) {
            Player p = (Player)e.getPassenger();
            this.plugin.getMessaging().sendMessage((CommandSender)p, "No safe locations found!", false);
            CoreLogging.finer("No safe location found for " + p.getName(), new Object[0]);
        }
        CoreLogging.fine("Sorry champ, you're basically trying to teleport into a minefield. I should just kill you now.", new Object[0]);
        return null;
    }

    @Override
    public Location findPortalBlockNextTo(Location l) {
        Block b = l.getWorld().getBlockAt(l);
        Location foundLocation = null;
        if (b.getType() == Material.NETHER_PORTAL) {
            return l;
        }
        if (b.getRelative(BlockFace.NORTH).getType() == Material.NETHER_PORTAL) {
            foundLocation = SimpleSafeTTeleporter.getCloserBlock(l, b.getRelative(BlockFace.NORTH).getLocation(), foundLocation);
        }
        if (b.getRelative(BlockFace.SOUTH).getType() == Material.NETHER_PORTAL) {
            foundLocation = SimpleSafeTTeleporter.getCloserBlock(l, b.getRelative(BlockFace.SOUTH).getLocation(), foundLocation);
        }
        if (b.getRelative(BlockFace.EAST).getType() == Material.NETHER_PORTAL) {
            foundLocation = SimpleSafeTTeleporter.getCloserBlock(l, b.getRelative(BlockFace.EAST).getLocation(), foundLocation);
        }
        if (b.getRelative(BlockFace.WEST).getType() == Material.NETHER_PORTAL) {
            foundLocation = SimpleSafeTTeleporter.getCloserBlock(l, b.getRelative(BlockFace.WEST).getLocation(), foundLocation);
        }
        return foundLocation;
    }

    private static Location getCloserBlock(Location source, Location blockA, Location blockB) {
        if (blockB == null) {
            return blockA;
        }
        blockA.add(0.5, 0.0, 0.5);
        blockB.add(0.5, 0.0, 0.5);
        double testA = source.distance(blockA);
        double testB = source.distance(blockB);
        if (testA <= testB) {
            return blockA;
        }
        return blockB;
    }

    @Override
    public TeleportResult teleport(CommandSender teleporter, Player teleportee, MVDestination destination) {
        return this.safelyTeleport(teleporter, (Entity)teleportee, destination);
    }
}

