/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.api.LocationManipulation;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Vehicle;
import org.bukkit.util.Vector;

public class SimpleLocationManipulation
implements LocationManipulation {
    private static final Map<String, Integer> ORIENTATION_INTS;

    @Override
    public String locationToString(Location location) {
        if (location == null) {
            return "";
        }
        return String.format(Locale.ENGLISH, "%s:%.2f,%.2f,%.2f:%.2f:%.2f", location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), Float.valueOf(location.getYaw()), Float.valueOf(location.getPitch()));
    }

    @Override
    public Location getBlockLocation(Location l) {
        l.setX((double)l.getBlockX());
        l.setY((double)l.getBlockY());
        l.setZ((double)l.getBlockZ());
        return l;
    }

    @Override
    public Location stringToLocation(String locationString) {
        if (locationString == null) {
            return null;
        }
        String[] split = locationString.split(":");
        if (split.length < 2 || split.length > 4) {
            return null;
        }
        String[] xyzsplit = split[1].split(",");
        if (xyzsplit.length != 3) {
            return null;
        }
        World w = Bukkit.getWorld((String)split[0]);
        if (w == null) {
            return null;
        }
        try {
            float pitch = 0.0f;
            float yaw = 0.0f;
            if (split.length >= 3) {
                yaw = (float)Double.parseDouble(split[2]);
            }
            if (split.length == 4) {
                pitch = (float)Double.parseDouble(split[3]);
            }
            return new Location(w, Double.parseDouble(xyzsplit[0]), Double.parseDouble(xyzsplit[1]), Double.parseDouble(xyzsplit[2]), yaw, pitch);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String strCoords(Location l) {
        String result = "";
        DecimalFormat df = new DecimalFormat();
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(2);
        result = result + ChatColor.WHITE + "X: " + ChatColor.AQUA + df.format(l.getX()) + " ";
        result = result + ChatColor.WHITE + "Y: " + ChatColor.AQUA + df.format(l.getY()) + " ";
        result = result + ChatColor.WHITE + "Z: " + ChatColor.AQUA + df.format(l.getZ()) + " ";
        result = result + ChatColor.WHITE + "P: " + ChatColor.GOLD + df.format(l.getPitch()) + " ";
        result = result + ChatColor.WHITE + "Y: " + ChatColor.GOLD + df.format(l.getYaw()) + " ";
        return result;
    }

    @Override
    public String strCoordsRaw(Location l) {
        if (l == null) {
            return "null";
        }
        String result = "";
        DecimalFormat df = new DecimalFormat();
        df.setMinimumFractionDigits(0);
        df.setMaximumFractionDigits(2);
        result = result + "X: " + df.format(l.getX()) + " ";
        result = result + "Y: " + df.format(l.getY()) + " ";
        result = result + "Z: " + df.format(l.getZ()) + " ";
        result = result + "P: " + df.format(l.getPitch()) + " ";
        result = result + "Y: " + df.format(l.getYaw()) + " ";
        return result;
    }

    @Override
    public String getDirection(Location location) {
        double r = location.getYaw() % 360.0f + 180.0f;
        String dir = r < 22.5 ? "n" : (r < 67.5 ? "ne" : (r < 112.5 ? "e" : (r < 157.5 ? "se" : (r < 202.5 ? "s" : (r < 247.5 ? "sw" : (r < 292.5 ? "w" : (r < 337.5 ? "nw" : "n")))))));
        return dir;
    }

    @Override
    public float getYaw(String orientation) {
        if (orientation == null) {
            return 0.0f;
        }
        if (ORIENTATION_INTS.containsKey(orientation.toLowerCase())) {
            return ORIENTATION_INTS.get(orientation.toLowerCase()).intValue();
        }
        return 0.0f;
    }

    @Override
    public float getSpeed(Vector v) {
        return (float)Math.sqrt(v.getX() * v.getX() + v.getZ() * v.getZ());
    }

    @Override
    public Vector getTranslatedVector(Vector v, String direction) {
        if (direction == null) {
            return v;
        }
        float speed = this.getSpeed(v);
        float halfSpeed = (float)((double)speed / 2.0);
        if (direction.equalsIgnoreCase("n")) {
            return new Vector(0.0f, 0.0f, -1.0f * speed);
        }
        if (direction.equalsIgnoreCase("ne")) {
            return new Vector(halfSpeed, 0.0f, -1.0f * halfSpeed);
        }
        if (direction.equalsIgnoreCase("e")) {
            return new Vector(speed, 0.0f, 0.0f);
        }
        if (direction.equalsIgnoreCase("se")) {
            return new Vector(halfSpeed, 0.0f, halfSpeed);
        }
        if (direction.equalsIgnoreCase("s")) {
            return new Vector(0.0f, 0.0f, speed);
        }
        if (direction.equalsIgnoreCase("sw")) {
            return new Vector(-1.0f * halfSpeed, 0.0f, halfSpeed);
        }
        if (direction.equalsIgnoreCase("w")) {
            return new Vector(-1.0f * speed, 0.0f, 0.0f);
        }
        if (direction.equalsIgnoreCase("nw")) {
            return new Vector(-1.0f * halfSpeed, 0.0f, -1.0f * halfSpeed);
        }
        return v;
    }

    @Override
    public Location getNextBlock(Vehicle v) {
        int x;
        Vector vector = v.getVelocity();
        Location location = v.getLocation();
        int n = vector.getX() < 0.0 ? (vector.getX() == 0.0 ? 0 : -1) : (x = 1);
        int z = vector.getZ() < 0.0 ? (vector.getZ() == 0.0 ? 0 : -1) : 1;
        return location.add((double)x, 0.0, (double)z);
    }

    static {
        HashMap<String, Integer> orientationInts = new HashMap<String, Integer>();
        orientationInts.put("n", 180);
        orientationInts.put("ne", 225);
        orientationInts.put("e", 270);
        orientationInts.put("se", 315);
        orientationInts.put("s", 0);
        orientationInts.put("sw", 45);
        orientationInts.put("w", 90);
        orientationInts.put("nw", 135);
        orientationInts.put("north", 180);
        orientationInts.put("northeast", 225);
        orientationInts.put("east", 270);
        orientationInts.put("southeast", 315);
        orientationInts.put("south", 0);
        orientationInts.put("southwest", 45);
        orientationInts.put("west", 90);
        orientationInts.put("northwest", 135);
        ORIENTATION_INTS = Collections.unmodifiableMap(orientationInts);
    }
}

