/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class ReflectHelper {
    @Nullable
    public static Class<?> getClass(String classPath) {
        try {
            return Class.forName(classPath);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean hasClass(String classPath) {
        return ReflectHelper.getClass(classPath) != null;
    }

    @Nullable
    public static <C> Method getMethod(Class<C> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Nullable
    public static <C> Method getMethod(C classInstance, String methodName, Class<?> ... parameterTypes) {
        return ReflectHelper.getMethod(classInstance.getClass(), methodName, parameterTypes);
    }

    @Nullable
    public static <C, R> R invokeMethod(C classInstance, Method method, Object ... parameters) {
        try {
            return (R)method.invoke(classInstance, parameters);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static <C> Field getField(Class<C> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    @Nullable
    public static <C> Field getField(C classInstance, String fieldName) {
        return ReflectHelper.getField(classInstance.getClass(), fieldName);
    }

    @Nullable
    public static <C, V> V getFieldValue(C classInstance, Field field) {
        try {
            return (V)field.get(classInstance);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }
}

