/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerFinder {
    private static final Pattern UUID_REGEX = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}");
    private static final Pattern COMMA_SPLIT = Pattern.compile(",");

    @Nullable
    public static Player get(@NotNull String playerIdentifier, @NotNull CommandSender sender) {
        if (playerIdentifier == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/PlayerFinder.get must not be null");
        }
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/utils/PlayerFinder.get must not be null");
        }
        Player targetPlayer = PlayerFinder.getByName(playerIdentifier);
        if (targetPlayer != null) {
            return targetPlayer;
        }
        targetPlayer = PlayerFinder.getByUuid(playerIdentifier);
        if (targetPlayer != null) {
            return targetPlayer;
        }
        return PlayerFinder.getBySelector(playerIdentifier, sender);
    }

    @Nullable
    public static List<Player> getMulti(@NotNull String playerIdentifiers, @NotNull CommandSender sender) {
        if (playerIdentifiers == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getMulti must not be null");
        }
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getMulti must not be null");
        }
        String[] playerIdentifierArray = COMMA_SPLIT.split(playerIdentifiers);
        if (playerIdentifierArray == null || playerIdentifierArray.length == 0) {
            return null;
        }
        ArrayList<Player> playerResults = new ArrayList<Player>();
        for (String playerIdentifier : playerIdentifierArray) {
            Player targetPlayer = PlayerFinder.getByName(playerIdentifier);
            if (targetPlayer != null) {
                playerResults.add(targetPlayer);
                continue;
            }
            targetPlayer = PlayerFinder.getByUuid(playerIdentifier);
            if (targetPlayer != null) {
                playerResults.add(targetPlayer);
                continue;
            }
            List<Player> targetPlayers = PlayerFinder.getMultiBySelector(playerIdentifier, sender);
            if (targetPlayers == null) continue;
            playerResults.addAll(targetPlayers);
        }
        return playerResults;
    }

    @Nullable
    public static Player getByName(@NotNull String playerName) {
        if (playerName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getByName must not be null");
        }
        return Bukkit.getPlayerExact((String)playerName);
    }

    @Nullable
    public static Player getByUuid(@NotNull String playerUuid) {
        UUID uuid;
        if (playerUuid == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getByUuid must not be null");
        }
        if (!UUID_REGEX.matcher(playerUuid).matches()) {
            return null;
        }
        try {
            uuid = UUID.fromString(playerUuid);
        }
        catch (Exception e) {
            return null;
        }
        return PlayerFinder.getByUuid(uuid);
    }

    @Nullable
    public static Player getByUuid(@NotNull UUID playerUuid) {
        if (playerUuid == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getByUuid must not be null");
        }
        return Bukkit.getPlayer((UUID)playerUuid);
    }

    @Nullable
    public static Player getBySelector(@NotNull String playerSelector, @NotNull CommandSender sender) {
        if (playerSelector == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getBySelector must not be null");
        }
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getBySelector must not be null");
        }
        List<Player> matchedPlayers = PlayerFinder.getMultiBySelector(playerSelector, sender);
        if (matchedPlayers == null || matchedPlayers.isEmpty()) {
            CoreLogging.fine("No player found with selector '%s' for %s.", playerSelector, sender.getName());
            return null;
        }
        if (matchedPlayers.size() > 1) {
            CoreLogging.warning("Ambiguous selector result '%s' for %s (more than one player matched) - %s", playerSelector, sender.getName(), matchedPlayers.toString());
            return null;
        }
        return matchedPlayers.get(0);
    }

    @Nullable
    public static List<Player> getMultiBySelector(@NotNull String playerSelector, @NotNull CommandSender sender) {
        if (playerSelector == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getMultiBySelector must not be null");
        }
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/utils/PlayerFinder.getMultiBySelector must not be null");
        }
        if (playerSelector.charAt(0) != '@') {
            return null;
        }
        try {
            return Bukkit.selectEntities((CommandSender)sender, (String)playerSelector).stream().filter(e -> e instanceof Player).map(e -> (Player)e).collect(Collectors.toList());
        }
        catch (IllegalArgumentException e2) {
            CoreLogging.warning("An error occurred while parsing selector '%s' for %s. Is it is the correct format?", playerSelector, sender.getName());
            e2.printStackTrace();
            return null;
        }
    }
}

