/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class FileUtils {
    protected FileUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean deleteFolder(File file) {
        boolean bl;
        block8: {
            Stream<Path> files = Files.walk(file.toPath(), new FileVisitOption[0]);
            try {
                files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                bl = true;
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CoreLogging.warning(e.getMessage(), new Object[0]);
                    return false;
                }
            }
            files.close();
        }
        return bl;
    }

    public static boolean deleteFolderContents(File file) {
        boolean bl;
        block8: {
            Stream<Path> files = Files.walk(file.toPath(), new FileVisitOption[0]);
            try {
                files.sorted(Comparator.reverseOrder()).map(Path::toFile).filter(f -> !f.equals(file)).forEach(File::delete);
                bl = true;
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CoreLogging.warning(e.getMessage(), new Object[0]);
                    return false;
                }
            }
            files.close();
        }
        return bl;
    }

    public static boolean copyFolder(File source, File target) {
        return FileUtils.copyFolder(source, target, null);
    }

    public static boolean copyFolder(File source, File target, List<String> excludeFiles) {
        Path sourceDir = source.toPath();
        Path targetDir = target.toPath();
        try {
            Files.walkFileTree(sourceDir, new CopyDirFileVisitor(sourceDir, targetDir, excludeFiles));
            return true;
        }
        catch (IOException e) {
            CoreLogging.warning("Unable to copy directory", e);
            return false;
        }
    }

    private static class CopyDirFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path sourceDir;
        private final Path targetDir;
        private final List<String> excludeFiles;

        private CopyDirFileVisitor(Path sourceDir, Path targetDir, List<String> excludeFiles) {
            this.sourceDir = sourceDir;
            this.targetDir = targetDir;
            this.excludeFiles = excludeFiles;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path newDir = this.targetDir.resolve(this.sourceDir.relativize(dir));
            if (!Files.isDirectory(newDir, new LinkOption[0])) {
                Files.createDirectory(newDir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.excludeFiles != null && this.excludeFiles.contains(file.getFileName().toString())) {
                return FileVisitResult.CONTINUE;
            }
            Path targetFile = this.targetDir.resolve(this.sourceDir.relativize(file));
            Files.copy(file, targetFile, StandardCopyOption.COPY_ATTRIBUTES);
            return FileVisitResult.CONTINUE;
        }
    }
}

