/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.utils;

import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.MultiverseCore.utils.ReflectHelper;
import java.lang.reflect.Method;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerRespawnEvent;

public class CompatibilityLayer {
    private static Method checkAnchorSpawn;
    private static boolean useTravelAgent;
    private static Method playerPortalSearchRadius;
    private static Method entityPortalSearchRadius;

    public static void init() {
        checkAnchorSpawn = ReflectHelper.getMethod(PlayerRespawnEvent.class, "isAnchorSpawn", new Class[0]);
        useTravelAgent = ReflectHelper.hasClass("org.bukkit.TravelAgent");
        playerPortalSearchRadius = ReflectHelper.getMethod(PlayerPortalEvent.class, "setSearchRadius", new Class[]{Integer.TYPE});
        entityPortalSearchRadius = ReflectHelper.getMethod(EntityPortalEvent.class, "setSearchRadius", new Class[]{Integer.TYPE});
    }

    public static boolean isAnchorSpawn(PlayerRespawnEvent event) {
        if (checkAnchorSpawn == null) {
            return false;
        }
        Boolean result = (Boolean)ReflectHelper.invokeMethod(event, checkAnchorSpawn, new Object[0]);
        if (result == null) {
            CoreLogging.warning("Unable to check if spawning at respawn anchor!", new Object[0]);
            return false;
        }
        return result;
    }

    public static boolean isUseTravelAgent() {
        return useTravelAgent;
    }

    public static void setPortalSearchRadius(PlayerPortalEvent event, int searchRadius) {
        if (useTravelAgent) {
            event.getPortalTravelAgent().setSearchRadius(searchRadius);
            event.useTravelAgent(true);
            CoreLogging.finer("Used travel agent to set player portal search radius.", new Object[0]);
            return;
        }
        if (playerPortalSearchRadius == null) {
            CoreLogging.warning("Unable to set player portal search radius!", new Object[0]);
            return;
        }
        ReflectHelper.invokeMethod(event, playerPortalSearchRadius, searchRadius);
        CoreLogging.finer("Used new method to set player portal search radius.", new Object[0]);
    }

    public static void setPortalSearchRadius(EntityPortalEvent event, int searchRadius) {
        if (useTravelAgent) {
            event.getPortalTravelAgent().setSearchRadius(searchRadius);
            event.useTravelAgent(true);
            CoreLogging.finer("Used travel agent to set entity portal search radius.", new Object[0]);
            return;
        }
        if (entityPortalSearchRadius == null) {
            CoreLogging.warning("Unable to set entity portal search radius!", new Object[0]);
            return;
        }
        ReflectHelper.invokeMethod(event, entityPortalSearchRadius, searchRadius);
        CoreLogging.finer("Used new method to set entity portal search radius.", new Object[0]);
    }
}

