/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.listeners;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.enums.RespawnType;
import com.onarandombox.MultiverseCore.event.MVRespawnEvent;
import com.onarandombox.MultiverseCore.utils.CompatibilityLayer;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import com.onarandombox.MultiverseCore.utils.PermissionTools;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class MVPlayerListener
implements Listener {
    private final MultiverseCore plugin;
    private final MVWorldManager worldManager;
    private final PermissionTools pt;
    private final Map<String, String> playerWorld = new ConcurrentHashMap<String, String>();

    public MVPlayerListener(MultiverseCore plugin) {
        this.plugin = plugin;
        this.worldManager = plugin.getMVWorldManager();
        this.pt = new PermissionTools(plugin);
    }

    public Map<String, String> getPlayerWorld() {
        return this.playerWorld;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void playerRespawn(PlayerRespawnEvent event) {
        World world = event.getPlayer().getWorld();
        MultiverseWorld mvWorld = this.worldManager.getMVWorld(world.getName());
        if (mvWorld == null) {
            return;
        }
        RespawnType respawnType = RespawnType.OTHER;
        if (event.isBedSpawn()) {
            respawnType = RespawnType.BED;
        }
        if (CompatibilityLayer.isAnchorSpawn(event)) {
            respawnType = RespawnType.ANCHOR;
        }
        if (mvWorld.getBedRespawn() && (respawnType == RespawnType.BED || respawnType == RespawnType.ANCHOR)) {
            CoreLogging.fine("Spawning %s at their %s", new Object[]{event.getPlayer().getName(), respawnType});
            return;
        }
        MultiverseWorld respawnWorld = null;
        if (this.worldManager.isMVWorld(mvWorld.getRespawnToWorld())) {
            respawnWorld = this.worldManager.getMVWorld(mvWorld.getRespawnToWorld());
        }
        if (respawnWorld != null) {
            world = respawnWorld.getCBWorld();
        }
        Location respawnLocation = this.getMostAccurateRespawnLocation(world);
        MVRespawnEvent respawnEvent = new MVRespawnEvent(respawnLocation, event.getPlayer(), "compatability");
        this.plugin.getServer().getPluginManager().callEvent((Event)respawnEvent);
        event.setRespawnLocation(respawnEvent.getPlayersRespawnLocation());
    }

    private Location getMostAccurateRespawnLocation(World w) {
        MultiverseWorld mvw = this.worldManager.getMVWorld(w.getName());
        if (mvw != null) {
            return mvw.getSpawnLocation();
        }
        return w.getSpawnLocation();
    }

    @EventHandler
    public void playerJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        if (!p.hasPlayedBefore()) {
            CoreLogging.finer("Player joined for the FIRST time!", new Object[0]);
            if (this.plugin.getMVConfig().getFirstSpawnOverride()) {
                CoreLogging.fine("Moving NEW player to(firstspawnoverride): " + this.worldManager.getFirstSpawnWorld().getSpawnLocation(), new Object[0]);
                this.sendPlayerToDefaultWorld(p);
            }
            return;
        }
        CoreLogging.finer("Player joined AGAIN!", new Object[0]);
        if (this.plugin.getMVConfig().getEnforceAccess() && !this.plugin.getMVPerms().hasPermission((CommandSender)p, "multiverse.access." + p.getWorld().getName(), false)) {
            p.sendMessage("[MV] - Sorry you can't be in this world anymore!");
            this.sendPlayerToDefaultWorld(p);
        }
        this.handleGameModeAndFlight(event.getPlayer(), event.getPlayer().getWorld());
        this.playerWorld.put(p.getName(), p.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerChangedWorld(PlayerChangedWorldEvent event) {
        this.handleGameModeAndFlight(event.getPlayer(), event.getPlayer().getWorld());
        this.playerWorld.put(event.getPlayer().getName(), event.getPlayer().getWorld().getName());
    }

    @EventHandler
    public void playerQuit(PlayerQuitEvent event) {
        this.plugin.removePlayerSession(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void playerTeleport(PlayerTeleportEvent event) {
        CoreLogging.finer("Got teleport event for player '" + event.getPlayer().getName() + "' with cause '" + event.getCause() + "'", new Object[0]);
        if (event.isCancelled()) {
            return;
        }
        Player teleportee = event.getPlayer();
        Player teleporter = null;
        String teleporterName = MultiverseCore.getPlayerTeleporter(teleportee.getName());
        if (teleporterName != null) {
            if (teleporterName.equals("CONSOLE")) {
                CoreLogging.finer("We know the teleporter is the console! Magical!", new Object[0]);
                teleporter = this.plugin.getServer().getConsoleSender();
            } else {
                teleporter = this.plugin.getServer().getPlayerExact(teleporterName);
            }
        }
        CoreLogging.finer("Inferred sender '" + teleporter + "' from name '" + teleporterName + "', fetched from name '" + teleportee.getName() + "'", new Object[0]);
        MultiverseWorld fromWorld = this.worldManager.getMVWorld(event.getFrom().getWorld().getName());
        MultiverseWorld toWorld = this.worldManager.getMVWorld(event.getTo().getWorld().getName());
        if (toWorld == null) {
            CoreLogging.fine("Player '" + teleportee.getName() + "' is teleporting to world '" + event.getTo().getWorld().getName() + "' which is not managed by Multiverse-Core.  No further actions will be taken by Multiverse-Core.", new Object[0]);
            return;
        }
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            CoreLogging.finer("Player '" + teleportee.getName() + "' is teleporting to the same world.", new Object[0]);
            this.stateSuccess(teleportee.getName(), toWorld.getAlias());
            return;
        }
        event.setCancelled(!this.pt.playerHasMoneyToEnter(fromWorld, toWorld, (CommandSender)teleporter, teleportee, true));
        if (event.isCancelled() && teleporter != null) {
            CoreLogging.fine("Player '" + teleportee.getName() + "' was DENIED ACCESS to '" + toWorld.getAlias() + "' because '" + teleporter.getName() + "' don't have the FUNDS required to enter it.", new Object[0]);
            return;
        }
        if (this.plugin.getMVConfig().getEnforceAccess()) {
            event.setCancelled(!this.pt.playerCanGoFromTo(fromWorld, toWorld, (CommandSender)teleporter, teleportee));
            if (event.isCancelled() && teleporter != null) {
                CoreLogging.fine("Player '" + teleportee.getName() + "' was DENIED ACCESS to '" + toWorld.getAlias() + "' because '" + teleporter.getName() + "' don't have: multiverse.access." + event.getTo().getWorld().getName(), new Object[0]);
                return;
            }
        } else {
            CoreLogging.fine("Player '" + teleportee.getName() + "' was allowed to go to '" + toWorld.getAlias() + "' because enforceaccess is off.", new Object[0]);
        }
        if (toWorld.getPlayerLimit() > -1 && toWorld.getCBWorld().getPlayers().size() >= toWorld.getPlayerLimit() && !this.pt.playerCanBypassPlayerLimit(toWorld, (CommandSender)teleporter, teleportee)) {
            CoreLogging.fine("Player '" + teleportee.getName() + "' was DENIED ACCESS to '" + toWorld.getAlias() + "' because the world is full and '" + teleporter.getName() + "' doesn't have: mv.bypass.playerlimit." + event.getTo().getWorld().getName(), new Object[0]);
            event.setCancelled(true);
            return;
        }
        this.stateSuccess(teleportee.getName(), toWorld.getAlias());
    }

    private void stateSuccess(String playerName, String worldName) {
        CoreLogging.fine("MV-Core is allowing Player '" + playerName + "' to go to '" + worldName + "'.", new Object[0]);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void playerPortalCheck(PlayerPortalEvent event) {
        Location newloc;
        if (event.isCancelled() || event.getFrom() == null) {
            return;
        }
        if (event.getFrom().getWorld().getBlockAt(event.getFrom()).getType() != Material.NETHER_PORTAL && (newloc = this.plugin.getSafeTTeleporter().findPortalBlockNextTo(event.getFrom())) != null) {
            event.setFrom(newloc);
        }
        if (event.getTo() == null) {
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void playerPortal(PlayerPortalEvent event) {
        if (event.isCancelled() || event.getFrom() == null) {
            return;
        }
        if (event.getTo() == null) {
            return;
        }
        MultiverseWorld fromWorld = this.worldManager.getMVWorld(event.getFrom().getWorld().getName());
        MultiverseWorld toWorld = this.worldManager.getMVWorld(event.getTo().getWorld().getName());
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            CoreLogging.finer("Player '" + event.getPlayer().getName() + "' is portaling to the same world.", new Object[0]);
            return;
        }
        event.setCancelled(!this.pt.playerHasMoneyToEnter(fromWorld, toWorld, (CommandSender)event.getPlayer(), event.getPlayer(), true));
        if (event.isCancelled()) {
            CoreLogging.fine("Player '" + event.getPlayer().getName() + "' was DENIED ACCESS to '" + event.getTo().getWorld().getName() + "' because they don't have the FUNDS required to enter.", new Object[0]);
            return;
        }
        if (this.plugin.getMVConfig().getEnforceAccess()) {
            event.setCancelled(!this.pt.playerCanGoFromTo(fromWorld, toWorld, (CommandSender)event.getPlayer(), event.getPlayer()));
            if (event.isCancelled()) {
                CoreLogging.fine("Player '" + event.getPlayer().getName() + "' was DENIED ACCESS to '" + event.getTo().getWorld().getName() + "' because they don't have: multiverse.access." + event.getTo().getWorld().getName(), new Object[0]);
            }
        } else {
            CoreLogging.fine("Player '" + event.getPlayer().getName() + "' was allowed to go to '" + event.getTo().getWorld().getName() + "' because enforceaccess is off.", new Object[0]);
        }
        if (!this.plugin.getMVConfig().isUsingDefaultPortalSearch()) {
            CompatibilityLayer.setPortalSearchRadius(event, this.plugin.getMVConfig().getPortalSearchRadius());
        }
    }

    private void sendPlayerToDefaultWorld(final Player player) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                player.teleport(MVPlayerListener.this.plugin.getMVWorldManager().getFirstSpawnWorld().getSpawnLocation());
            }
        }, 1L);
    }

    private void handleGameModeAndFlight(Player player, World world) {
        MultiverseWorld mvWorld = this.worldManager.getMVWorld(world.getName());
        if (mvWorld != null) {
            this.handleGameModeAndFlight(player, mvWorld);
        } else {
            CoreLogging.finer("Not handling gamemode and flight for world '" + world.getName() + "' not managed by Multiverse.", new Object[0]);
        }
    }

    public void handleGameModeAndFlight(final Player player, final MultiverseWorld world) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (!MVPlayerListener.this.pt.playerCanIgnoreGameModeRestriction(world, player)) {
                    if (player.getWorld() == world.getCBWorld()) {
                        CoreLogging.fine("Handling gamemode for player: %s, Changing to %s", player.getName(), world.getGameMode().toString());
                        CoreLogging.finest("From World: %s", player.getWorld());
                        CoreLogging.finest("To World: %s", world);
                        player.setGameMode(world.getGameMode());
                        if (player.getAllowFlight() && !world.getAllowFlight() && player.getGameMode() != GameMode.CREATIVE) {
                            player.setAllowFlight(false);
                            if (player.isFlying()) {
                                player.setFlying(false);
                            }
                        } else if (world.getAllowFlight() && player.getGameMode() == GameMode.CREATIVE) {
                            player.setAllowFlight(true);
                        }
                    } else {
                        CoreLogging.fine("The gamemode/allowfly was NOT changed for player '%s' because he is now in world '%s' instead of world '%s'", player.getName(), player.getWorld().getName(), world.getName());
                    }
                } else {
                    CoreLogging.fine("Player: " + player.getName() + " is IMMUNE to gamemode changes!", new Object[0]);
                }
            }
        }, 1L);
    }
}

