/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.event;

import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class MVVersionEvent
extends Event {
    private final StringBuilder versionInfoBuilder = new StringBuilder();
    private final Map<String, String> detailedVersionInfo = new HashMap<String, String>();
    private static final HandlerList HANDLERS = new HandlerList();

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public String getVersionInfo() {
        return this.versionInfoBuilder.toString();
    }

    public Map<String, String> getDetailedVersionInfo() {
        return Collections.unmodifiableMap(this.detailedVersionInfo);
    }

    public void appendVersionInfo(String moreVersionInfo) {
        this.versionInfoBuilder.append(moreVersionInfo);
    }

    private String readFile(String filename) {
        StringBuilder result;
        try {
            String line;
            FileReader reader = new FileReader(filename);
            BufferedReader bufferedReader = new BufferedReader(reader);
            result = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line).append("\n");
            }
        }
        catch (FileNotFoundException e) {
            CoreLogging.severe("Unable to find %s. Here's the traceback: %s", filename, e.getMessage());
            e.printStackTrace();
            result = new StringBuilder(String.format("ERROR: Could not load: %s", filename));
        }
        catch (IOException e) {
            CoreLogging.severe("Something bad happend when reading %s. Here's the traceback: %s", filename, e.getMessage());
            e.printStackTrace();
            result = new StringBuilder(String.format("ERROR: Could not load: %s", filename));
        }
        return result.toString();
    }

    public void putDetailedVersionInfo(String fileName, String contents) {
        this.detailedVersionInfo.put(fileName, contents);
    }

    public void putDetailedVersionInfo(String filename, File file) {
        this.putDetailedVersionInfo(filename, this.readFile(file.getAbsolutePath()));
    }
}

