/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.display.handlers;

import com.onarandombox.MultiverseCore.display.ContentDisplay;
import com.onarandombox.MultiverseCore.display.DisplayFormatException;
import com.onarandombox.MultiverseCore.display.handlers.ListDisplayHandler;
import com.onarandombox.MultiverseCore.display.settings.PagedDisplaySettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.IntStream;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.jetbrains.annotations.NotNull;

public class PagedListDisplayHandler
extends ListDisplayHandler {
    @Override
    public Collection<String> format(@NotNull CommandSender sender, @NotNull ContentDisplay<Collection<String>> display) throws DisplayFormatException {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/handlers/PagedListDisplayHandler.format must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/display/handlers/PagedListDisplayHandler.format must not be null");
        }
        if (this.dontNeedPaging(sender, display)) {
            return super.format(sender, display);
        }
        int pages = 1;
        int currentLength = 0;
        int targetPage = display.getSetting(PagedDisplaySettings.SHOW_PAGE);
        int linesPerPage = display.getSetting(PagedDisplaySettings.LINES_PER_PAGE);
        ArrayList<String> content = new ArrayList<String>(linesPerPage);
        for (String line : display.getContents()) {
            if (!display.getFilter().checkMatch(line)) continue;
            boolean isLineBreak = "%br%".equals(line);
            if (isLineBreak || ++currentLength > linesPerPage) {
                ++pages;
                currentLength = 0;
                if (isLineBreak) continue;
            }
            if (pages != targetPage) continue;
            if (display.getHeader() == null) {
                display.setHeader(line);
                --currentLength;
                continue;
            }
            content.add(display.getColorTool().get() + line);
        }
        if (targetPage < 1 || targetPage > pages) {
            if (pages == 1) {
                throw new DisplayFormatException("There is only 1 page!");
            }
            throw new DisplayFormatException("Please enter a page from 1 to " + pages + ".");
        }
        if (content.size() == 0) {
            content.add(display.getEmptyMessage());
        }
        if (display.getSetting(PagedDisplaySettings.DO_END_PADDING).booleanValue()) {
            IntStream.range(0, linesPerPage - content.size()).forEach(i -> content.add(""));
        }
        display.setSetting(PagedDisplaySettings.TOTAL_PAGE, pages);
        return content;
    }

    @Override
    public void sendSubHeader(@NotNull CommandSender sender, @NotNull ContentDisplay<Collection<String>> display) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/handlers/PagedListDisplayHandler.sendSubHeader must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/display/handlers/PagedListDisplayHandler.sendSubHeader must not be null");
        }
        if (this.dontNeedPaging(sender, display)) {
            super.sendSubHeader(sender, display);
            return;
        }
        if (display.getFilter().hasFilter()) {
            sender.sendMessage(String.format("%s[ Page %s of %s, %s ]", ChatColor.GRAY, display.getSetting(PagedDisplaySettings.SHOW_PAGE), display.getSetting(PagedDisplaySettings.TOTAL_PAGE), display.getFilter().getFormattedString()));
            return;
        }
        sender.sendMessage(String.format("%s[ Page %s of %s ]", ChatColor.GRAY, display.getSetting(PagedDisplaySettings.SHOW_PAGE), display.getSetting(PagedDisplaySettings.TOTAL_PAGE)));
    }

    private boolean dontNeedPaging(CommandSender sender, ContentDisplay<Collection<String>> display) {
        return sender instanceof ConsoleCommandSender && display.getSetting(PagedDisplaySettings.PAGE_IN_CONSOLE) == false;
    }
}

