/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.display;

import com.google.common.base.Strings;
import com.onarandombox.MultiverseCore.display.ContentDisplay;
import com.onarandombox.MultiverseCore.display.DisplayFormatException;
import java.util.Collection;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface DisplayHandler<T> {
    public Collection<String> format(@NotNull CommandSender var1, @NotNull ContentDisplay<T> var2) throws DisplayFormatException;

    default public void sendHeader(@NotNull CommandSender sender, @NotNull ContentDisplay<T> display) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/DisplayHandler.sendHeader must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/display/DisplayHandler.sendHeader must not be null");
        }
        if (!Strings.isNullOrEmpty((String)display.getHeader())) {
            sender.sendMessage(display.getHeader());
        }
    }

    default public void sendSubHeader(@NotNull CommandSender sender, @NotNull ContentDisplay<T> display) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/DisplayHandler.sendSubHeader must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/display/DisplayHandler.sendSubHeader must not be null");
        }
        if (display.getFilter().hasFilter()) {
            sender.sendMessage(String.format("%s[ %s ]", ChatColor.GRAY, display.getFilter().getFormattedString()));
        }
    }

    default public void sendBody(@NotNull CommandSender sender, @NotNull ContentDisplay<T> display, Collection<String> formattedContent) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/DisplayHandler.sendBody must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/display/DisplayHandler.sendBody must not be null");
        }
        if (formattedContent == null || formattedContent.size() == 0) {
            sender.sendMessage(display.getEmptyMessage());
            return;
        }
        sender.sendMessage(formattedContent.toArray(new String[0]));
    }
}

