/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.display;

import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentFilter {
    public static final ContentFilter DEFAULT = new ContentFilter();
    private static final Pattern REGEX_SPECIAL_CHARS = Pattern.compile("[.+*?\\[^\\]$(){}=!<>|:-\\\\]");
    private String filterString;
    private Pattern filterPattern;
    private boolean exactMatch;

    private ContentFilter() {
    }

    public ContentFilter(@NotNull String filterString) {
        if (filterString == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentFilter.<init> must not be null");
        }
        this(filterString, false);
    }

    public ContentFilter(@NotNull String filterString, boolean exactMatch) {
        if (filterString == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentFilter.<init> must not be null");
        }
        this.filterString = filterString;
        this.exactMatch = exactMatch;
        this.parseFilter();
    }

    private void parseFilter() {
        if (this.filterString == null) {
            return;
        }
        if (this.filterString.startsWith("r=")) {
            this.convertToMatcher(this.filterString.substring(2));
            return;
        }
        String cleanedFilter = REGEX_SPECIAL_CHARS.matcher(this.filterString.toLowerCase()).replaceAll("\\\\$0");
        this.convertToMatcher("(?i).*" + cleanedFilter + ".*");
    }

    private void convertToMatcher(@NotNull String regex) {
        if (regex == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentFilter.convertToMatcher must not be null");
        }
        try {
            this.filterPattern = Pattern.compile(regex);
            CoreLogging.finest("Parsed regex pattern: %s", this.filterPattern.toString());
        }
        catch (PatternSyntaxException ignored) {
            CoreLogging.warning("Error parsing regex: %s", this.filterString);
        }
    }

    public boolean checkMatch(@Nullable Object text) {
        if (!this.hasFilter()) {
            return true;
        }
        if (text == null || !this.hasValidPattern()) {
            return false;
        }
        text = ChatColor.stripColor((String)String.valueOf(text));
        return this.exactMatch ? this.filterPattern.matcher((CharSequence)text).matches() : this.filterPattern.matcher((CharSequence)text).find();
    }

    public boolean hasFilter() {
        return this.filterString != null;
    }

    public boolean hasValidPattern() {
        return this.filterPattern != null;
    }

    @Nullable
    public String getString() {
        return this.filterString;
    }

    @Nullable
    public Pattern getPattern() {
        return this.filterPattern;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    @NotNull
    public String getFormattedString() {
        String string = String.format("%sFilter: '%s'", ChatColor.ITALIC, this.filterString);
        if (string == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentFilter.getFormattedString must not return null");
        }
        return string;
    }

    public String toString() {
        return "ContentFilter{filterString='" + this.filterString + '\'' + ", filterPattern=" + this.filterPattern + ", exactMatch=" + this.exactMatch + '}';
    }
}

