/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.display;

import com.onarandombox.MultiverseCore.display.ColorTool;
import com.onarandombox.MultiverseCore.display.ContentFilter;
import com.onarandombox.MultiverseCore.display.DisplayFormatException;
import com.onarandombox.MultiverseCore.display.DisplayHandler;
import com.onarandombox.MultiverseCore.display.DisplayHandlers;
import com.onarandombox.MultiverseCore.display.settings.DisplaySetting;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;

public class ContentDisplay<T> {
    public static final String LINE_BREAK = "%br%";
    private final T contents;
    private String header;
    private String emptyMessage = "No matching content to display.";
    private DisplayHandler<T> displayHandler;
    private ColorTool colorTool = ColorTool.DEFAULT;
    private ContentFilter filter = ContentFilter.DEFAULT;
    private final Map<DisplaySetting<?>, Object> settingsMap = new WeakHashMap();

    public static <T> Builder<T> forContent(T content) {
        return new Builder(content);
    }

    public static Builder<Collection<String>> forContent(Collection<String> content) {
        return new Builder<Collection<String>>(content).displayHandler(DisplayHandlers.LIST);
    }

    public static Builder<Map<String, Object>> forContent(Map<String, Object> content) {
        return new Builder<Map<String, Object>>(content).displayHandler(DisplayHandlers.INLINE_MAP);
    }

    private ContentDisplay(T contents) {
        this.contents = contents;
    }

    public void show(@NotNull CommandSender sender) {
        Collection<String> formattedContent;
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay.show must not be null");
        }
        try {
            formattedContent = this.contents == null ? null : this.displayHandler.format(sender, this);
        }
        catch (DisplayFormatException e) {
            sender.sendMessage(String.format("%sError: %s", ChatColor.RED, e.getMessage()));
            return;
        }
        this.displayHandler.sendHeader(sender, this);
        this.displayHandler.sendSubHeader(sender, this);
        this.displayHandler.sendBody(sender, this, formattedContent);
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(@NotNull String header) {
        if (header == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay.setHeader must not be null");
        }
        this.header = header;
    }

    public T getContents() {
        return this.contents;
    }

    @NotNull
    public String getEmptyMessage() {
        String string = this.emptyMessage;
        if (string == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay.getEmptyMessage must not return null");
        }
        return string;
    }

    @NotNull
    public DisplayHandler<T> getDisplayHandler() {
        DisplayHandler<T> displayHandler = this.displayHandler;
        if (displayHandler == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay.getDisplayHandler must not return null");
        }
        return displayHandler;
    }

    @NotNull
    public ColorTool getColorTool() {
        ColorTool colorTool = this.colorTool;
        if (colorTool == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay.getColorTool must not return null");
        }
        return colorTool;
    }

    @NotNull
    public ContentFilter getFilter() {
        ContentFilter contentFilter = this.filter;
        if (contentFilter == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay.getFilter must not return null");
        }
        return contentFilter;
    }

    public <S> S getSetting(@NotNull DisplaySetting<S> setting) {
        if (setting == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay.getSetting must not be null");
        }
        return (S)this.settingsMap.getOrDefault(setting, setting.defaultValue());
    }

    public <S> void setSetting(@NotNull DisplaySetting<S> setting, S value) {
        if (setting == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay.setSetting must not be null");
        }
        this.settingsMap.put(setting, value);
    }

    public static class Builder<T> {
        private final ContentDisplay<T> display;

        private Builder(T content) {
            this.display = new ContentDisplay(content);
        }

        @NotNull
        public Builder<T> header(@NotNull String header, Object ... replacements) {
            if (header == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.header must not be null");
            }
            ((ContentDisplay)this.display).header = String.format(header, replacements);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.header must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder<T> emptyMessage(@NotNull String emptyMessage, Object ... replacements) {
            if (emptyMessage == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.emptyMessage must not be null");
            }
            ((ContentDisplay)this.display).emptyMessage = String.format(emptyMessage, replacements);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.emptyMessage must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder<T> displayHandler(@NotNull DisplayHandler<T> displayHandler) {
            if (displayHandler == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.displayHandler must not be null");
            }
            ((ContentDisplay)this.display).displayHandler = displayHandler;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.displayHandler must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder<T> colorTool(@NotNull ColorTool colorTool) {
            if (colorTool == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.colorTool must not be null");
            }
            ((ContentDisplay)this.display).colorTool = colorTool;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.colorTool must not return null");
            }
            return builder;
        }

        @NotNull
        public Builder<T> filter(@NotNull ContentFilter filter) {
            if (filter == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.filter must not be null");
            }
            ((ContentDisplay)this.display).filter = filter;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.filter must not return null");
            }
            return builder;
        }

        @NotNull
        public <S> Builder<T> setting(@NotNull DisplaySetting<S> setting, S value) {
            if (setting == null) {
                throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.setting must not be null");
            }
            ((ContentDisplay)this.display).settingsMap.put(setting, value);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.setting must not return null");
            }
            return builder;
        }

        @NotNull
        public ContentDisplay<T> build() {
            Objects.requireNonNull(((ContentDisplay)this.display).displayHandler);
            ContentDisplay<T> contentDisplay = this.display;
            if (contentDisplay == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/display/ContentDisplay$Builder.build must not return null");
            }
            return contentDisplay;
        }

        public void show(CommandSender sender) {
            this.build().show(sender);
        }
    }
}

