/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.destination;

import com.onarandombox.MultiverseCore.api.MVDestination;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class PlayerDestination
implements MVDestination {
    private String player;
    private boolean isValid;
    private JavaPlugin plugin;

    @Override
    public String getIdentifier() {
        return "pl";
    }

    @Override
    public boolean isThisType(JavaPlugin plugin, String destination) {
        String[] items = destination.split(":");
        if (items.length != 2) {
            return false;
        }
        return items[0].equalsIgnoreCase("pl");
    }

    @Override
    public Location getLocation(Entity e) {
        Player p = this.plugin.getServer().getPlayerExact(this.player);
        Player plLoc = null;
        if (e instanceof Player) {
            plLoc = (Player)e;
        } else if (e.getPassenger() instanceof Player) {
            plLoc = (Player)e.getPassenger();
        }
        if (p != null && plLoc != null) {
            return p.getLocation();
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setDestination(JavaPlugin plugin, String destination) {
        String[] items = destination.split(":");
        if (items.length != 2) {
            this.isValid = false;
        }
        if (!items[0].equalsIgnoreCase("pl")) {
            this.isValid = false;
        }
        this.isValid = true;
        this.player = items[1];
        this.plugin = plugin;
    }

    @Override
    public String getType() {
        return "Player";
    }

    @Override
    public String getName() {
        return this.player;
    }

    @Override
    public String toString() {
        return "pl:" + this.player;
    }

    @Override
    public String getRequiredPermission() {
        return "";
    }

    @Override
    public Vector getVelocity() {
        return new Vector(0, 0, 0);
    }

    @Override
    public boolean useSafeTeleporter() {
        return true;
    }
}

