/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.destination;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVDestination;
import com.onarandombox.MultiverseCore.commands.TeleportCommand;
import com.onarandombox.MultiverseCore.destination.InvalidDestination;
import com.onarandombox.MultiverseCore.utils.PermissionTools;
import com.onarandombox.MultiverseCore.utils.PlayerFinder;
import com.onarandombox.commandhandler.Command;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;

public class DestinationFactory {
    private static final Pattern CANNON_PATTERN = Pattern.compile("(?i)cannon-[\\d]+(\\.[\\d]+)?");
    private MultiverseCore plugin;
    private Map<String, Class<? extends MVDestination>> destList;
    private Command teleportCommand;

    public DestinationFactory(MultiverseCore plugin) {
        this.plugin = plugin;
        this.destList = new HashMap<String, Class<? extends MVDestination>>();
        List<Command> cmds = this.plugin.getCommandHandler().getAllCommands();
        for (Command c : cmds) {
            if (!(c instanceof TeleportCommand)) continue;
            this.teleportCommand = c;
        }
    }

    @NotNull
    public MVDestination getPlayerAwareDestination(@NotNull Player teleportee, @NotNull String destinationName) {
        if (teleportee == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/destination/DestinationFactory.getPlayerAwareDestination must not be null");
        }
        if (destinationName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/destination/DestinationFactory.getPlayerAwareDestination must not be null");
        }
        if (Bukkit.getWorld((String)destinationName) != null) {
            MVDestination mVDestination = this.getDestination(destinationName);
            if (mVDestination == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/destination/DestinationFactory.getPlayerAwareDestination must not return null");
            }
            return mVDestination;
        }
        Player targetPlayer = PlayerFinder.get(destinationName, (CommandSender)teleportee);
        if (targetPlayer != null) {
            MVDestination mVDestination = this.getDestination("pl:" + targetPlayer.getName());
            if (mVDestination == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/destination/DestinationFactory.getPlayerAwareDestination must not return null");
            }
            return mVDestination;
        }
        if (CANNON_PATTERN.matcher(destinationName).matches()) {
            MVDestination mVDestination = this.getDestination(this.parseCannonDest(teleportee, destinationName));
            if (mVDestination == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/destination/DestinationFactory.getPlayerAwareDestination must not return null");
            }
            return mVDestination;
        }
        MVDestination mVDestination = this.getDestination(destinationName);
        if (mVDestination == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/destination/DestinationFactory.getPlayerAwareDestination must not return null");
        }
        return mVDestination;
    }

    @NotNull
    private String parseCannonDest(@NotNull Player teleportee, @NotNull String destinationName) {
        if (teleportee == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/destination/DestinationFactory.parseCannonDest must not be null");
        }
        if (destinationName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/destination/DestinationFactory.parseCannonDest must not be null");
        }
        String[] cannonSpeed = destinationName.split("-");
        try {
            double speed = Double.parseDouble(cannonSpeed[1]);
            destinationName = "ca:" + teleportee.getWorld().getName() + ":" + teleportee.getLocation().getX() + "," + teleportee.getLocation().getY() + "," + teleportee.getLocation().getZ() + ":" + teleportee.getLocation().getPitch() + ":" + teleportee.getLocation().getYaw() + ":" + speed;
        }
        catch (Exception e) {
            destinationName = "i:invalid";
        }
        String string = destinationName;
        if (string == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/destination/DestinationFactory.parseCannonDest must not return null");
        }
        return string;
    }

    public MVDestination getDestination(String destination) {
        String idenChar = "";
        if (destination.split(":").length > 1) {
            idenChar = destination.split(":")[0];
        }
        if (this.destList.containsKey(idenChar)) {
            Class<? extends MVDestination> myClass = this.destList.get(idenChar);
            try {
                MVDestination mydest = myClass.newInstance();
                if (!mydest.isThisType(this.plugin, destination)) {
                    return new InvalidDestination();
                }
                mydest.setDestination(this.plugin, destination);
                return mydest;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new InvalidDestination();
    }

    public boolean registerDestinationType(Class<? extends MVDestination> c, String identifier) {
        if (this.destList.containsKey(identifier)) {
            return false;
        }
        this.destList.put(identifier, c);
        if (identifier.equals("")) {
            identifier = "w";
        }
        Permission self = this.plugin.getServer().getPluginManager().getPermission("multiverse.teleport.self." + identifier);
        Permission other = this.plugin.getServer().getPluginManager().getPermission("multiverse.teleport.other." + identifier);
        PermissionTools pt = new PermissionTools(this.plugin);
        if (self == null) {
            self = new Permission("multiverse.teleport.self." + identifier, "Permission to teleport yourself for the " + identifier + " destination.", PermissionDefault.OP);
            this.plugin.getServer().getPluginManager().addPermission(self);
            pt.addToParentPerms("multiverse.teleport.self." + identifier);
        }
        if (other == null) {
            other = new Permission("multiverse.teleport.other." + identifier, "Permission to teleport others for the " + identifier + " destination.", PermissionDefault.OP);
            this.plugin.getServer().getPluginManager().addPermission(other);
            pt.addToParentPerms("multiverse.teleport.other." + identifier);
        }
        this.teleportCommand.addAdditonalPermission(self);
        this.teleportCommand.addAdditonalPermission(other);
        return true;
    }

    public Collection<String> getRegisteredIdentifiers() {
        return this.destList.keySet();
    }
}

