/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.destination;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVDestination;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class BedDestination
implements MVDestination {
    public static final String OWN_BED_STRING = "playerbed";
    private String playername = "";
    private boolean isValid;
    private Location knownBedLoc;
    private MultiverseCore plugin;

    @Override
    public String getIdentifier() {
        return "b";
    }

    @Override
    public boolean isThisType(JavaPlugin plugin, String destination) {
        boolean validPlayer;
        String[] split = destination.split(":");
        boolean validFormat = split.length >= 1 && split.length <= 2 && split[0].equals(this.getIdentifier());
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)split[1]);
        boolean bl = validPlayer = p.getName() != null && !p.getName().equals(OWN_BED_STRING);
        if (validFormat && validPlayer) {
            this.playername = p.getName();
        }
        this.isValid = destination.equals("b:playerbed") || validFormat && validPlayer;
        return this.isValid;
    }

    @Override
    public Location getLocation(Entity entity) {
        if (entity instanceof Player) {
            this.knownBedLoc = this.playername.isEmpty() ? this.plugin.getBlockSafety().getSafeBedSpawn(((Player)entity).getBedSpawnLocation()) : this.plugin.getBlockSafety().getSafeBedSpawn(Bukkit.getOfflinePlayer((String)this.playername).getBedSpawnLocation());
            if (this.knownBedLoc == null) {
                ((Player)entity).sendMessage("The bed was " + ChatColor.RED + "invalid or blocked" + ChatColor.RESET + ". Sorry.");
            }
            return this.knownBedLoc;
        }
        return null;
    }

    @Override
    public Vector getVelocity() {
        return new Vector();
    }

    @Override
    public void setDestination(JavaPlugin plugin, String destination) {
        this.plugin = (MultiverseCore)plugin;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getType() {
        return "Bed";
    }

    @Override
    public String getName() {
        return "Bed";
    }

    @Override
    public String getRequiredPermission() {
        if (this.knownBedLoc != null) {
            return "multiverse.access." + this.knownBedLoc.getWorld().getName();
        }
        return "";
    }

    @Override
    public boolean useSafeTeleporter() {
        return false;
    }

    @Override
    public String toString() {
        return "b:" + (this.playername.isEmpty() ? OWN_BED_STRING : this.playername);
    }
}

