/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.configuration;

import com.onarandombox.MultiverseCore.utils.MaterialConverter;
import com.onarandombox.serializationconfig.SerializationConfig.Property;
import com.onarandombox.serializationconfig.SerializationConfig.SerializationConfig;
import com.onarandombox.serializationconfig.SerializationConfig.Serializor;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.Nullable;

@SerializableAs(value="MVEntryFee")
public class EntryFee
extends SerializationConfig {
    @Property
    private double amount;
    @Property(serializor=EntryFeeCurrencySerializor.class)
    @Nullable
    private Material currency;
    private final Material DISABLED_MATERIAL = Material.AIR;

    public EntryFee() {
    }

    public EntryFee(Map<String, Object> values) {
        super(values);
    }

    @Override
    protected void setDefaults() {
        this.amount = 0.0;
        this.currency = null;
    }

    public double getAmount() {
        return this.amount;
    }

    @Nullable
    public Material getCurrency() {
        if (this.currency == null || this.currency.equals((Object)this.DISABLED_MATERIAL)) {
            return null;
        }
        return this.currency;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setCurrency(@Nullable Material currency) {
        this.currency = currency;
    }

    public static final class EntryFeeCurrencySerializor
    implements Serializor<Material, Object> {
        @Override
        public String serialize(Material material) {
            return material.toString();
        }

        @Override
        public Material deserialize(Object o, Class<Material> aClass) {
            return MaterialConverter.convertTypeString(o.toString());
        }
    }
}

