/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commandtools.queue;

import org.bukkit.command.CommandSender;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class QueuedCommand {
    private static final String DEFAULT_PROMPT_MESSAGE = "The command you are trying to run is deemed dangerous.";
    private static final int DEFAULT_VALID_TIME = 10;
    private final CommandSender sender;
    private final Runnable action;
    private final String prompt;
    private final int validDuration;
    private BukkitTask expireTask;

    public QueuedCommand(CommandSender sender, Runnable action) {
        this(sender, action, DEFAULT_PROMPT_MESSAGE, 10);
    }

    public QueuedCommand(CommandSender sender, Runnable action, String prompt) {
        this(sender, action, prompt, 10);
    }

    public QueuedCommand(CommandSender sender, Runnable action, int validDuration) {
        this(sender, action, DEFAULT_PROMPT_MESSAGE, validDuration);
    }

    public QueuedCommand(CommandSender sender, Runnable action, String prompt, int validDuration) {
        this.sender = sender;
        this.action = action;
        this.prompt = prompt;
        this.validDuration = validDuration;
    }

    @NotNull
    CommandSender getSender() {
        CommandSender commandSender = this.sender;
        if (commandSender == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/QueuedCommand.getSender must not return null");
        }
        return commandSender;
    }

    @NotNull
    String getPrompt() {
        String string = this.prompt;
        if (string == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/QueuedCommand.getPrompt must not return null");
        }
        return string;
    }

    int getValidDuration() {
        return this.validDuration;
    }

    @NotNull
    Runnable getAction() {
        Runnable runnable = this.action;
        if (runnable == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/QueuedCommand.getAction must not return null");
        }
        return runnable;
    }

    @NotNull
    BukkitTask getExpireTask() {
        BukkitTask bukkitTask = this.expireTask;
        if (bukkitTask == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/QueuedCommand.getExpireTask must not return null");
        }
        return bukkitTask;
    }

    void setExpireTask(@NotNull BukkitTask expireTask) {
        if (expireTask == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/QueuedCommand.setExpireTask must not be null");
        }
        if (this.expireTask != null) {
            throw new IllegalStateException("This queue command already has an expire task. You can't register twice!");
        }
        this.expireTask = expireTask;
    }
}

