/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commandtools.queue;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commandtools.queue.DummyCommandBlockSender;
import com.onarandombox.MultiverseCore.commandtools.queue.QueuedCommand;
import com.onarandombox.MultiverseCore.utils.CoreLogging;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.data.type.CommandBlock;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class CommandQueueManager {
    private static final long TICKS_PER_SECOND = 20L;
    private static final DummyCommandBlockSender COMMAND_BLOCK = new DummyCommandBlockSender();
    private final MultiverseCore plugin;
    private final Map<CommandSender, QueuedCommand> queuedCommandMap;

    public CommandQueueManager(@NotNull MultiverseCore plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.<init> must not be null");
        }
        this.plugin = plugin;
        this.queuedCommandMap = new WeakHashMap<CommandSender, QueuedCommand>();
    }

    public void addToQueue(QueuedCommand queuedCommand) {
        CommandSender targetSender = this.parseSender(queuedCommand.getSender());
        this.removeFromQueue(targetSender);
        CoreLogging.finer("Add new command to queue for sender %s.", targetSender);
        this.queuedCommandMap.put(targetSender, queuedCommand);
        queuedCommand.setExpireTask(this.runExpireLater(queuedCommand));
        queuedCommand.getSender().sendMessage(queuedCommand.getPrompt());
        queuedCommand.getSender().sendMessage(String.format("Run %s/mv confirm %sto continue. This will expire in %s seconds.", ChatColor.GREEN, ChatColor.WHITE, queuedCommand.getValidDuration()));
    }

    @NotNull
    private BukkitTask runExpireLater(@NotNull QueuedCommand queuedCommand) {
        if (queuedCommand == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.runExpireLater must not be null");
        }
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this.expireRunnable(queuedCommand), (long)queuedCommand.getValidDuration() * 20L);
        if (bukkitTask == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.runExpireLater must not return null");
        }
        return bukkitTask;
    }

    @NotNull
    private Runnable expireRunnable(@NotNull QueuedCommand queuedCommand) {
        if (queuedCommand == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.expireRunnable must not be null");
        }
        Runnable runnable = () -> {
            CommandSender targetSender = this.parseSender(queuedCommand.getSender());
            QueuedCommand matchingQueuedCommand = this.queuedCommandMap.get(targetSender);
            if (!queuedCommand.equals(matchingQueuedCommand) || queuedCommand.getExpireTask().isCancelled()) {
                CoreLogging.finer("This is an old queue command already.", new Object[0]);
                return;
            }
            queuedCommand.getSender().sendMessage("Your queued command has expired.");
            this.queuedCommandMap.remove(queuedCommand.getSender());
        };
        if (runnable == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.expireRunnable must not return null");
        }
        return runnable;
    }

    public boolean runQueuedCommand(@NotNull CommandSender sender) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.runQueuedCommand must not be null");
        }
        CommandSender targetSender = this.parseSender(sender);
        QueuedCommand queuedCommand = this.queuedCommandMap.get(targetSender);
        if (queuedCommand == null) {
            sender.sendMessage(ChatColor.RED + "You do not have any commands in queue.");
            return false;
        }
        CoreLogging.finer("Running queued command...", new Object[0]);
        queuedCommand.getAction().run();
        return this.removeFromQueue(targetSender);
    }

    public boolean removeFromQueue(@NotNull CommandSender sender) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.removeFromQueue must not be null");
        }
        CommandSender targetSender = this.parseSender(sender);
        QueuedCommand previousCommand = this.queuedCommandMap.remove(targetSender);
        if (previousCommand == null) {
            CoreLogging.finer("No queue command to remove for sender %s.", targetSender.getName());
            return false;
        }
        previousCommand.getExpireTask().cancel();
        CoreLogging.finer("Removed queue command for sender %s.", targetSender.getName());
        return true;
    }

    @NotNull
    private CommandSender parseSender(@NotNull CommandSender sender) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.parseSender must not be null");
        }
        CoreLogging.fine(sender.getClass().getName(), new Object[0]);
        if (this.isCommandBlock(sender)) {
            CoreLogging.finer("Is command block.", new Object[0]);
            DummyCommandBlockSender dummyCommandBlockSender = COMMAND_BLOCK;
            if (dummyCommandBlockSender == null) {
                throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.parseSender must not return null");
            }
            return dummyCommandBlockSender;
        }
        CommandSender commandSender = sender;
        if (commandSender == null) {
            throw new IllegalStateException("NotNull method com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.parseSender must not return null");
        }
        return commandSender;
    }

    private boolean isCommandBlock(@NotNull CommandSender sender) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commandtools/queue/CommandQueueManager.isCommandBlock must not be null");
        }
        return sender instanceof BlockCommandSender && ((BlockCommandSender)sender).getBlock().getBlockData() instanceof CommandBlock;
    }
}

