/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.BlockSafety;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class SetSpawnCommand
extends MultiverseCommand {
    public SetSpawnCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Set World Spawn");
        this.setCommandUsage("/mv setspawn");
        this.setArgRange(0, 6);
        this.addKey("mvsetspawn");
        this.addKey("mvsets");
        this.addKey("mvss");
        this.addKey("mv set spawn");
        this.addKey("mv setspawn");
        this.addKey("mvset spawn");
        this.addCommandExample("/mv set spawn");
        this.setPermission("multiverse.core.spawn.set", "Sets the spawn for the current world.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        if (args.isEmpty()) {
            this.setWorldSpawn(sender);
        } else if (args.size() == 4) {
            this.setWorldSpawn(sender, args.get(0), args.get(1), args.get(2), args.get(3));
        } else if (args.size() == 6) {
            this.setWorldSpawn(sender, args.get(0), args.get(1), args.get(2), args.get(3), args.get(4), args.get(5));
        } else {
            sender.sendMessage("Use no arguments for your current location, or world/x/y/z, or world/x/y/z/yaw/pitch!");
        }
    }

    protected void setWorldSpawn(CommandSender sender) {
        if (sender instanceof Player) {
            Player p = (Player)sender;
            Location l = p.getLocation();
            World w = p.getWorld();
            this.setWorldSpawn(sender, w, l);
        } else {
            sender.sendMessage("You need to give coordinates to use this command from the console!");
        }
    }

    protected void setWorldSpawn(CommandSender sender, String world, String x, String y, String z) {
        this.setWorldSpawn(sender, world, x, y, z, "0", "0");
    }

    protected void setWorldSpawn(CommandSender sender, String world, String x, String y, String z, String yaw, String pitch) {
        float fyaw;
        float fpitch;
        double dz;
        double dy;
        double dx;
        World bukkitWorld = Bukkit.getWorld((String)world);
        if (bukkitWorld == null) {
            sender.sendMessage("World " + world + " is unknown!");
            return;
        }
        try {
            dx = Double.parseDouble(x);
            dy = Double.parseDouble(y);
            dz = Double.parseDouble(z);
            fpitch = Float.parseFloat(pitch);
            fyaw = Float.parseFloat(yaw);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage("All coordinates must be numeric");
            return;
        }
        Location l = new Location(bukkitWorld, dx, dy, dz, fyaw, fpitch);
        this.setWorldSpawn(sender, bukkitWorld, l);
    }

    private void setWorldSpawn(CommandSender sender, World w, Location l) {
        MultiverseWorld foundWorld = this.plugin.getMVWorldManager().getMVWorld(w.getName());
        if (foundWorld != null) {
            foundWorld.setSpawnLocation(l);
            BlockSafety bs = this.plugin.getBlockSafety();
            if (!bs.playerCanSpawnHereSafely(l) && foundWorld.getAdjustSpawn()) {
                sender.sendMessage("It looks like that location would normally be unsafe. But I trust you.");
                sender.sendMessage("I'm turning off the Safe-T-Teleporter for spawns to this world.");
                sender.sendMessage("If you want this turned back on just do:");
                sender.sendMessage(ChatColor.AQUA + "/mvm set adjustspawn true " + foundWorld.getAlias());
                foundWorld.setAdjustSpawn(false);
            }
            sender.sendMessage("Spawn was set to: " + this.plugin.getLocationManipulation().strCoords(l));
            if (!this.plugin.saveWorldConfig()) {
                sender.sendMessage(ChatColor.RED + "There was an issue saving worlds.yml!  Your changes will only be temporary!");
            }
        } else {
            w.setSpawnLocation(l.getBlockX(), l.getBlockY(), l.getBlockZ());
            sender.sendMessage("Multiverse does not know about this world, only X,Y and Z set. Please import it to set the spawn fully (Pitch/Yaws).");
        }
    }
}

