/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import com.onarandombox.MultiverseCore.commandtools.queue.QueuedCommand;
import com.onarandombox.commandhandler.CommandHandler;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;

public class RegenCommand
extends MultiverseCommand {
    public RegenCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Regenerates a World");
        this.setCommandUsage("/mv regen" + ChatColor.GREEN + " {WORLD}" + ChatColor.GOLD + " [-s [SEED]] [--keep-gamerules]");
        this.setArgRange(1, 4);
        this.addKey("mvregen");
        this.addKey("mv regen");
        this.addCommandExample("You can use the -s with no args to get a new seed:");
        this.addCommandExample("/mv regen " + ChatColor.GREEN + "MyWorld" + ChatColor.GOLD + " -s");
        this.addCommandExample("or specifiy a seed to get that one:");
        this.addCommandExample("/mv regen " + ChatColor.GREEN + "MyWorld" + ChatColor.GOLD + " -s" + ChatColor.AQUA + " gargamel");
        this.setPermission("multiverse.core.regen", "Regenerates a world on your server. The previous state will be lost " + ChatColor.RED + "PERMANENTLY.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        String worldName = args.get(0);
        boolean useseed = args.size() != 1;
        boolean randomseed = args.size() == 2 && args.get(1).equalsIgnoreCase("-s");
        String seed = args.size() == 3 ? args.get(2) : "";
        boolean keepGamerules = CommandHandler.hasFlag("--keep-gamerules", args);
        this.plugin.getCommandQueueManager().addToQueue(new QueuedCommand(sender, this.doWorldRegen(sender, worldName, useseed, randomseed, seed, keepGamerules), String.format("Are you sure you want to regen '%s'? You cannot undo this action.", worldName)));
    }

    private Runnable doWorldRegen(@NotNull CommandSender sender, @NotNull String worldName, boolean useSeed, boolean randomSeed, @NotNull String seed, boolean keepGamerules) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commands/RegenCommand.doWorldRegen must not be null");
        }
        if (worldName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 of com/onarandombox/MultiverseCore/commands/RegenCommand.doWorldRegen must not be null");
        }
        if (seed == null) {
            throw new IllegalArgumentException("NotNull annotated argument 4 of com/onarandombox/MultiverseCore/commands/RegenCommand.doWorldRegen must not be null");
        }
        return () -> {
            if (this.plugin.getMVWorldManager().regenWorld(worldName, useSeed, randomSeed, seed, keepGamerules)) {
                sender.sendMessage(ChatColor.GREEN + "World Regenerated!");
                return;
            }
            sender.sendMessage(ChatColor.RED + "World could NOT be regenerated!");
        };
    }
}

