/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.commandhandler.Command;
import java.util.List;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class PaginatedCommand<T>
extends Command {
    private final Pattern REGEX_SPECIAL_CHARS = Pattern.compile("[.+*?\\[^\\]$(){}=!<>|:-\\\\]");
    private static final int DEFAULT_ITEMS_PER_PAGE = 9;
    protected int itemsPerPage = 9;

    public PaginatedCommand(JavaPlugin plugin) {
        super((Plugin)plugin);
    }

    protected void setItemsPerPage(int items) {
        this.itemsPerPage = items;
    }

    protected abstract List<T> getFilteredItems(List<T> var1, String var2);

    protected String cleanFilter(String filter) {
        return this.REGEX_SPECIAL_CHARS.matcher(filter).replaceAll("\\\\$0");
    }

    protected String stitchThisString(List<String> list) {
        StringBuilder builder = new StringBuilder();
        for (String s : list) {
            builder.append(s);
            builder.append(' ');
        }
        return builder.toString();
    }

    protected void showPage(int page, CommandSender sender, List<T> cmds) {
        page = page <= 0 ? 1 : page;
        int start = (page - 1) * this.itemsPerPage;
        int end = start + this.itemsPerPage;
        for (int i = start; i < end; ++i) {
            if (i < cmds.size()) {
                sender.sendMessage(this.getItemText(cmds.get(i)));
                continue;
            }
            if (!(sender instanceof Player)) continue;
            sender.sendMessage(" ");
        }
    }

    protected abstract String getItemText(T var1);

    protected FilterObject getPageAndFilter(List<String> args) {
        int page = 1;
        String filter = "";
        if (args.size() == 0) {
            filter = "";
            page = 1;
        } else if (args.size() == 1) {
            try {
                page = Integer.parseInt(args.get(0));
            }
            catch (NumberFormatException ex) {
                filter = args.get(0);
                page = 1;
            }
        } else if (args.size() == 2) {
            filter = args.get(0);
            try {
                page = Integer.parseInt(args.get(1));
            }
            catch (NumberFormatException ex) {
                page = 1;
            }
        }
        return new FilterObject(page, filter);
    }

    protected class FilterObject {
        private Integer page;
        private String filter;

        public FilterObject(Integer page, String filter) {
            this.page = page;
            this.filter = filter;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public String getFilter() {
            return this.filter;
        }
    }
}

