/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MultiverseWorld;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import com.onarandombox.MultiverseCore.display.ColorAlternator;
import com.onarandombox.MultiverseCore.display.ContentDisplay;
import com.onarandombox.MultiverseCore.display.ContentFilter;
import com.onarandombox.MultiverseCore.display.DisplayHandlers;
import com.onarandombox.MultiverseCore.display.settings.PagedDisplaySettings;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.jetbrains.annotations.NotNull;

public class ListCommand
extends MultiverseCommand {
    public ListCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("World Listing");
        this.setCommandUsage("/mv list [filter] [page]");
        this.setArgRange(0, 2);
        this.addKey("mvlist");
        this.addKey("mvl");
        this.addKey("mv list");
        this.setPermission("multiverse.core.list.worlds", "Displays a listing of all worlds that you can enter.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        ContentFilter filter = ContentFilter.DEFAULT;
        int page = 1;
        if (args.size() == 1) {
            try {
                page = Integer.parseInt(args.get(0));
            }
            catch (NumberFormatException ignore) {
                filter = new ContentFilter(args.get(0));
            }
        }
        if (args.size() == 2) {
            filter = new ContentFilter(args.get(0));
            try {
                page = Integer.parseInt(args.get(1));
            }
            catch (NumberFormatException ignore) {
                sender.sendMessage(ChatColor.RED + args.get(1) + " is not valid number!");
            }
        }
        ContentDisplay.forContent(this.getListContents(sender)).header("%s====[ Multiverse World List ]====", ChatColor.GOLD).displayHandler(DisplayHandlers.PAGE_LIST).colorTool(ColorAlternator.with(ChatColor.AQUA, ChatColor.GOLD)).filter(filter).setting(PagedDisplaySettings.SHOW_PAGE, page).show(sender);
    }

    private Collection<String> getListContents(@NotNull CommandSender sender) {
        if (sender == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 of com/onarandombox/MultiverseCore/commands/ListCommand.getListContents must not be null");
        }
        Player player = sender instanceof Player ? (Player)sender : null;
        List<String> worldList = this.plugin.getMVWorldManager().getMVWorlds().stream().filter(world -> player == null || this.plugin.getMVPerms().canEnterWorld(player, (MultiverseWorld)world)).filter(world -> this.canSeeWorld(player, (MultiverseWorld)world)).map(world -> this.hiddenText((MultiverseWorld)world) + world.getColoredWorldString() + " - " + this.parseColouredEnvironment(world.getEnvironment())).collect(Collectors.toList());
        this.plugin.getMVWorldManager().getUnloadedWorlds().stream().filter(world -> this.plugin.getMVPerms().hasPermission(sender, "multiverse.access." + world, true)).map(world -> ChatColor.GRAY + world + " - UNLOADED").forEach(worldList::add);
        return worldList;
    }

    private boolean canSeeWorld(Player player, MultiverseWorld world) {
        return !world.isHidden() || player == null || this.plugin.getMVPerms().hasPermission((CommandSender)player, "multiverse.core.modify", true);
    }

    private String hiddenText(MultiverseWorld world) {
        return world.isHidden() ? String.format("%s[H] ", ChatColor.GRAY) : "";
    }

    private String parseColouredEnvironment(World.Environment env) {
        ChatColor color = ChatColor.GOLD;
        switch (env) {
            case NETHER: {
                color = ChatColor.RED;
                break;
            }
            case NORMAL: {
                color = ChatColor.GREEN;
                break;
            }
            case THE_END: {
                color = ChatColor.AQUA;
            }
        }
        return color + env.toString();
    }
}

