/*
 * Decompiled with CFR 0.152.
 */
package com.onarandombox.MultiverseCore.commands;

import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.commands.MultiverseCommand;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;

public class GameruleCommand
extends MultiverseCommand {
    public GameruleCommand(MultiverseCore plugin) {
        super(plugin);
        this.setName("Set a Minecraft Game Rule for a World.");
        this.setCommandUsage("/mv gamerule " + ChatColor.GREEN + "{RULE} {VALUE}" + ChatColor.GOLD + " [WORLD]");
        this.setArgRange(2, 3);
        this.addKey("mv gamerule");
        this.addKey("mv rule");
        this.addKey("mvgamerule");
        this.addKey("mvrule");
        this.addCommandExample("/mv gamerule " + ChatColor.GREEN + "doMobLoot false");
        this.addCommandExample("/mvrule " + ChatColor.GREEN + "keepInventory true " + ChatColor.RED + "world_nether");
        this.setPermission("multiverse.core.gamerule.set", "Allows a player to set a gamerule.", PermissionDefault.OP);
    }

    @Override
    public void runCommand(CommandSender sender, List<String> args) {
        World world;
        Player p = sender instanceof Player ? (Player)sender : null;
        if (args.size() == 2 && p == null) {
            sender.sendMessage("From the command line, WORLD is required.");
            sender.sendMessage(this.getCommandDesc());
            sender.sendMessage(this.getCommandUsage());
            sender.sendMessage("Nothing changed.");
            return;
        }
        GameRule gameRule = GameRule.getByName((String)args.get(0));
        String value = args.get(1);
        if (args.size() == 2) {
            world = p.getWorld();
        } else {
            world = Bukkit.getWorld((String)args.get(2));
            if (world == null) {
                sender.sendMessage(ChatColor.RED + "Failure!" + ChatColor.WHITE + " World " + ChatColor.AQUA + args.get(2) + ChatColor.WHITE + " does not exist.");
                return;
            }
        }
        if (gameRule == null) {
            sender.sendMessage(ChatColor.RED + "Failure! " + ChatColor.AQUA + args.get(0) + ChatColor.WHITE + " is not a valid gamerule.");
        } else {
            block17: {
                if (gameRule.getType() == Boolean.class) {
                    boolean booleanValue;
                    if (value.equalsIgnoreCase("true")) {
                        booleanValue = true;
                    } else if (value.equalsIgnoreCase("false")) {
                        booleanValue = false;
                    } else {
                        sender.sendMessage(this.getErrorMessage(gameRule.getName(), value) + "it can only be set to true or false.");
                        return;
                    }
                    if (!world.setGameRule(gameRule, (Object)booleanValue)) {
                        sender.sendMessage(this.getErrorMessage(gameRule.getName(), value) + "something went wrong.");
                        return;
                    }
                } else {
                    if (gameRule.getType() == Integer.class) {
                        try {
                            if (!world.setGameRule(gameRule, (Object)Integer.parseInt(value))) {
                                throw new NumberFormatException();
                            }
                            break block17;
                        }
                        catch (NumberFormatException e) {
                            sender.sendMessage(this.getErrorMessage(gameRule.getName(), value) + "it can only be set to a positive integer.");
                            return;
                        }
                    }
                    sender.sendMessage(ChatColor.RED + "Failure!" + ChatColor.WHITE + " Gamerule " + ChatColor.AQUA + gameRule.getName() + ChatColor.WHITE + " isn't supported yet, please let us know about it.");
                    return;
                }
            }
            sender.sendMessage(ChatColor.GREEN + "Success!" + ChatColor.WHITE + " Gamerule " + ChatColor.AQUA + gameRule.getName() + ChatColor.WHITE + " was set to " + ChatColor.GREEN + value + ChatColor.WHITE + ".");
        }
    }

    private String getErrorMessage(String gameRule, String value) {
        return ChatColor.RED + "Failure!" + ChatColor.WHITE + " Gamerule " + ChatColor.AQUA + gameRule + ChatColor.WHITE + " could not be set to " + ChatColor.RED + value + ChatColor.WHITE + ", ";
    }
}

