/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl.v1_17_R1_2;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.mojang.serialization.Lifecycle;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.Refraction;
import com.sk89q.worldedit.bukkit.adapter.impl.v1_17_R1_2.PaperweightDataConverters;
import com.sk89q.worldedit.bukkit.adapter.impl.v1_17_R1_2.PaperweightFakePlayer;
import com.sk89q.worldedit.bukkit.adapter.impl.v1_17_R1_2.PaperweightWorldNativeAccess;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.extension.platform.Watchdog;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.internal.wna.WorldNativeAccess;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.SideEffect;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.io.file.SafeFiles;
import com.sk89q.worldedit.world.DataFixer;
import com.sk89q.worldedit.world.RegenOptions;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.INamable;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.Clearable;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.chunk.BiomeStorage;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.Nullable;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public final class PaperweightAdapter
implements BukkitImplAdapter {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field serverWorldsField;
    private final Method getChunkFutureMethod;
    private final Field chunkProviderExecutorField;
    private final Watchdog watchdog;
    private final LoadingCache<WorldServer, PaperweightFakePlayer> fakePlayers = CacheBuilder.newBuilder().weakKeys().softValues().build(CacheLoader.from(PaperweightFakePlayer::new));
    private static final Set<SideEffect> SUPPORTED_SIDE_EFFECTS = Sets.immutableEnumSet((Enum)SideEffect.NEIGHBORS, (Enum[])new SideEffect[]{SideEffect.LIGHTING, SideEffect.VALIDATION, SideEffect.ENTITY_AI, SideEffect.EVENTS, SideEffect.UPDATE});

    public PaperweightAdapter() throws NoSuchFieldException, NoSuchMethodException {
        Watchdog watchdog;
        CraftServer.class.cast(Bukkit.getServer());
        int dataVersion = CraftMagicNumbers.INSTANCE.getDataVersion();
        if (dataVersion != 2730) {
            throw new UnsupportedClassVersionError("Not 1.17.1!");
        }
        this.serverWorldsField = CraftServer.class.getDeclaredField("worlds");
        this.serverWorldsField.setAccessible(true);
        this.getChunkFutureMethod = ChunkProviderServer.class.getDeclaredMethod("getChunkFutureMainThread", Integer.TYPE, Integer.TYPE, ChunkStatus.class, Boolean.TYPE);
        this.getChunkFutureMethod.setAccessible(true);
        this.chunkProviderExecutorField = ChunkProviderServer.class.getDeclaredField(Refraction.pickName("mainThreadProcessor", "h"));
        this.chunkProviderExecutorField.setAccessible(true);
        new PaperweightDataConverters(CraftMagicNumbers.INSTANCE.getDataVersion(), this).build(ForkJoinPool.commonPool());
        try {
            Class.forName("org.spigotmc.WatchdogThread");
            watchdog = new SpigotWatchdog();
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            try {
                watchdog = new MojangWatchdog(((CraftServer)Bukkit.getServer()).getServer());
            }
            catch (NoSuchFieldException ex) {
                watchdog = null;
            }
        }
        this.watchdog = watchdog;
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            SpigotConfig.config.set("world-settings.worldeditregentempworld.verbose", (Object)false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public DataFixer getDataFixer() {
        return PaperweightDataConverters.INSTANCE;
    }

    static void readTagIntoTileEntity(NBTTagCompound tag, TileEntity tileEntity) {
        tileEntity.load(tag);
        tileEntity.update();
    }

    private static void readTileEntityIntoTag(TileEntity tileEntity, NBTTagCompound tag) {
        tileEntity.save(tag);
    }

    private static String getEntityId(net.minecraft.world.entity.Entity entity) {
        return EntityTypes.getName((EntityTypes)entity.getEntityType()).toString();
    }

    @javax.annotation.Nullable
    private static net.minecraft.world.entity.Entity createEntityFromId(String id, net.minecraft.world.level.World world) {
        return EntityTypes.a((String)id).map(t -> t.a(world)).orElse(null);
    }

    private static void readTagIntoEntity(NBTTagCompound tag, net.minecraft.world.entity.Entity entity) {
        entity.load(tag);
    }

    private static void readEntityIntoTag(net.minecraft.world.entity.Entity entity, NBTTagCompound tag) {
        entity.e(tag);
    }

    private static Block getBlockFromType(BlockType blockType) {
        return (Block)IRegistry.W.get(MinecraftKey.a((String)blockType.getId()));
    }

    private static Item getItemFromType(ItemType itemType) {
        return (Item)IRegistry.Z.get(MinecraftKey.a((String)itemType.getId()));
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockData data) {
        IBlockData state = ((CraftBlockData)data).getState();
        int combinedId = Block.getCombinedId((IBlockData)state);
        return combinedId == 0 && state.getBlock() != Blocks.a ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public OptionalInt getInternalBlockStateId(BlockState state) {
        Block mcBlock = PaperweightAdapter.getBlockFromType(state.getBlockType());
        IBlockData newState = mcBlock.getBlockData();
        Map<Property<?>, Object> states = state.getStates();
        newState = this.applyProperties((BlockStateList<Block, IBlockData>)mcBlock.getStates(), newState, states);
        int combinedId = Block.getCombinedId((IBlockData)newState);
        return combinedId == 0 && state.getBlockType() != BlockTypes.AIR ? OptionalInt.empty() : OptionalInt.of(combinedId);
    }

    @Override
    public BlockState getBlock(Location location) {
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WorldServer handle = craftWorld.getHandle();
        Chunk chunk = handle.getChunkAt(x >> 4, z >> 4);
        BlockPosition blockPos = new BlockPosition(x, y, z);
        IBlockData blockData = chunk.getType(blockPos);
        int internalId = Block.getCombinedId((IBlockData)blockData);
        BlockState state = BlockStateIdAccess.getBlockStateById(internalId);
        if (state == null) {
            org.bukkit.block.Block bukkitBlock = location.getBlock();
            state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        }
        return state;
    }

    @Override
    public BaseBlock getFullBlock(Location location) {
        BlockPosition blockPos;
        BlockState state = this.getBlock(location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        WorldServer handle = craftWorld.getHandle();
        Chunk chunk = handle.getChunkAt(x >> 4, z >> 4);
        TileEntity te = chunk.getTileEntity(blockPos = new BlockPosition(x, y, z));
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            PaperweightAdapter.readTileEntityIntoTag(te, tag);
            return state.toBaseBlock((CompoundTag)this.toNative((NBTBase)tag));
        }
        return state.toBaseBlock();
    }

    @Override
    public WorldNativeAccess<?, ?, ?> createWorldNativeAccess(World world) {
        return new PaperweightWorldNativeAccess(this, new WeakReference<WorldServer>(((CraftWorld)world).getHandle()));
    }

    private static EnumDirection adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return EnumDirection.c;
            }
            case SOUTH: {
                return EnumDirection.d;
            }
            case WEST: {
                return EnumDirection.e;
            }
            case EAST: {
                return EnumDirection.f;
            }
            case DOWN: {
                return EnumDirection.a;
            }
        }
        return EnumDirection.b;
    }

    private IBlockData applyProperties(BlockStateList<Block, IBlockData> stateContainer, IBlockData newState, Map<Property<?>, Object> states) {
        for (Map.Entry<Property<?>, Object> state : states.entrySet()) {
            IBlockState property = stateContainer.a(state.getKey().getName());
            Comparable value = (Comparable)state.getValue();
            if (property instanceof BlockStateDirection) {
                Direction dir = (Direction)((Object)value);
                value = PaperweightAdapter.adapt(dir);
            } else if (property instanceof BlockStateEnum) {
                String enumName = (String)((Object)value);
                value = (Comparable)((BlockStateEnum)property).b(enumName).orElseThrow(() -> new IllegalStateException("Enum property " + property.getName() + " does not contain " + enumName));
            }
            newState = (IBlockData)newState.set(property, value);
        }
        return newState;
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.world.entity.Entity mcEntity = craftEntity.getHandle();
        if (mcEntity.isPassenger()) {
            return null;
        }
        String id = PaperweightAdapter.getEntityId(mcEntity);
        NBTTagCompound tag = new NBTTagCompound();
        PaperweightAdapter.readEntityIntoTag(mcEntity, tag);
        return new BaseEntity(com.sk89q.worldedit.world.entity.EntityTypes.get(id), (CompoundTag)this.toNative((NBTBase)tag));
    }

    @Override
    @javax.annotation.Nullable
    public Entity createEntity(Location location, BaseEntity state) {
        NBTTagCompound tag;
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        String entityId = state.getType().getId();
        CompoundTag nativeTag = state.getNbtData();
        if (nativeTag != null) {
            tag = (NBTTagCompound)this.fromNative(nativeTag);
            this.removeUnwantedEntityTagsRecursively(tag);
        } else {
            tag = new NBTTagCompound();
        }
        tag.setString("id", entityId);
        net.minecraft.world.entity.Entity createdEntity = EntityTypes.a((NBTTagCompound)tag, (net.minecraft.world.level.World)craftWorld.getHandle(), loadedEntity -> {
            loadedEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            return loadedEntity;
        });
        if (createdEntity != null) {
            worldServer.addAllEntities(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        return null;
    }

    private void removeUnwantedEntityTagsRecursively(NBTTagCompound tag) {
        for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
            tag.remove(name);
        }
        if (tag.hasKeyOfType("Passengers", 9)) {
            NBTTagList nbttaglist = tag.getList("Passengers", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                this.removeUnwantedEntityTagsRecursively(nbttaglist.getCompound(i));
            }
        }
    }

    @Override
    public Component getRichBlockName(BlockType blockType) {
        return TranslatableComponent.of(PaperweightAdapter.getBlockFromType(blockType).h());
    }

    @Override
    public Component getRichItemName(ItemType itemType) {
        return TranslatableComponent.of(PaperweightAdapter.getItemFromType(itemType).getName());
    }

    @Override
    public Component getRichItemName(BaseItemStack itemStack) {
        return TranslatableComponent.of(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)BukkitAdapter.adapt(itemStack)).n());
    }

    @Override
    public Map<String, ? extends Property<?>> getProperties(BlockType blockType) {
        TreeMap properties = Maps.newTreeMap(String::compareTo);
        Block block = PaperweightAdapter.getBlockFromType(blockType);
        BlockStateList blockStateList = block.getStates();
        for (IBlockState state : blockStateList.d()) {
            AbstractProperty property;
            if (state instanceof BlockStateBoolean) {
                property = new BooleanProperty(state.getName(), (List<Boolean>)ImmutableList.copyOf((Collection)state.getValues()));
            } else if (state instanceof BlockStateDirection) {
                property = new DirectionalProperty(state.getName(), state.getValues().stream().map(e -> Direction.valueOf(((INamable)e).getName().toUpperCase(Locale.ROOT))).collect(Collectors.toList()));
            } else if (state instanceof BlockStateEnum) {
                property = new EnumProperty(state.getName(), state.getValues().stream().map(e -> ((INamable)e).getName()).collect(Collectors.toList()));
            } else if (state instanceof BlockStateInteger) {
                property = new IntegerProperty(state.getName(), (List<Integer>)ImmutableList.copyOf((Collection)state.getValues()));
            } else {
                throw new IllegalArgumentException("WorldEdit needs an update to support " + state.getClass().getSimpleName());
            }
            properties.put(property.getName(), property);
        }
        return properties;
    }

    @Override
    public void sendFakeNBT(Player player, BlockVector3 pos, CompoundTag nbtData) {
        ((CraftPlayer)player).getHandle().networkManager.sendPacket((Packet)new PacketPlayOutTileEntityData(new BlockPosition(pos.getBlockX(), pos.getBlockY(), pos.getBlockZ()), 7, (NBTTagCompound)this.fromNative(nbtData)));
    }

    @Override
    public void sendFakeOP(Player player) {
        ((CraftPlayer)player).getHandle().networkManager.sendPacket((Packet)new PacketPlayOutEntityStatus((net.minecraft.world.entity.Entity)((CraftPlayer)player).getHandle(), 28));
    }

    @Override
    public org.bukkit.inventory.ItemStack adapt(BaseItemStack item) {
        ItemStack stack = new ItemStack((IMaterial)IRegistry.Z.get(MinecraftKey.a((String)item.getType().getId())), item.getAmount());
        stack.setTag((NBTTagCompound)this.fromNative(item.getNbtData()));
        return CraftItemStack.asCraftMirror((ItemStack)stack);
    }

    @Override
    public BaseItemStack adapt(org.bukkit.inventory.ItemStack itemStack) {
        ItemStack nmsStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        BaseItemStack weStack = new BaseItemStack(BukkitAdapter.asItemType(itemStack.getType()), itemStack.getAmount());
        weStack.setNbtData((CompoundTag)this.toNative((NBTBase)nmsStack.getTag()));
        return weStack;
    }

    @Override
    public boolean simulateItemUse(World world, BlockVector3 position, BaseItem item, Direction face) {
        PaperweightFakePlayer fakePlayer;
        CraftWorld craftWorld = (CraftWorld)world;
        WorldServer worldServer = craftWorld.getHandle();
        ItemStack stack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)BukkitAdapter.adapt(item instanceof BaseItemStack ? (BaseItemStack)item : new BaseItemStack(item.getType(), item.getNbtData(), 1)));
        stack.setTag((NBTTagCompound)this.fromNative(item.getNbtData()));
        try {
            fakePlayer = (PaperweightFakePlayer)((Object)this.fakePlayers.get((Object)worldServer));
        }
        catch (ExecutionException ignored) {
            return false;
        }
        fakePlayer.a(EnumHand.a, stack);
        fakePlayer.setLocation(position.getBlockX(), position.getBlockY(), position.getBlockZ(), (float)face.toVector().toYaw(), (float)face.toVector().toPitch());
        BlockPosition blockPos = new BlockPosition(position.getBlockX(), position.getBlockY(), position.getBlockZ());
        Vec3D blockVec = Vec3D.b((BaseBlockPosition)blockPos);
        EnumDirection enumFacing = PaperweightAdapter.adapt(face);
        MovingObjectPositionBlock rayTrace = new MovingObjectPositionBlock(blockVec, enumFacing, blockPos, false);
        ItemActionContext context = new ItemActionContext((EntityHuman)fakePlayer, EnumHand.a, rayTrace);
        EnumInteractionResult result = stack.placeItem(context, EnumHand.a);
        if (result != EnumInteractionResult.a) {
            result = worldServer.getType(blockPos).interact((net.minecraft.world.level.World)worldServer, (EntityHuman)fakePlayer, EnumHand.a, rayTrace).a() ? EnumInteractionResult.a : stack.getItem().a((net.minecraft.world.level.World)worldServer, (EntityHuman)fakePlayer, EnumHand.a).a();
        }
        return result == EnumInteractionResult.a;
    }

    @Override
    public boolean canPlaceAt(World world, BlockVector3 position, BlockState blockState) {
        int internalId = BlockStateIdAccess.getBlockStateId(blockState);
        IBlockData blockData = Block.getByCombinedId((int)internalId);
        return blockData.canPlace((IWorldReader)((CraftWorld)world).getHandle(), new BlockPosition(position.getX(), position.getY(), position.getZ()));
    }

    @Override
    public boolean regenerate(World bukkitWorld, Region region, Extent extent, RegenOptions options) {
        try {
            this.doRegen(bukkitWorld, region, extent, options);
        }
        catch (Exception e) {
            throw new IllegalStateException("Regen failed.", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRegen(World bukkitWorld, Region region, Extent extent, RegenOptions options) throws Exception {
        World.Environment env = bukkitWorld.getEnvironment();
        ChunkGenerator gen = bukkitWorld.getGenerator();
        Path tempDir = Files.createTempDirectory("WorldEditWorldGen", new FileAttribute[0]);
        Convertable levelStorage = Convertable.a((Path)tempDir);
        ResourceKey<WorldDimension> worldDimKey = this.getWorldDimKey(env);
        try (Convertable.ConversionSession session = levelStorage.c("worldeditregentempworld", worldDimKey);){
            WorldServer originalWorld = ((CraftWorld)bukkitWorld).getHandle();
            WorldDataServer levelProperties = (WorldDataServer)originalWorld.getMinecraftServer().getSaveData().H();
            GeneratorSettings originalOpts = levelProperties.getGeneratorSettings();
            long seed = options.getSeed().orElse(originalWorld.getSeed());
            GeneratorSettings newOpts = options.getSeed().isPresent() ? originalOpts.a(levelProperties.isHardcore(), OptionalLong.of(seed)) : originalOpts;
            WorldSettings newWorldSettings = new WorldSettings("worldeditregentempworld", levelProperties.e.getGameType(), levelProperties.e.isHardcore(), levelProperties.e.getDifficulty(), levelProperties.e.e(), levelProperties.e.getGameRules(), levelProperties.e.g());
            WorldDataServer newWorldData = new WorldDataServer(newWorldSettings, newOpts, Lifecycle.stable());
            WorldServer freshWorld = new WorldServer(originalWorld.getMinecraftServer(), originalWorld.getMinecraftServer().az, session, (IWorldDataServer)newWorldData, originalWorld.getDimensionKey(), originalWorld.getDimensionManager(), (WorldLoadListener)new NoOpWorldLoadListener(), ((WorldDimension)newOpts.d().a(worldDimKey)).c(), originalWorld.isDebugWorld(), seed, (List)ImmutableList.of(), false, env, gen, bukkitWorld.getBiomeProvider());
            try {
                this.regenForWorld(region, extent, freshWorld, options);
            }
            finally {
                freshWorld.getChunkProvider().close(false);
            }
        }
        finally {
            try {
                Map map = (Map)this.serverWorldsField.get(Bukkit.getServer());
                map.remove("worldeditregentempworld");
            }
            catch (IllegalAccessException illegalAccessException) {}
            SafeFiles.tryHardToDeleteDir(tempDir);
        }
    }

    private BiomeType adapt(WorldServer serverWorld, BiomeBase origBiome) {
        MinecraftKey key = serverWorld.t().d(IRegistry.aO).getKey((Object)origBiome);
        if (key == null) {
            return null;
        }
        return BiomeTypes.get(key.toString());
    }

    private void regenForWorld(Region region, Extent extent, WorldServer serverWorld, RegenOptions options) throws WorldEditException {
        IAsyncTaskHandler executor;
        List<CompletableFuture<IChunkAccess>> chunkLoadings = this.submitChunkLoadTasks(region, serverWorld);
        try {
            executor = (IAsyncTaskHandler)this.chunkProviderExecutorField.get(serverWorld.getChunkProvider());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Couldn't get executor for chunk loading.", e);
        }
        executor.awaitTasks(() -> {
            if (chunkLoadings.stream().anyMatch(ftr -> ftr.isDone() && Futures.getUnchecked((Future)ftr) == null)) {
                return false;
            }
            return chunkLoadings.stream().allMatch(CompletableFuture::isDone);
        });
        HashMap<ChunkCoordIntPair, IChunkAccess> chunks = new HashMap<ChunkCoordIntPair, IChunkAccess>();
        for (CompletableFuture<IChunkAccess> future : chunkLoadings) {
            IChunkAccess chunk = future.getNow(null);
            Preconditions.checkState((chunk != null ? 1 : 0) != 0, (Object)"Failed to generate a chunk, regen failed.");
            chunks.put(chunk.getPos(), chunk);
        }
        for (BlockVector3 vec : region) {
            BiomeBase origBiome;
            BiomeType adaptedBiome;
            BiomeStorage biomeIndex;
            BlockPosition pos = new BlockPosition(vec.getBlockX(), vec.getBlockY(), vec.getBlockZ());
            IChunkAccess chunk = (IChunkAccess)chunks.get(new ChunkCoordIntPair(pos));
            IBlockData blockData = chunk.getType(pos);
            int internalId = Block.getCombinedId((IBlockData)blockData);
            BlockStateHolder<BlockState> state = BlockStateIdAccess.getBlockStateById(internalId);
            Objects.requireNonNull(state);
            TileEntity blockEntity = chunk.getTileEntity(pos);
            if (blockEntity != null) {
                NBTTagCompound tag = new NBTTagCompound();
                blockEntity.save(tag);
                state = state.toBaseBlock((CompoundTag)this.toNative((NBTBase)tag));
            }
            extent.setBlock(vec, state.toBaseBlock());
            if (!options.shouldRegenBiomes() || (biomeIndex = chunk.getBiomeIndex()) == null || (adaptedBiome = this.adapt(serverWorld, origBiome = biomeIndex.getBiome(vec.getBlockX(), vec.getBlockY(), vec.getBlockZ()))) == null) continue;
            extent.setBiome(vec, adaptedBiome);
        }
    }

    private List<CompletableFuture<IChunkAccess>> submitChunkLoadTasks(Region region, WorldServer serverWorld) {
        ChunkProviderServer chunkManager = serverWorld.getChunkProvider();
        ArrayList<CompletableFuture<IChunkAccess>> chunkLoadings = new ArrayList<CompletableFuture<IChunkAccess>>();
        for (BlockVector2 chunk : region.getChunks()) {
            try {
                chunkLoadings.add((CompletableFuture<IChunkAccess>)((CompletableFuture)this.getChunkFutureMethod.invoke((Object)chunkManager, chunk.getX(), chunk.getZ(), ChunkStatus.i, true)).thenApply(either -> either.left().orElse(null)));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Couldn't load chunk for regen.", e);
            }
        }
        return chunkLoadings;
    }

    private ResourceKey<WorldDimension> getWorldDimKey(World.Environment env) {
        switch (env) {
            case NETHER: {
                return WorldDimension.c;
            }
            case THE_END: {
                return WorldDimension.d;
            }
        }
        return WorldDimension.b;
    }

    @Override
    public Set<SideEffect> getSupportedSideEffects() {
        return SUPPORTED_SIDE_EFFECTS;
    }

    @Override
    public boolean clearContainerBlockContents(World world, BlockVector3 pt) {
        WorldServer originalWorld = ((CraftWorld)world).getHandle();
        TileEntity entity = originalWorld.getTileEntity(new BlockPosition(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()));
        if (entity instanceof Clearable) {
            ((Clearable)entity).clear();
            return true;
        }
        return false;
    }

    Tag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Set foreignKeys = ((NBTTagCompound)foreign).getKeys();
            for (String str : foreignKeys) {
                NBTBase base = ((NBTTagCompound)foreign).get(str);
                values.put(str, this.toNative(base));
            }
            return new CompoundTag(values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(((NBTTagByte)foreign).asByte());
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(((NBTTagByteArray)foreign).getBytes());
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(((NBTTagDouble)foreign).asDouble());
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(((NBTTagFloat)foreign).asFloat());
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(((NBTTagInt)foreign).asInt());
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(((NBTTagIntArray)foreign).getInts());
        }
        if (foreign instanceof NBTTagLongArray) {
            return new LongArrayTag(((NBTTagLongArray)foreign).getLongs());
        }
        if (foreign instanceof NBTTagList) {
            try {
                return this.toNativeList((NBTTagList)foreign);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert net.minecraft.nbt.ListTag", e);
                return new ListTag(ByteTag.class, new ArrayList());
            }
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(((NBTTagLong)foreign).asLong());
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(((NBTTagShort)foreign).asShort());
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(foreign.asString());
        }
        if (foreign instanceof NBTTagEnd) {
            return new EndTag();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private ListTag toNativeList(NBTTagList foreign) throws SecurityException, IllegalArgumentException {
        ArrayList<Tag> values = new ArrayList<Tag>();
        byte type = foreign.e();
        for (NBTBase tag : foreign) {
            values.add(this.toNative(tag));
        }
        Class<? extends Tag> cls = NBTConstants.getClassFromType(type);
        return new ListTag(cls, values);
    }

    NBTBase fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), this.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return NBTTagByte.a((byte)((ByteTag)foreign).getValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return NBTTagDouble.a((double)((DoubleTag)foreign).getValue());
        }
        if (foreign instanceof FloatTag) {
            return NBTTagFloat.a((float)((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return NBTTagInt.a((int)((IntTag)foreign).getValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof LongArrayTag) {
            return new NBTTagLongArray(((LongArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList();
            ListTag foreignList = (ListTag)foreign;
            Iterator iterator = foreignList.getValue().iterator();
            while (iterator.hasNext()) {
                Tag t = (Tag)iterator.next();
                tag.add((Object)this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return NBTTagLong.a((long)((LongTag)foreign).getValue());
        }
        if (foreign instanceof ShortTag) {
            return NBTTagShort.a((short)((ShortTag)foreign).getValue());
        }
        if (foreign instanceof StringTag) {
            return NBTTagString.a((String)((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            return NBTTagEnd.b;
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    @Override
    public boolean supportsWatchdog() {
        return this.watchdog != null;
    }

    @Override
    public void tickWatchdog() {
        this.watchdog.tick();
    }

    private class SpigotWatchdog
    implements Watchdog {
        private final Field instanceField;
        private final Field lastTickField;

        SpigotWatchdog() throws NoSuchFieldException {
            Field instanceField = WatchdogThread.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            this.instanceField = instanceField;
            Field lastTickField = WatchdogThread.class.getDeclaredField("lastTick");
            lastTickField.setAccessible(true);
            this.lastTickField = lastTickField;
        }

        @Override
        public void tick() {
            try {
                WatchdogThread instance = (WatchdogThread)this.instanceField.get(null);
                if ((Long)this.lastTickField.get(instance) != 0L) {
                    WatchdogThread.tick();
                }
            }
            catch (IllegalAccessException e) {
                PaperweightAdapter.this.logger.log(Level.WARNING, "Failed to tick watchdog", e);
            }
        }
    }

    private static class MojangWatchdog
    implements Watchdog {
        private final DedicatedServer server;
        private final Field tickField;

        MojangWatchdog(DedicatedServer server) throws NoSuchFieldException {
            this.server = server;
            Field tickField = MinecraftServer.class.getDeclaredField(Refraction.pickName("nextTickTime", "ao"));
            tickField.setAccessible(true);
            this.tickField = tickField;
        }

        @Override
        public void tick() {
            try {
                this.tickField.set(this.server, SystemUtils.getMonotonicMillis());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static class NoOpWorldLoadListener
    implements WorldLoadListener {
        private NoOpWorldLoadListener() {
        }

        public void a(ChunkCoordIntPair spawnPos) {
        }

        public void a(ChunkCoordIntPair pos, @Nullable ChunkStatus status) {
        }

        public void a() {
        }

        public void b() {
        }

        public void setChunkRadius(int radius) {
        }
    }
}

