/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sk89q.bukkit.util.ClassSourceValidator;
import com.sk89q.util.yaml.YAMLProcessor;
import com.sk89q.wepif.PermissionsResolverManager;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bstats.bukkit.Metrics;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitBlockCommandSender;
import com.sk89q.worldedit.bukkit.BukkitCommandSender;
import com.sk89q.worldedit.bukkit.BukkitConfiguration;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitServerInterface;
import com.sk89q.worldedit.bukkit.CUIChannelListener;
import com.sk89q.worldedit.bukkit.WorldEditListener;
import com.sk89q.worldedit.bukkit.adapter.AdapterLoadException;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplLoader;
import com.sk89q.worldedit.bukkit.paperlib.PaperLib;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.event.platform.CommandSuggestionEvent;
import com.sk89q.worldedit.event.platform.PlatformReadyEvent;
import com.sk89q.worldedit.event.platform.PlatformUnreadyEvent;
import com.sk89q.worldedit.event.platform.PlatformsRegisteredEvent;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.internal.anvil.ChunkDeleter;
import com.sk89q.worldedit.internal.command.CommandUtil;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.lifecycle.Lifecycled;
import com.sk89q.worldedit.util.lifecycle.SimpleLifecycled;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockCategory;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemCategory;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.weather.WeatherTypes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Biome;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;

public class WorldEditPlugin
extends JavaPlugin
implements TabCompleter {
    private static final String FAILED_VERSION_CHECK = "\n**********************************************\n** This Minecraft version (%s) is not supported by this version of WorldEdit.\n** Please download an OLDER version of WorldEdit which does.\n**********************************************\n";
    private static final Logger LOGGER;
    public static final String CUI_PLUGIN_CHANNEL = "worldedit:cui";
    private static WorldEditPlugin INSTANCE;
    private static final int BSTATS_PLUGIN_ID = 3328;
    private final SimpleLifecycled<BukkitImplAdapter> adapter = SimpleLifecycled.invalid();
    private BukkitServerInterface platform;
    private BukkitConfiguration config;

    public void onLoad() {
        INSTANCE = this;
        this.getDataFolder().mkdirs();
        WorldEdit worldEdit = WorldEdit.getInstance();
        this.platform = new BukkitServerInterface(this, this.getServer());
        worldEdit.getPlatformManager().register(this.platform);
        this.createDefaultConfiguration("config.yml");
        this.config = new BukkitConfiguration(new YAMLProcessor(new File(this.getDataFolder(), "config.yml"), true), this);
        Path delChunks = Paths.get(this.getDataFolder().getPath(), "delete_chunks.json");
        if (Files.exists(delChunks, new LinkOption[0])) {
            ChunkDeleter.runFromFile(delChunks, true);
        }
    }

    public void onEnable() {
        ClassSourceValidator verifier = new ClassSourceValidator((Plugin)this);
        verifier.reportMismatches((List<Class<?>>)ImmutableList.of(World.class, CommandManager.class, EditSession.class, Actor.class));
        WorldEdit.getInstance().getEventBus().post(new PlatformsRegisteredEvent());
        PermissionsResolverManager.initialize((Plugin)this);
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL, (PluginMessageListener)new CUIChannelListener(this));
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, CUI_PLUGIN_CHANNEL);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditListener(this), (Plugin)this);
        if (PaperLib.isPaper()) {
            this.getServer().getPluginManager().registerEvents((Listener)new AsyncTabCompleteListener(), (Plugin)this);
        }
        this.initializeRegistries();
        if (Bukkit.getWorlds().isEmpty()) {
            this.setupPreWorldData();
            this.getServer().getPluginManager().registerEvents((Listener)new WorldInitListener(), (Plugin)this);
        } else {
            this.getLogger().warning("Server reload detected. This may cause various issues with WorldEdit and dependent plugins.");
            try {
                this.setupPreWorldData();
                this.setupWorldData();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        new Metrics(this, 3328);
        PaperLib.suggestPaper((Plugin)this);
    }

    private void setupPreWorldData() {
        this.loadAdapter();
        this.config.load();
        WorldEdit.getInstance().loadMappings();
    }

    private void setupWorldData() {
        this.setupTags();
        WorldEdit.getInstance().getEventBus().post(new PlatformReadyEvent(this.platform));
    }

    private void initializeRegistries() {
        for (Biome biome : Biome.values()) {
            String lowerCaseBiomeName = biome.name().toLowerCase(Locale.ROOT);
            BiomeType.REGISTRY.register("minecraft:" + lowerCaseBiomeName, new BiomeType("minecraft:" + lowerCaseBiomeName));
        }
        for (Biome biome : Material.values()) {
            if (biome.isBlock() && !biome.isLegacy()) {
                BlockType.REGISTRY.register(biome.getKey().toString(), new BlockType(biome.getKey().toString(), arg_0 -> this.lambda$initializeRegistries$0((Material)biome, arg_0)));
            }
            if (!biome.isItem() || biome.isLegacy()) continue;
            ItemType.REGISTRY.register(biome.getKey().toString(), new ItemType(biome.getKey().toString()));
        }
        for (Biome biome : EntityType.values()) {
            String mcid = biome.getName();
            if (mcid == null) continue;
            String lowerCaseMcId = mcid.toLowerCase(Locale.ROOT);
            com.sk89q.worldedit.world.entity.EntityType.REGISTRY.register("minecraft:" + lowerCaseMcId, new com.sk89q.worldedit.world.entity.EntityType("minecraft:" + lowerCaseMcId));
        }
        GameModes.get("");
        WeatherTypes.get("");
    }

    private void setupTags() {
        try {
            for (Tag blockTag : Bukkit.getTags((String)"blocks", Material.class)) {
                BlockCategory.REGISTRY.register(blockTag.getKey().toString(), new BlockCategory(blockTag.getKey().toString()));
            }
            for (Tag itemTag : Bukkit.getTags((String)"items", Material.class)) {
                ItemCategory.REGISTRY.register(itemTag.getKey().toString(), new ItemCategory(itemTag.getKey().toString()));
            }
        }
        catch (NoSuchMethodError ignored) {
            this.getLogger().warning("The version of Spigot/Paper you are using doesn't support Tags. The usage of tags with WorldEdit will not work until you update.");
        }
    }

    private void loadAdapter() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        BukkitImplLoader adapterLoader = new BukkitImplLoader();
        try {
            adapterLoader.addFromPath(((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to search path for Bukkit adapters");
        }
        try {
            adapterLoader.addFromJar(this.getFile());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to search " + this.getFile() + " for Bukkit adapters", (Throwable)e);
        }
        try {
            BukkitImplAdapter bukkitAdapter = adapterLoader.loadAdapter();
            LOGGER.info("Using " + bukkitAdapter.getClass().getCanonicalName() + " as the Bukkit adapter");
            this.adapter.newValue(bukkitAdapter);
        }
        catch (AdapterLoadException e) {
            Platform platform = worldEdit.getPlatformManager().queryCapability(Capability.WORLD_EDITING);
            if (platform instanceof BukkitServerInterface) {
                LOGGER.warn(e.getMessage());
            } else {
                LOGGER.info("WorldEdit could not find a Bukkit adapter for this MC version, but it seems that you have another implementation of WorldEdit installed (" + platform.getPlatformName() + ") that handles the world editing.");
            }
            this.adapter.invalidate();
        }
    }

    public void onDisable() {
        WorldEdit worldEdit = WorldEdit.getInstance();
        worldEdit.getSessionManager().unload();
        if (this.platform != null) {
            worldEdit.getEventBus().post(new PlatformUnreadyEvent(this.platform));
            worldEdit.getPlatformManager().unregister(this.platform);
            this.platform.unregisterCommands();
        }
        if (this.config != null) {
            this.config.unload();
        }
        this.getServer().getScheduler().cancelTasks((Plugin)this);
    }

    protected void loadConfiguration() {
        this.config.unload();
        this.config.load();
        this.getPermissionsResolver().load();
    }

    protected void createDefaultConfiguration(String name) {
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists()) {
            try (InputStream stream = this.getResource("defaults/" + name);){
                if (stream == null) {
                    throw new FileNotFoundException();
                }
                this.copyDefaultConfig(stream, actual, name);
            }
            catch (IOException e) {
                this.getLogger().severe("Unable to read default configuration: " + name);
            }
        }
    }

    private void copyDefaultConfig(InputStream input, File actual, String name) {
        try (FileOutputStream output = new FileOutputStream(actual);){
            int length;
            byte[] buf = new byte[8192];
            while ((length = input.read(buf)) > 0) {
                output.write(buf, 0, length);
            }
            this.getLogger().info("Default configuration file written: " + name);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Failed to write default config file", e);
        }
    }

    private String rebuildArguments(String commandLabel, String[] args) {
        int plSep = commandLabel.indexOf(":");
        if (plSep >= 0 && plSep < commandLabel.length() + 1) {
            commandLabel = commandLabel.substring(plSep + 1);
        }
        StringBuilder sb = new StringBuilder("/").append(commandLabel);
        if (args.length > 0) {
            sb.append(" ");
        }
        return Joiner.on((String)" ").appendTo(sb, (Object[])args).toString();
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String commandLabel, String[] args) {
        String arguments = this.rebuildArguments(commandLabel, args);
        CommandEvent event = new CommandEvent(this.wrapCommandSender(sender), arguments);
        this.getWorldEdit().getEventBus().post(event);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, org.bukkit.command.Command cmd, String commandLabel, String[] args) {
        String arguments = this.rebuildArguments(commandLabel, args);
        CommandSuggestionEvent event = new CommandSuggestionEvent(this.wrapCommandSender(sender), arguments);
        this.getWorldEdit().getEventBus().post(event);
        return CommandUtil.fixSuggestions(arguments, event.getSuggestions());
    }

    public LocalSession getSession(Player player) {
        return WorldEdit.getInstance().getSessionManager().get(this.wrapPlayer(player));
    }

    public EditSession createEditSession(Player player) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(wePlayer);
        BlockBag blockBag = session.getBlockBag(wePlayer);
        EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().locatableActor(wePlayer).maxBlocks(session.getBlockChangeLimit()).blockBag(blockBag).build();
        editSession.enableStandardMode();
        return editSession;
    }

    public void remember(Player player, EditSession editSession) {
        BukkitPlayer wePlayer = this.wrapPlayer(player);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(wePlayer);
        session.remember(editSession);
        editSession.close();
        WorldEdit.getInstance().flushBlockBag(wePlayer, editSession);
    }

    public BukkitConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return PermissionsResolverManager.getInstance();
    }

    public BukkitPlayer wrapPlayer(Player player) {
        return new BukkitPlayer(this, player);
    }

    public Actor wrapCommandSender(CommandSender sender) {
        if (sender instanceof Player) {
            return this.wrapPlayer((Player)sender);
        }
        if (this.config.commandBlockSupport && sender instanceof BlockCommandSender) {
            return new BukkitBlockCommandSender(this, (BlockCommandSender)sender);
        }
        return new BukkitCommandSender(this, sender);
    }

    BukkitServerInterface getInternalPlatform() {
        return this.platform;
    }

    public WorldEdit getWorldEdit() {
        return WorldEdit.getInstance();
    }

    static WorldEditPlugin getInstance() {
        return (WorldEditPlugin)((Object)Preconditions.checkNotNull((Object)((Object)INSTANCE)));
    }

    Lifecycled<BukkitImplAdapter> getLifecycledBukkitImplAdapter() {
        return this.adapter;
    }

    BukkitImplAdapter getBukkitImplAdapter() {
        return this.adapter.value().orElse(null);
    }

    private /* synthetic */ BlockState lambda$initializeRegistries$0(Material material, BlockState blockState) {
        ParserContext context = new ParserContext();
        context.setPreferringWildcard(true);
        context.setTryLegacy(false);
        context.setRestricted(false);
        try {
            FuzzyBlockState state = (FuzzyBlockState)((BaseBlock)WorldEdit.getInstance().getBlockFactory().parseFromInput(BukkitAdapter.adapt(blockState.getBlockType()).createBlockData().getAsString(), context)).toImmutableState();
            BlockStateHolder<BlockState> defaultState = blockState.getBlockType().getAllStates().get(0);
            for (Map.Entry<Property<?>, Object> propertyObjectEntry : state.getStates().entrySet()) {
                defaultState = defaultState.with(propertyObjectEntry.getKey(), propertyObjectEntry.getValue());
            }
            return defaultState;
        }
        catch (InputParseException e) {
            this.getLogger().log(Level.WARNING, "Error loading block state for " + material.getKey(), e);
            return blockState;
        }
    }

    static {
        if (PaperLib.getMinecraftVersion() < 13) {
            throw new IllegalStateException(String.format(FAILED_VERSION_CHECK, Bukkit.getVersion()));
        }
        LOGGER = LogManagerCompat.getLogger();
    }

    private class AsyncTabCompleteListener
    implements Listener {
        AsyncTabCompleteListener() {
        }

        @EventHandler(ignoreCancelled=true)
        public void onAsyncTabComplete(AsyncTabCompleteEvent event) {
            Optional<Command> command;
            if (!event.isCommand()) {
                return;
            }
            String buffer = event.getBuffer();
            int firstSpace = buffer.indexOf(32);
            if (firstSpace < 1) {
                return;
            }
            String label = buffer.substring(1, firstSpace);
            Plugin owner = WorldEditPlugin.this.platform.getDynamicCommands().getCommandOwner(label);
            if (owner != WorldEditPlugin.this) {
                return;
            }
            int plSep = label.indexOf(":");
            if (plSep >= 0 && plSep < label.length() + 1) {
                label = label.substring(plSep + 1);
                buffer = "/" + buffer.substring(plSep + 2);
            }
            if (!(command = WorldEdit.getInstance().getPlatformManager().getPlatformCommandManager().getCommandManager().getCommand(label)).isPresent()) {
                return;
            }
            CommandSuggestionEvent suggestEvent = new CommandSuggestionEvent(WorldEditPlugin.this.wrapCommandSender(event.getSender()), buffer);
            WorldEditPlugin.this.getWorldEdit().getEventBus().post(suggestEvent);
            event.setCompletions(CommandUtil.fixSuggestions(buffer, suggestEvent.getSuggestions()));
            event.setHandled(true);
        }
    }

    private class WorldInitListener
    implements Listener {
        private boolean loaded = false;

        private WorldInitListener() {
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public void onWorldInit(WorldInitEvent event) {
            if (this.loaded) {
                return;
            }
            this.loaded = true;
            WorldEditPlugin.this.setupWorldData();
        }
    }
}

