/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.event.platform.SessionIdleEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import java.util.Optional;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.inject.MapBackedValueStore;

public class WorldEditListener
implements Listener {
    private final WorldEditPlugin plugin;

    public WorldEditListener(WorldEditPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGamemode(PlayerGameModeChangeEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        WorldEdit.getInstance().getSessionManager().get(this.plugin.wrapPlayer(event.getPlayer()));
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerCommandSend(PlayerCommandSendEvent event) {
        MapBackedValueStore store = MapBackedValueStore.create();
        store.injectValue(Key.of(Actor.class), context -> Optional.of(this.plugin.wrapCommandSender((CommandSender)event.getPlayer())));
        CommandManager commandManager = this.plugin.getWorldEdit().getPlatformManager().getPlatformCommandManager().getCommandManager();
        event.getCommands().removeIf(name -> commandManager.getCommand((String)name).filter(command -> !command.getCondition().satisfied(store)).isPresent());
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.plugin.getInternalPlatform().isHookingEvents()) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (event.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        BukkitPlayer player = this.plugin.wrapPlayer(event.getPlayer());
        World world = player.getWorld();
        WorldEdit we = this.plugin.getWorldEdit();
        Direction direction = BukkitAdapter.adapt(event.getBlockFace());
        Action action = event.getAction();
        if (action == Action.LEFT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            Location pos = new Location((Extent)world, clickedBlock.getX(), (double)clickedBlock.getY(), (double)clickedBlock.getZ());
            if (we.handleBlockLeftClick(player, pos, direction)) {
                event.setCancelled(true);
            }
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.LEFT_CLICK_AIR) {
            if (we.handleArmSwing(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_BLOCK) {
            Block clickedBlock = event.getClickedBlock();
            Location pos = new Location((Extent)world, clickedBlock.getX(), (double)clickedBlock.getY(), (double)clickedBlock.getZ());
            if (we.handleBlockRightClick(player, pos, direction)) {
                event.setCancelled(true);
            }
            if (we.handleRightClick(player)) {
                event.setCancelled(true);
            }
        } else if (action == Action.RIGHT_CLICK_AIR && we.handleRightClick(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.plugin.getWorldEdit().getEventBus().post(new SessionIdleEvent(new BukkitPlayer.SessionKeyImpl(event.getPlayer())));
    }
}

