/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import co.aikar.timings.MinecraftTimings;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.animal.EntitySheep;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityPillager;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import org.spigotmc.SpigotWorldConfig;

public class ActivationRange {
    static Activity[] VILLAGER_PANIC_IMMUNITIES = new Activity[]{Activity.j, Activity.i, Activity.h, Activity.g};
    static AxisAlignedBB maxBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    private static int checkInactiveWakeup(Entity entity) {
        World world = entity.s;
        SpigotWorldConfig config = world.spigotConfig;
        long inactiveFor = (long)MinecraftServer.currentTick - entity.activatedTick;
        if (entity.activationType == ActivationType.VILLAGER) {
            if (inactiveFor > (long)config.wakeUpInactiveVillagersEvery && world.wakeupInactiveRemainingVillagers > 0) {
                --world.wakeupInactiveRemainingVillagers;
                return config.wakeUpInactiveVillagersFor;
            }
        } else if (entity.activationType == ActivationType.ANIMAL) {
            if (inactiveFor > (long)config.wakeUpInactiveAnimalsEvery && world.wakeupInactiveRemainingAnimals > 0) {
                --world.wakeupInactiveRemainingAnimals;
                return config.wakeUpInactiveAnimalsFor;
            }
        } else if (entity.activationType == ActivationType.FLYING_MONSTER) {
            if (inactiveFor > (long)config.wakeUpInactiveFlyingEvery && world.wakeupInactiveRemainingFlying > 0) {
                --world.wakeupInactiveRemainingFlying;
                return config.wakeUpInactiveFlyingFor;
            }
        } else if ((entity.activationType == ActivationType.MONSTER || entity.activationType == ActivationType.RAIDER) && inactiveFor > (long)config.wakeUpInactiveMonstersEvery && world.wakeupInactiveRemainingMonsters > 0) {
            --world.wakeupInactiveRemainingMonsters;
            return config.wakeUpInactiveMonstersFor;
        }
        return -1;
    }

    public static ActivationType initializeEntityActivationType(Entity entity) {
        if (entity instanceof EntityWaterAnimal) {
            return ActivationType.WATER;
        }
        if (entity instanceof EntityVillager) {
            return ActivationType.VILLAGER;
        }
        if (entity instanceof EntityFlying && entity instanceof IMonster) {
            return ActivationType.FLYING_MONSTER;
        }
        if (entity instanceof EntityRaider) {
            return ActivationType.RAIDER;
        }
        if (entity instanceof IMonster) {
            return ActivationType.MONSTER;
        }
        if (entity instanceof EntityCreature || entity instanceof EntityAmbient) {
            return ActivationType.ANIMAL;
        }
        return ActivationType.MISC;
    }

    public static boolean initializeEntityActivationState(Entity entity, SpigotWorldConfig config) {
        return entity.activationType == ActivationType.MISC && config.miscActivationRange <= 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange <= 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange <= 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange <= 0 || entity.activationType == ActivationType.VILLAGER && config.villagerActivationRange <= 0 || entity.activationType == ActivationType.WATER && config.waterActivationRange <= 0 || entity.activationType == ActivationType.FLYING_MONSTER && config.flyingMonsterActivationRange <= 0 || entity instanceof EntityEnderSignal || entity instanceof EntityHuman || entity instanceof EntityProjectile || entity instanceof EntityEnderDragon || entity instanceof EntityComplexPart || entity instanceof EntityWither || entity instanceof EntityFireball || entity instanceof EntityLightning || entity instanceof EntityTNTPrimed || entity instanceof EntityFallingBlock || entity instanceof EntityEnderCrystal || entity instanceof EntityFireworks || entity instanceof EntityThrownTrident;
    }

    public static void activateEntities(World world) {
        MinecraftTimings.entityActivationCheckTimer.startTiming();
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int waterActivationRange = world.spigotConfig.waterActivationRange;
        int flyingActivationRange = world.spigotConfig.flyingMonsterActivationRange;
        int villagerActivationRange = world.spigotConfig.villagerActivationRange;
        world.wakeupInactiveRemainingAnimals = Math.min(world.wakeupInactiveRemainingAnimals + 1, world.spigotConfig.wakeUpInactiveAnimals);
        world.wakeupInactiveRemainingVillagers = Math.min(world.wakeupInactiveRemainingVillagers + 1, world.spigotConfig.wakeUpInactiveVillagers);
        world.wakeupInactiveRemainingMonsters = Math.min(world.wakeupInactiveRemainingMonsters + 1, world.spigotConfig.wakeUpInactiveMonsters);
        world.wakeupInactiveRemainingFlying = Math.min(world.wakeupInactiveRemainingFlying + 1, world.spigotConfig.wakeUpInactiveFlying);
        ChunkProviderServer chunkProvider = (ChunkProviderServer)world.K();
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.max(maxRange, flyingActivationRange);
        maxRange = Math.max(maxRange, waterActivationRange);
        maxRange = Math.max(maxRange, villagerActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (EntityHuman entityHuman : world.y()) {
            entityHuman.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && entityHuman.B_()) continue;
            maxBB = entityHuman.cw().c(maxRange, 256.0, maxRange);
            ActivationType.MISC.boundingBox = entityHuman.cw().c(miscActivationRange, 256.0, miscActivationRange);
            ActivationType.RAIDER.boundingBox = entityHuman.cw().c(raiderActivationRange, 256.0, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = entityHuman.cw().c(animalActivationRange, 256.0, animalActivationRange);
            ActivationType.MONSTER.boundingBox = entityHuman.cw().c(monsterActivationRange, 256.0, monsterActivationRange);
            ActivationType.WATER.boundingBox = entityHuman.cw().c(waterActivationRange, 256.0, waterActivationRange);
            ActivationType.FLYING_MONSTER.boundingBox = entityHuman.cw().c(flyingActivationRange, 256.0, flyingActivationRange);
            ActivationType.VILLAGER.boundingBox = entityHuman.cw().c(villagerActivationRange, 256.0, villagerActivationRange);
            List<Entity> entities = world.a((Entity)null, maxBB, null);
            for (int i2 = 0; i2 < entities.size(); ++i2) {
                Entity entity = entities.get(i2);
                ActivationRange.activateEntity(entity);
            }
        }
        MinecraftTimings.entityActivationCheckTimer.stopTiming();
    }

    private static void activateEntity(Entity entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.c(entity.cw())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static int checkEntityImmunities(Entity entity) {
        SpigotWorldConfig config = entity.s.spigotConfig;
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.aF > 0) {
            return 2;
        }
        if (entity.activatedImmunityTick >= (long)MinecraftServer.currentTick) {
            return 1;
        }
        long inactiveFor = (long)MinecraftServer.currentTick - entity.activatedTick;
        if (entity.activationType != ActivationType.WATER && entity.T && entity.cp()) {
            return 100;
        }
        if (!(entity instanceof EntityArrow)) {
            if (!entity.aw() && !(entity instanceof EntityFlying)) {
                return 10;
            }
        } else if (!((EntityArrow)entity).b) {
            return 1;
        }
        if (entity instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)entity;
            if (living.b_() || living.bn || living.aK > 0 || living.bS.size() > 0) {
                return 1;
            }
            if (entity instanceof EntityInsentient && ((EntityInsentient)entity).G() != null) {
                return 20;
            }
            if (entity instanceof EntityBee) {
                EntityBee bee = (EntityBee)entity;
                BlockPosition movingTarget = bee.getMovingTarget();
                if (bee.I_() || bee.fI() != null && bee.fI().equals(movingTarget) || bee.q() != null && bee.q().equals(movingTarget)) {
                    return 20;
                }
            }
            if (entity instanceof EntityVillager) {
                BehaviorController<EntityVillager> behaviorController = ((EntityVillager)entity).du();
                if (config.villagersActiveForPanic) {
                    for (Activity activity : VILLAGER_PANIC_IMMUNITIES) {
                        if (!behaviorController.c(activity)) continue;
                        return 100;
                    }
                }
                if (config.villagersWorkImmunityAfter > 0 && inactiveFor >= (long)config.villagersWorkImmunityAfter && behaviorController.c(Activity.c)) {
                    return config.villagersWorkImmunityFor;
                }
            }
            if (entity instanceof EntityLlama && ((EntityLlama)entity).gp()) {
                return 1;
            }
            if (entity instanceof EntityAnimal) {
                EntityAnimal animal = (EntityAnimal)entity;
                if (animal.y_() || animal.fF()) {
                    return 5;
                }
                if (entity instanceof EntitySheep && ((EntitySheep)entity).fz()) {
                    return 1;
                }
            }
            if (entity instanceof EntityCreeper && ((EntityCreeper)entity).t()) {
                return 20;
            }
            if (entity instanceof EntityInsentient && ((EntityInsentient)entity).bR.hasTasks()) {
                return 0;
            }
            if (entity instanceof EntityPillager) {
                EntityPillager entityPillager = (EntityPillager)entity;
            }
        }
        if (entity instanceof EntityExperienceOrb) {
            return 20;
        }
        return -1;
    }

    public static boolean checkIfActive(Entity entity) {
        if (entity instanceof EntityFireworks) {
            return true;
        }
        if (entity.defaultActivationState || entity.S < 200 || !entity.bl() || entity.ag || entity.aT > 0) {
            return true;
        }
        if (entity instanceof EntityInsentient && ((EntityInsentient)entity).cf instanceof EntityHuman) {
            return true;
        }
        boolean isActive = entity.activatedTick >= (long)MinecraftServer.currentTick;
        entity.isTemporarilyActive = false;
        if (!isActive) {
            if (((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
                int immunity = ActivationRange.checkEntityImmunities(entity);
                if (immunity >= 0) {
                    entity.activatedTick = MinecraftServer.currentTick + immunity;
                } else {
                    entity.isTemporarilyActive = true;
                }
                isActive = true;
            }
        } else if (entity.S + entity.ae() + 1 == 0 && ActivationRange.checkEntityImmunities(entity) < 0) {
            isActive = false;
        }
        return isActive;
    }

    public static enum ActivationType {
        WATER,
        FLYING_MONSTER,
        VILLAGER,
        MONSTER,
        ANIMAL,
        RAIDER,
        MISC;

        AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }
}

