/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class CraftNBTTagConfigSerializer {
    private static final Pattern ARRAY = Pattern.compile("^\\[.*]");
    private static final Pattern INTEGER = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)i", 2);
    private static final Pattern DOUBLE = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final MojangsonParser MOJANGSON_PARSER = new MojangsonParser(new StringReader(""));

    public static Object serialize(NBTBase base) {
        if (base instanceof NBTTagCompound) {
            HashMap<String, Object> innerMap = new HashMap<String, Object>();
            for (String key : ((NBTTagCompound)base).d()) {
                innerMap.put(key, CraftNBTTagConfigSerializer.serialize(((NBTTagCompound)base).c(key)));
            }
            return innerMap;
        }
        if (base instanceof NBTTagList) {
            ArrayList<Object> baseList = new ArrayList<Object>();
            for (int i2 = 0; i2 < ((NBTList)base).size(); ++i2) {
                baseList.add(CraftNBTTagConfigSerializer.serialize((NBTBase)((NBTList)base).get(i2)));
            }
            return baseList;
        }
        if (base instanceof NBTTagString) {
            return base.e_();
        }
        if (base instanceof NBTTagInt) {
            return base.toString() + "i";
        }
        return base.toString();
    }

    public static NBTBase deserialize(Object object) {
        if (object instanceof Map) {
            NBTTagCompound compound = new NBTTagCompound();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                compound.a((String)entry.getKey(), CraftNBTTagConfigSerializer.deserialize(entry.getValue()));
            }
            return compound;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return new NBTTagList();
            }
            NBTTagList tagList = new NBTTagList();
            for (Object tag : list) {
                tagList.add(CraftNBTTagConfigSerializer.deserialize(tag));
            }
            return tagList;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (ARRAY.matcher(string).matches()) {
                try {
                    return new MojangsonParser(new StringReader(string)).h();
                }
                catch (CommandSyntaxException e2) {
                    throw new RuntimeException("Could not deserialize found list ", e2);
                }
            }
            if (INTEGER.matcher(string).matches()) {
                return NBTTagInt.a(Integer.parseInt(string.substring(0, string.length() - 1)));
            }
            if (DOUBLE.matcher(string).matches()) {
                return NBTTagDouble.a(Double.parseDouble(string.substring(0, string.length() - 1)));
            }
            NBTBase nbtBase = MOJANGSON_PARSER.b(string);
            if (nbtBase instanceof NBTTagInt) {
                return NBTTagString.a(nbtBase.e_());
            }
            if (nbtBase instanceof NBTTagDouble) {
                return NBTTagString.a(String.valueOf(((NBTTagDouble)nbtBase).i()));
            }
            return nbtBase;
        }
        throw new RuntimeException("Could not deserialize NBTBase");
    }
}

