/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.util;

import co.aikar.timings.TimingsExport;
import com.destroystokyo.paper.PaperConfig;
import com.destroystokyo.paper.PaperVersionFetcher;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.attribute.UnmodifiableAttributeMap;
import io.papermc.paper.inventory.ItemRarity;
import io.papermc.paper.registry.PaperRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.LootDeserializationContext;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.SavedFile;
import org.bukkit.Bukkit;
import org.bukkit.Fluid;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.attribute.Attributable;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.attribute.CraftAttributeInstance;
import org.bukkit.craftbukkit.v1_18_R2.attribute.CraftAttributeMap;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftCreativeCategory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.legacy.CraftLegacy;
import org.bukkit.craftbukkit.v1_18_R2.util.Commodore;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.CreativeCategory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.PluginDescriptionFile;

public final class CraftMagicNumbers
implements UnsafeValues {
    public static final UnsafeValues INSTANCE = new CraftMagicNumbers();
    private static final Map<Block, Material> BLOCK_MATERIAL = new HashMap<Block, Material>();
    private static final Map<Item, Material> ITEM_MATERIAL = new HashMap<Item, Material>();
    private static final Map<FluidType, Fluid> FLUID_MATERIAL = new HashMap<FluidType, Fluid>();
    private static final Map<Material, Item> MATERIAL_ITEM = new HashMap<Material, Item>();
    private static final Map<Material, Block> MATERIAL_BLOCK = new HashMap<Material, Block>();
    private static final Map<Material, FluidType> MATERIAL_FLUID = new HashMap<Material, FluidType>();
    private static final Map<EntityType, EntityTypes<?>> ENTITY_TYPE_ENTITY_TYPES = new HashMap();
    private static final Map<EntityTypes<?>, EntityType> ENTITY_TYPES_ENTITY_TYPE = new HashMap();
    private static final List<String> SUPPORTED_API;

    private CraftMagicNumbers() {
    }

    public ComponentFlattener componentFlattener() {
        return PaperAdventure.FLATTENER;
    }

    public GsonComponentSerializer colorDownsamplingGsonComponentSerializer() {
        return PaperAdventure.COLOR_DOWNSAMPLING_GSON;
    }

    public GsonComponentSerializer gsonComponentSerializer() {
        return PaperAdventure.GSON;
    }

    public PlainComponentSerializer plainComponentSerializer() {
        return PaperAdventure.PLAIN_COMPONENT;
    }

    public PlainTextComponentSerializer plainTextSerializer() {
        return PaperAdventure.PLAIN;
    }

    public LegacyComponentSerializer legacyComponentSerializer() {
        return PaperAdventure.LEGACY_SECTION_UXRC;
    }

    public static IBlockData getBlock(MaterialData material) {
        return CraftMagicNumbers.getBlock(material.getItemType(), material.getData());
    }

    public static IBlockData getBlock(Material material, byte data) {
        return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
    }

    public static MaterialData getMaterial(IBlockData data) {
        return CraftLegacy.toLegacy(CraftMagicNumbers.getMaterial(data.b())).getNewData(CraftMagicNumbers.toLegacyData(data));
    }

    public static Item getItem(Material material, short data) {
        if (material.isLegacy()) {
            return CraftLegacy.fromLegacyData(CraftLegacy.toLegacy(material), data);
        }
        return CraftMagicNumbers.getItem(material);
    }

    public static MaterialData getMaterialData(Item item) {
        return CraftLegacy.toLegacyData(CraftMagicNumbers.getMaterial(item));
    }

    public static Material getMaterial(Block block) {
        return BLOCK_MATERIAL.get(block);
    }

    public static Material getMaterial(Item item) {
        return ITEM_MATERIAL.getOrDefault(item, Material.AIR);
    }

    public static Fluid getFluid(FluidType fluid) {
        return FLUID_MATERIAL.get(fluid);
    }

    public static Item getItem(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_ITEM.get(material);
    }

    public static Block getBlock(Material material) {
        if (material != null && material.isLegacy()) {
            material = CraftLegacy.fromLegacy(material);
        }
        return MATERIAL_BLOCK.get(material);
    }

    public static FluidType getFluid(Material fluid) {
        return MATERIAL_FLUID.get(fluid);
    }

    public static MinecraftKey key(Material mat) {
        return CraftNamespacedKey.toMinecraft(mat.getKey());
    }

    public static EntityTypes<?> getEntityTypes(EntityType type) {
        return ENTITY_TYPE_ENTITY_TYPES.get(type);
    }

    public static EntityType getEntityType(EntityTypes<?> entityTypes) {
        return ENTITY_TYPES_ENTITY_TYPE.get(entityTypes);
    }

    public void reportTimings() {
        TimingsExport.reportTimings();
    }

    public static byte toLegacyData(IBlockData data) {
        return CraftLegacy.toLegacyData(data);
    }

    public Material toLegacy(Material material) {
        return CraftLegacy.toLegacy(material);
    }

    public Material fromLegacy(Material material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material) {
        return CraftLegacy.fromLegacy(material);
    }

    public Material fromLegacy(MaterialData material, boolean itemPriority) {
        return CraftLegacy.fromLegacy(material, itemPriority);
    }

    public BlockData fromLegacy(Material material, byte data) {
        return CraftBlockData.fromData(CraftMagicNumbers.getBlock(material, data));
    }

    public Material getMaterial(String material, int version) {
        Dynamic converted;
        Preconditions.checkArgument((material != null ? 1 : 0) != 0, (Object)"material == null");
        Preconditions.checkArgument((version <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        if (version == this.getDataVersion()) {
            return Material.getMaterial((String)material);
        }
        Dynamic<NBTTagString> name = new Dynamic<NBTTagString>(DynamicOpsNBT.a, NBTTagString.a("minecraft:" + material.toLowerCase(Locale.ROOT)));
        if (name.equals((Object)(converted = DataConverterRegistry.a().update(DataConverterTypes.s, name, version, this.getDataVersion())))) {
            converted = DataConverterRegistry.a().update(DataConverterTypes.r, name, version, this.getDataVersion());
        }
        return Material.matchMaterial((String)converted.asString(""));
    }

    public String getMappingsVersion() {
        return "eaeedbff51b16ead3170906872fda334";
    }

    public int getDataVersion() {
        return SharedConstants.b().getWorldVersion();
    }

    public ItemStack modifyItemStack(ItemStack stack, String arguments) {
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy(stack);
        try {
            nmsStack.c(MojangsonParser.a(arguments));
        }
        catch (CommandSyntaxException ex) {
            Logger.getLogger(CraftMagicNumbers.class.getName()).log(Level.SEVERE, null, ex);
        }
        stack.setItemMeta(CraftItemStack.getItemMeta(nmsStack));
        return stack;
    }

    private static File getBukkitDataPackFolder() {
        return new File(MinecraftServer.getServer().a(SavedFile.g).toFile(), "bukkit");
    }

    public Advancement loadAdvancement(NamespacedKey key, String advancement) {
        if (Bukkit.getAdvancement((NamespacedKey)key) != null) {
            throw new IllegalArgumentException("Advancement " + key + " already exists.");
        }
        MinecraftKey minecraftkey = CraftNamespacedKey.toMinecraft(key);
        JsonElement jsonelement = (JsonElement)AdvancementDataWorld.b.fromJson(advancement, JsonElement.class);
        JsonObject jsonobject = ChatDeserializer.m(jsonelement, "advancement");
        Advancement.SerializedAdvancement nms = Advancement.SerializedAdvancement.a(jsonobject, new LootDeserializationContext(minecraftkey, MinecraftServer.getServer().aG()));
        if (nms != null) {
            MinecraftServer.getServer().ax().c.a(Maps.newHashMap(Collections.singletonMap(minecraftkey, nms)));
            Advancement bukkit = Bukkit.getAdvancement((NamespacedKey)key);
            if (bukkit != null) {
                File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
                file.getParentFile().mkdirs();
                try {
                    Files.write((CharSequence)advancement, (File)file, (Charset)Charsets.UTF_8);
                }
                catch (IOException ex) {
                    Bukkit.getLogger().log(Level.SEVERE, "Error saving advancement " + key, ex);
                }
                MinecraftServer.getServer().ac().t().forEach(player -> {
                    player.M().a(MinecraftServer.getServer().ax());
                    player.M().b((EntityPlayer)player);
                });
                return bukkit;
            }
        }
        return null;
    }

    public boolean removeAdvancement(NamespacedKey key) {
        File file = new File(CraftMagicNumbers.getBukkitDataPackFolder(), "data" + File.separator + key.getNamespace() + File.separator + "advancements" + File.separator + key.getKey() + ".json");
        return file.delete();
    }

    public void checkSupported(PluginDescriptionFile pdf) throws InvalidPluginException {
        String minimumVersion = MinecraftServer.getServer().server.minimumAPI;
        int minimumIndex = SUPPORTED_API.indexOf(minimumVersion);
        if (pdf.getAPIVersion() != null) {
            int pluginIndex = SUPPORTED_API.indexOf(pdf.getAPIVersion());
            if (pluginIndex == -1) {
                throw new InvalidPluginException("Unsupported API version " + pdf.getAPIVersion());
            }
            if (pluginIndex < minimumIndex) {
                throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
            }
        } else if (minimumIndex == -1) {
            CraftLegacy.init();
            Bukkit.getLogger().log(Level.WARNING, "Legacy plugin " + pdf.getFullName() + " does not specify an api-version.");
        } else {
            throw new InvalidPluginException("Plugin API version " + pdf.getAPIVersion() + " is lower than the minimum allowed version. Please update or replace it.");
        }
    }

    public static boolean isLegacy(PluginDescriptionFile pdf) {
        return pdf.getAPIVersion() == null;
    }

    public byte[] processClass(PluginDescriptionFile pdf, String path, byte[] clazz) {
        try {
            clazz = Commodore.convert(clazz, !CraftMagicNumbers.isLegacy(pdf));
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Fatal error trying to convert " + pdf.getFullName() + ":" + path, ex);
        }
        return clazz;
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(Material material, EquipmentSlot slot) {
        ImmutableMultimap.Builder defaultAttributes = ImmutableMultimap.builder();
        Multimap<AttributeBase, net.minecraft.world.entity.ai.attributes.AttributeModifier> nmsDefaultAttributes = CraftMagicNumbers.getItem(material).a(CraftEquipmentSlot.getNMS(slot));
        for (Map.Entry mapEntry : nmsDefaultAttributes.entries()) {
            Attribute attribute = CraftAttributeMap.fromMinecraft(IRegistry.aj.b((AttributeBase)mapEntry.getKey()).toString());
            defaultAttributes.put((Object)attribute, (Object)CraftAttributeInstance.convert((net.minecraft.world.entity.ai.attributes.AttributeModifier)mapEntry.getValue(), slot));
        }
        return defaultAttributes.build();
    }

    public CreativeCategory getCreativeCategory(Material material) {
        CreativeModeTab category = CraftMagicNumbers.getItem(material).u();
        return CraftCreativeCategory.fromNMS(category);
    }

    public String getTimingsServerName() {
        return PaperConfig.timingsServerName;
    }

    public VersionFetcher getVersionFetcher() {
        return new PaperVersionFetcher();
    }

    public boolean isSupportedApiVersion(String apiVersion) {
        return apiVersion != null && SUPPORTED_API.contains(apiVersion);
    }

    public byte[] serializeItem(ItemStack item) {
        Preconditions.checkNotNull((Object)item, (Object)"null cannot be serialized");
        Preconditions.checkArgument((item.getType() != Material.AIR ? 1 : 0) != 0, (Object)"air cannot be serialized");
        return this.serializeNbtToBytes((item instanceof CraftItemStack ? ((CraftItemStack)item).handle : CraftItemStack.asNMSCopy(item)).b(new NBTTagCompound()));
    }

    public ItemStack deserializeItem(byte[] data) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        NBTTagCompound compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.h("DataVersion");
        Dynamic converted = DataConverterRegistry.a().update(DataConverterTypes.m, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, compound), dataVersion, this.getDataVersion());
        return CraftItemStack.asCraftMirror(net.minecraft.world.item.ItemStack.a((NBTTagCompound)converted.getValue()));
    }

    public byte[] serializeEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity, (Object)"null cannot be serialized");
        Preconditions.checkArgument((boolean)(entity instanceof CraftEntity), (Object)"only CraftEntities can be serialized");
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().serializeEntity(compound);
        return this.serializeNbtToBytes(compound);
    }

    public Entity deserializeEntity(byte[] data, World world, boolean preserveUUID) {
        Preconditions.checkNotNull((Object)data, (Object)"null cannot be deserialized");
        Preconditions.checkArgument((data.length > 0 ? 1 : 0) != 0, (Object)"cannot deserialize nothing");
        NBTTagCompound compound = this.deserializeNbtFromBytes(data);
        int dataVersion = compound.h("DataVersion");
        Dynamic converted = DataConverterRegistry.a().update(DataConverterTypes.p, new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, compound), dataVersion, this.getDataVersion());
        compound = (NBTTagCompound)converted.getValue();
        if (!preserveUUID) {
            compound.r("UUID");
        }
        return EntityTypes.a(compound, (net.minecraft.world.level.World)((CraftWorld)world).getHandle()).orElseThrow(() -> new IllegalArgumentException("An ID was not found for the data. Did you downgrade?")).getBukkitEntity();
    }

    private byte[] serializeNbtToBytes(NBTTagCompound compound) {
        compound.a("DataVersion", this.getDataVersion());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTCompressedStreamTools.a(compound, outputStream);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return outputStream.toByteArray();
    }

    private NBTTagCompound deserializeNbtFromBytes(byte[] data) {
        NBTTagCompound compound;
        try {
            compound = NBTCompressedStreamTools.a(new ByteArrayInputStream(data));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        int dataVersion = compound.h("DataVersion");
        Preconditions.checkArgument((dataVersion <= this.getDataVersion() ? 1 : 0) != 0, (Object)"Newer version! Server downgrades are not supported!");
        return compound;
    }

    public String getTranslationKey(Material mat) {
        if (mat.isBlock()) {
            return CraftMagicNumbers.getBlock(mat).h();
        }
        return CraftMagicNumbers.getItem(mat).a();
    }

    public String getTranslationKey(org.bukkit.block.Block block) {
        return ((CraftBlock)block).getNMS().b().h();
    }

    public String getTranslationKey(EntityType type) {
        return EntityTypes.a(type.getName()).map(EntityTypes::g).orElse(null);
    }

    public String getTranslationKey(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy(itemStack);
        return nmsItemStack.c().j(nmsItemStack);
    }

    public int nextEntityId() {
        return net.minecraft.world.entity.Entity.nextEntityId();
    }

    public <T extends Keyed> Registry<T> registryFor(Class<T> classOfT) {
        return PaperRegistry.getRegistry(classOfT);
    }

    public ItemRarity getItemRarity(Material material) {
        Item item = CraftMagicNumbers.getItem(material);
        if (item == null) {
            throw new IllegalArgumentException(material + " is not an item, and rarity does not apply to blocks");
        }
        return ItemRarity.values()[item.c.ordinal()];
    }

    public ItemRarity getItemStackRarity(ItemStack itemStack) {
        return ItemRarity.values()[CraftMagicNumbers.getItem(itemStack.getType()).n(CraftItemStack.asNMSCopy(itemStack)).ordinal()];
    }

    public boolean isValidRepairItemStack(ItemStack itemToBeRepaired, ItemStack repairMaterial) {
        if (!itemToBeRepaired.getType().isItem() || !repairMaterial.getType().isItem()) {
            return false;
        }
        return CraftMagicNumbers.getItem(itemToBeRepaired.getType()).a(CraftItemStack.asNMSCopy(itemToBeRepaired), CraftItemStack.asNMSCopy(repairMaterial));
    }

    public Multimap<Attribute, AttributeModifier> getItemAttributes(Material material, EquipmentSlot equipmentSlot) {
        Item item = CraftMagicNumbers.getItem(material);
        if (item == null) {
            throw new IllegalArgumentException(material + " is not an item and therefore does not have attributes");
        }
        ImmutableMultimap.Builder attributeMapBuilder = ImmutableMultimap.builder();
        item.a(CraftEquipmentSlot.getNMS(equipmentSlot)).forEach((attributeBase, attributeModifier) -> attributeMapBuilder.put((Object)CraftAttributeMap.fromMinecraft(IRegistry.aj.b((AttributeBase)attributeBase).toString()), (Object)CraftAttributeInstance.convert(attributeModifier, equipmentSlot)));
        return attributeMapBuilder.build();
    }

    public int getProtocolVersion() {
        return SharedConstants.b().getProtocolVersion();
    }

    public boolean hasDefaultEntityAttributes(NamespacedKey bukkitEntityKey) {
        return AttributeDefaults.b(IRegistry.W.a(CraftNamespacedKey.toMinecraft(bukkitEntityKey)));
    }

    public Attributable getDefaultEntityAttributes(NamespacedKey bukkitEntityKey) {
        Preconditions.checkArgument((boolean)this.hasDefaultEntityAttributes(bukkitEntityKey), (Object)(bukkitEntityKey + " doesn't have default attributes"));
        AttributeProvider supplier = AttributeDefaults.a(IRegistry.W.a(CraftNamespacedKey.toMinecraft(bukkitEntityKey)));
        return new UnmodifiableAttributeMap(supplier);
    }

    public boolean isCollidable(Material material) {
        Preconditions.checkArgument((boolean)material.isBlock(), (Object)(material + " is not a block"));
        return CraftMagicNumbers.getBlock((Material)material).aG;
    }

    static {
        for (EntityType type : EntityType.values()) {
            if (type == EntityType.UNKNOWN) continue;
            ENTITY_TYPE_ENTITY_TYPES.put(type, IRegistry.W.a(CraftNamespacedKey.toMinecraft(type.getKey())));
            ENTITY_TYPES_ENTITY_TYPE.put(IRegistry.W.a(CraftNamespacedKey.toMinecraft(type.getKey())), type);
        }
        for (Block block2 : IRegistry.U) {
            BLOCK_MATERIAL.put(block2, Material.getMaterial((String)IRegistry.U.b(block2).a().toUpperCase(Locale.ROOT)));
        }
        for (Item item2 : IRegistry.X) {
            ITEM_MATERIAL.put(item2, Material.getMaterial((String)IRegistry.X.b(item2).a().toUpperCase(Locale.ROOT)));
        }
        for (FluidType fluid2 : IRegistry.S) {
            FLUID_MATERIAL.put(fluid2, (Fluid)Registry.FLUID.get(CraftNamespacedKey.fromMinecraft(IRegistry.S.b(fluid2))));
        }
        for (Material material : Material.values()) {
            if (material.isLegacy()) continue;
            MinecraftKey key = CraftMagicNumbers.key(material);
            IRegistry.X.b(key).ifPresent(item -> MATERIAL_ITEM.put(material, (Item)item));
            IRegistry.U.b(key).ifPresent(block -> MATERIAL_BLOCK.put(material, (Block)block));
            IRegistry.S.b(key).ifPresent(fluid -> MATERIAL_FLUID.put(material, (FluidType)fluid));
        }
        SUPPORTED_API = Arrays.asList("1.13", "1.14", "1.15", "1.16", "1.17", "1.18");
    }

    public static class NBT {
        public static final int TAG_END = 0;
        public static final int TAG_BYTE = 1;
        public static final int TAG_SHORT = 2;
        public static final int TAG_INT = 3;
        public static final int TAG_LONG = 4;
        public static final int TAG_FLOAT = 5;
        public static final int TAG_DOUBLE = 6;
        public static final int TAG_BYTE_ARRAY = 7;
        public static final int TAG_STRING = 8;
        public static final int TAG_LIST = 9;
        public static final int TAG_COMPOUND = 10;
        public static final int TAG_INT_ARRAY = 11;
        public static final int TAG_ANY_NUMBER = 99;
    }
}

