/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.util;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.annotation.Nonnull;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.bukkit.Material;
import org.bukkit.plugin.AuthorNagException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class Commodore {
    private static final Set<String> EVIL = new HashSet<String>(Arrays.asList("org/bukkit/World (III)I getBlockTypeIdAt", "org/bukkit/World (Lorg/bukkit/Location;)I getBlockTypeIdAt", "org/bukkit/block/Block ()I getTypeId", "org/bukkit/block/Block (I)Z setTypeId", "org/bukkit/block/Block (IZ)Z setTypeId", "org/bukkit/block/Block (IBZ)Z setTypeIdAndData", "org/bukkit/block/Block (B)V setData", "org/bukkit/block/Block (BZ)V setData", "org/bukkit/inventory/ItemStack ()I getTypeId", "org/bukkit/inventory/ItemStack (I)V setTypeId"));
    private static final Map<String, String> SEARCH_AND_REMOVE = Commodore.initReplacementsMap();

    private static Map<String, String> initReplacementsMap() {
        HashMap<String, String> getAndRemove = new HashMap<String, String>();
        getAndRemove.put("org/bukkit/".concat("craftbukkit/libs/it/unimi/dsi/fastutil/"), "org/bukkit/".concat("craftbukkit/libs/"));
        if (Boolean.getBoolean("debug.rewriteForIde")) {
            String NMS_REVISION_PACKAGE = "v1_16_R3/";
            getAndRemove.put("net/minecraft/".concat("server/v1_16_R3/"), "v1_16_R3/");
            getAndRemove.put("org/bukkit/".concat("craftbukkit/v1_16_R3/"), "v1_16_R3/");
        }
        return getAndRemove;
    }

    @Nonnull
    private static String getOriginalOrRewrite(@Nonnull String original) {
        String rewrite = null;
        for (Map.Entry<String, String> entry : SEARCH_AND_REMOVE.entrySet()) {
            if (!original.contains(entry.getKey())) continue;
            rewrite = original.replace(entry.getValue(), "");
        }
        return rewrite != null ? rewrite : original;
    }

    public static void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec inputFlag = parser.acceptsAll(Arrays.asList("i", "input")).withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputFlag = parser.acceptsAll(Arrays.asList("o", "output")).withRequiredArg().ofType(File.class).required();
        OptionSet options = parser.parse(args);
        File input = (File)options.valueOf((OptionSpec)inputFlag);
        File output = (File)options.valueOf((OptionSpec)outputFlag);
        if (input.isDirectory()) {
            if (!output.isDirectory()) {
                System.err.println("If input directory specified, output directory required too");
                return;
            }
            for (File in : input.listFiles()) {
                if (!in.getName().endsWith(".jar")) continue;
                Commodore.convert(in, new File(output, in.getName()));
            }
        } else {
            Commodore.convert(input, output);
        }
    }

    private static void convert(File in, File out) {
        System.out.println("Attempting to convert " + in + " to " + out);
        try (JarFile inJar = new JarFile(in, false);){
            JarEntry entry = inJar.getJarEntry(".commodore");
            if (entry != null) {
                return;
            }
            try (JarOutputStream outJar = new JarOutputStream(new FileOutputStream(out));){
                Enumeration<JarEntry> entries = inJar.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    InputStream is = inJar.getInputStream(entry);
                    try {
                        byte[] b2 = ByteStreams.toByteArray((InputStream)is);
                        if (entry.getName().endsWith(".class")) {
                            b2 = Commodore.convert(b2, false);
                            entry = new JarEntry(entry.getName());
                        }
                        outJar.putNextEntry(entry);
                        outJar.write(b2);
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                outJar.putNextEntry(new ZipEntry(".commodore"));
            }
        }
        catch (Exception ex) {
            System.err.println("Fatal error trying to convert " + in);
            ex.printStackTrace();
        }
    }

    public static byte[] convert(byte[] b2, final boolean modern) {
        ClassReader cr = new ClassReader(b2);
        ClassWriter cw = new ClassWriter(cr, 0);
        cr.accept(new ClassVisitor(589824, (ClassVisitor)cw){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                desc = Commodore.getOriginalOrRewrite(desc);
                if (signature != null) {
                    signature = Commodore.getOriginalOrRewrite(signature);
                }
                return super.visitField(access, name, desc, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitInvokeDynamicInsn(String name, String desc, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                        name = Commodore.getOriginalOrRewrite(name);
                        if (desc != null) {
                            desc = Commodore.getOriginalOrRewrite(desc);
                        }
                        super.visitInvokeDynamicInsn(name, desc, bootstrapMethodHandle, bootstrapMethodArguments);
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        type = Commodore.getOriginalOrRewrite(type);
                        super.visitTypeInsn(opcode, type);
                    }

                    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                        int i2;
                        for (i2 = 0; i2 < local.length; ++i2) {
                            if (!(local[i2] instanceof String)) continue;
                            local[i2] = Commodore.getOriginalOrRewrite((String)local[i2]);
                        }
                        for (i2 = 0; i2 < stack.length; ++i2) {
                            if (!(stack[i2] instanceof String)) continue;
                            stack[i2] = Commodore.getOriginalOrRewrite((String)stack[i2]);
                        }
                        super.visitFrame(type, nLocal, local, nStack, stack);
                    }

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        descriptor = Commodore.getOriginalOrRewrite(descriptor);
                        super.visitLocalVariable(name, descriptor, signature, start, end, index);
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        owner = Commodore.getOriginalOrRewrite(owner);
                        if (desc != null) {
                            desc = Commodore.getOriginalOrRewrite(desc);
                        }
                        if (owner.equals("org/bukkit/block/Biome")) {
                            switch (name) {
                                case "NETHER": {
                                    super.visitFieldInsn(opcode, owner, "NETHER_WASTES", desc);
                                    return;
                                }
                                case "TALL_BIRCH_FOREST": {
                                    super.visitFieldInsn(opcode, owner, "OLD_GROWTH_BIRCH_FOREST", desc);
                                    return;
                                }
                                case "GIANT_TREE_TAIGA": {
                                    super.visitFieldInsn(opcode, owner, "OLD_GROWTH_PINE_TAIGA", desc);
                                    return;
                                }
                                case "GIANT_SPRUCE_TAIGA": {
                                    super.visitFieldInsn(opcode, owner, "OLD_GROWTH_SPRUCE_TAIGA", desc);
                                    return;
                                }
                                case "SNOWY_TUNDRA": {
                                    super.visitFieldInsn(opcode, owner, "SNOWY_PLAINS", desc);
                                    return;
                                }
                                case "JUNGLE_EDGE": {
                                    super.visitFieldInsn(opcode, owner, "SPARSE_JUNGLE", desc);
                                    return;
                                }
                                case "STONE_SHORE": {
                                    super.visitFieldInsn(opcode, owner, "STONY_SHORE", desc);
                                    return;
                                }
                                case "MOUNTAINS": {
                                    super.visitFieldInsn(opcode, owner, "WINDSWEPT_HILLS", desc);
                                    return;
                                }
                                case "WOODED_MOUNTAINS": {
                                    super.visitFieldInsn(opcode, owner, "WINDSWEPT_FOREST", desc);
                                    return;
                                }
                                case "GRAVELLY_MOUNTAINS": {
                                    super.visitFieldInsn(opcode, owner, "WINDSWEPT_GRAVELLY_HILLS", desc);
                                    return;
                                }
                                case "SHATTERED_SAVANNA": {
                                    super.visitFieldInsn(opcode, owner, "WINDSWEPT_SAVANNA", desc);
                                    return;
                                }
                                case "WOODED_BADLANDS_PLATEAU": {
                                    super.visitFieldInsn(opcode, owner, "WOODED_BADLANDS", desc);
                                    return;
                                }
                            }
                        }
                        if (owner.equals("org/bukkit/entity/EntityType")) {
                            switch (name) {
                                case "PIG_ZOMBIE": {
                                    super.visitFieldInsn(opcode, owner, "ZOMBIFIED_PIGLIN", desc);
                                    return;
                                }
                            }
                        }
                        if (owner.equals("org/bukkit/loot/LootTables")) {
                            switch (name) {
                                case "ZOMBIE_PIGMAN": {
                                    super.visitFieldInsn(opcode, owner, "ZOMBIFIED_PIGLIN", desc);
                                    return;
                                }
                            }
                        }
                        if (modern) {
                            if (owner.equals("org/bukkit/Material")) {
                                switch (name) {
                                    case "CACTUS_GREEN": {
                                        name = "GREEN_DYE";
                                        break;
                                    }
                                    case "DANDELION_YELLOW": {
                                        name = "YELLOW_DYE";
                                        break;
                                    }
                                    case "ROSE_RED": {
                                        name = "RED_DYE";
                                        break;
                                    }
                                    case "SIGN": {
                                        name = "OAK_SIGN";
                                        break;
                                    }
                                    case "WALL_SIGN": {
                                        name = "OAK_WALL_SIGN";
                                        break;
                                    }
                                    case "ZOMBIE_PIGMAN_SPAWN_EGG": {
                                        name = "ZOMBIFIED_PIGLIN_SPAWN_EGG";
                                        break;
                                    }
                                    case "GRASS_PATH": {
                                        name = "DIRT_PATH";
                                    }
                                }
                            }
                            super.visitFieldInsn(opcode, owner, name, desc);
                            return;
                        }
                        if (owner.equals("org/bukkit/Material")) {
                            try {
                                Material.valueOf((String)("LEGACY_" + name));
                            }
                            catch (IllegalArgumentException ex) {
                                throw new AuthorNagException("No legacy enum constant for " + name + ". Did you forget to define a modern (1.13+) api-version in your plugin.yml?");
                            }
                            super.visitFieldInsn(opcode, owner, "LEGACY_" + name, desc);
                            return;
                        }
                        if (owner.equals("org/bukkit/Art")) {
                            switch (name) {
                                case "BURNINGSKULL": {
                                    super.visitFieldInsn(opcode, owner, "BURNING_SKULL", desc);
                                    return;
                                }
                                case "DONKEYKONG": {
                                    super.visitFieldInsn(opcode, owner, "DONKEY_KONG", desc);
                                    return;
                                }
                            }
                        }
                        if (owner.equals("org/bukkit/DyeColor")) {
                            switch (name) {
                                case "SILVER": {
                                    super.visitFieldInsn(opcode, owner, "LIGHT_GRAY", desc);
                                    return;
                                }
                            }
                        }
                        if (owner.equals("org/bukkit/Particle")) {
                            switch (name) {
                                case "BLOCK_CRACK": 
                                case "BLOCK_DUST": 
                                case "FALLING_DUST": {
                                    super.visitFieldInsn(opcode, owner, "LEGACY_" + name, desc);
                                    return;
                                }
                            }
                        }
                        super.visitFieldInsn(opcode, owner, name, desc);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        if (owner.equals("org/bukkit/map/MapView") && name.equals("getId") && desc.equals("()S")) {
                            super.visitMethodInsn(opcode, owner, name, "()I", itf);
                            return;
                        }
                        if ((owner.equals("org/bukkit/Bukkit") || owner.equals("org/bukkit/Server")) && name.equals("getMap") && desc.equals("(S)Lorg/bukkit/map/MapView;")) {
                            super.visitMethodInsn(opcode, owner, name, "(I)Lorg/bukkit/map/MapView;", itf);
                            return;
                        }
                        owner = Commodore.getOriginalOrRewrite(owner);
                        if (desc != null) {
                            desc = Commodore.getOriginalOrRewrite(desc);
                        }
                        if (modern) {
                            if (owner.equals("org/bukkit/Material")) {
                                switch (name) {
                                    case "values": {
                                        super.visitMethodInsn(opcode, "org/bukkit/craftbukkit/v1_18_R2/util/CraftLegacy", "modern_" + name, desc, itf);
                                        return;
                                    }
                                    case "ordinal": {
                                        super.visitMethodInsn(184, "org/bukkit/craftbukkit/v1_18_R2/util/CraftLegacy", "modern_" + name, "(Lorg/bukkit/Material;)I", false);
                                        return;
                                    }
                                }
                            }
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                            return;
                        }
                        if (owner.equals("org/bukkit/ChunkSnapshot") && name.equals("getBlockData") && desc.equals("(III)I")) {
                            super.visitMethodInsn(opcode, owner, "getData", desc, itf);
                            return;
                        }
                        Type retType = Type.getReturnType((String)desc);
                        if (EVIL.contains(owner + " " + desc + " " + name) || owner.startsWith("org/bukkit/block/") && (desc + " " + name).equals("()I getTypeId") || owner.startsWith("org/bukkit/block/") && (desc + " " + name).equals("(I)Z setTypeId") || owner.startsWith("org/bukkit/block/") && (desc + " " + name).equals("()Lorg/bukkit/Material; getType")) {
                            Type[] args = Type.getArgumentTypes((String)desc);
                            Type[] newArgs = new Type[args.length + 1];
                            newArgs[0] = Type.getObjectType((String)owner);
                            System.arraycopy(args, 0, newArgs, 1, args.length);
                            super.visitMethodInsn(184, "org/bukkit/craftbukkit/v1_18_R2/legacy/CraftEvil", name, Type.getMethodDescriptor((Type)retType, (Type[])newArgs), false);
                            return;
                        }
                        if (owner.equals("org/bukkit/DyeColor") && name.equals("valueOf") && desc.equals("(Ljava/lang/String;)Lorg/bukkit/DyeColor;")) {
                            super.visitMethodInsn(opcode, owner, "legacyValueOf", desc, itf);
                            return;
                        }
                        if (owner.equals("org/bukkit/Material")) {
                            if (name.equals("getMaterial") && desc.equals("(I)Lorg/bukkit/Material;")) {
                                super.visitMethodInsn(opcode, "org/bukkit/craftbukkit/v1_18_R2/legacy/CraftEvil", name, desc, itf);
                                return;
                            }
                            switch (name) {
                                case "values": 
                                case "valueOf": 
                                case "getMaterial": 
                                case "matchMaterial": {
                                    super.visitMethodInsn(opcode, "org/bukkit/craftbukkit/v1_18_R2/legacy/CraftLegacy", name, desc, itf);
                                    return;
                                }
                                case "ordinal": {
                                    super.visitMethodInsn(184, "org/bukkit/craftbukkit/v1_18_R2/legacy/CraftLegacy", "ordinal", "(Lorg/bukkit/Material;)I", false);
                                    return;
                                }
                                case "name": 
                                case "toString": {
                                    super.visitMethodInsn(184, "org/bukkit/craftbukkit/v1_18_R2/legacy/CraftLegacy", name, "(Lorg/bukkit/Material;)Ljava/lang/String;", false);
                                    return;
                                }
                            }
                        }
                        if (retType.getSort() == 10 && retType.getInternalName().equals("org/bukkit/Material") && owner.startsWith("org/bukkit")) {
                            super.visitMethodInsn(opcode, owner, name, desc, itf);
                            super.visitMethodInsn(184, "org/bukkit/craftbukkit/v1_18_R2/legacy/CraftLegacy", "toLegacy", "(Lorg/bukkit/Material;)Lorg/bukkit/Material;", false);
                            return;
                        }
                        super.visitMethodInsn(opcode, owner, name, desc, itf);
                    }

                    public void visitLdcInsn(Object value) {
                        if (value instanceof String && ((String)value).equals("com.mysql.jdbc.Driver")) {
                            super.visitLdcInsn((Object)"com.mysql.cj.jdbc.Driver");
                            return;
                        }
                        super.visitLdcInsn(value);
                    }
                };
            }
        }, 0);
        return cw.toByteArray();
    }
}

